#pragma once

#include <passport/infra/daemons/blackbox/src/domain/idomain_fetcher.h>

#include <passport/infra/libs/cpp/utils/log/global.h>

namespace NPassport::NBb {
    class TDomainFetcherMock: public IDomainFetcher {
    public:
        TResult FindById(const TString& domid,
                         EPolicy policy = EPolicy::ReplaceAliasWithMaster) const override {
            Y_UNUSED(policy);
            if (FindByIdResults_.contains(domid)) {
                return FindByIdResults_.at(domid);
            }
            return {};
        }

        TResult FindInDb(const TString& domain,
                         bool useDomid,
                         EPolicy policy = EPolicy::ReplaceAliasWithMaster) const override {
            Y_UNUSED(domain);
            Y_UNUSED(useDomid);
            Y_UNUSED(policy);

            return {};
        }

        void SetResult(const TString& domid, TResult resultToSet = TResult()) {
            if (resultToSet) {
                FindByIdResults_.insert_or_assign(domid, resultToSet);
                return;
            }

            std::shared_ptr cache = std::make_shared<TDomainCache>();
            IDomainFetcher::TResult result(cache, DefaultDomain_.get());

            FindByIdResults_.insert_or_assign(domid, result);
        }

    private:
        std::unordered_map<TString, TResult> FindByIdResults_;
        std::unique_ptr<TDomain> DefaultDomain_ = std::make_unique<TDomain>();
    };
}
