#!/bin/sh

# ================================================================
#
# Convert a mysql database dump into something sqlite3 understands.
#
# Adapted from
# http://stackoverflow.com/questions/489277/script-to-convert-mysql-dump-sql-file-into-format-that-can-be-imported-into-sqlit
#
# (c) 2010 Martin Czygan <martin.czygan@gmail.com>
#
# ================================================================


SRC=$1
DST=$1.sqlite3.sql
DB=$1.sqlite3.db
ERR=$1.sqlite3.err

cat $DST | sqlite3 $DB > $ERR

ERRORS=`cat $ERR | wc -l`

if [ $ERRORS == 0 ]; then
echo "Conversion completed without error. Your db is ready under: $DB"
echo "\$ sqlite3 $DB"
  rm -f $ERR
else
echo "There were errors during conversion. \
Please review $ERR and $DST for details."
fi
