PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;

CREATE TABLE `token_attributes` (
  `id` INTEGER NOT NULL,
  `type` INTEGER NOT NULL,
  `value` varbinary(128) NOT NULL,
  UNIQUE (`id`, `type`)
);

--simple token
INSERT INTO token_attributes VALUES(700101, 2, '|2|');             --scope_ids
INSERT INTO token_attributes VALUES(700101, 3, '40001');           --uid
INSERT INTO token_attributes VALUES(700101, 4, '1001');            --client_id
INSERT INTO token_attributes VALUES(700101, 5, 'qqqqqqqqqqqqqqqq');--device_id
INSERT INTO token_attributes VALUES(700101, 7, '2524597200');      --expired in 2050
INSERT INTO token_attributes VALUES(700101, 10, '1610000000');     --issued in 2021

--client is glogouted in 2050
INSERT INTO token_attributes VALUES(700102, 2, '|2|');             --scope_ids
INSERT INTO token_attributes VALUES(700102, 3, '40001');           --uid
INSERT INTO token_attributes VALUES(700102, 4, '1002');            --client_id
INSERT INTO token_attributes VALUES(700102, 5, 'qqqqqqqqqqqqqqqq');--device_id
INSERT INTO token_attributes VALUES(700102, 7, '2524597200');      --expired in 2050
INSERT INTO token_attributes VALUES(700102, 10, '1610000000');     --issued in 2021

--client is glogouted in 2010
INSERT INTO token_attributes VALUES(700103, 2, '|2|');             --scope_ids
INSERT INTO token_attributes VALUES(700103, 3, '40001');           --uid
INSERT INTO token_attributes VALUES(700103, 4, '1003');            --client_id
INSERT INTO token_attributes VALUES(700103, 5, 'qqqqqqqqqqqqqqqq');--device_id
INSERT INTO token_attributes VALUES(700103, 7, '2524597200');      --expired in 2050
INSERT INTO token_attributes VALUES(700103, 10, '1610000000');     --issued in 2021
INSERT INTO token_attributes VALUES(700103, 17, 's:1234567890:123:my_custom_login_id');     --login_id field

--client is deleted in 2010
INSERT INTO token_attributes VALUES(700104, 2, '|2|');             --scope_ids
INSERT INTO token_attributes VALUES(700104, 3, '40001');           --uid
INSERT INTO token_attributes VALUES(700104, 4, '1004');            --client_id
INSERT INTO token_attributes VALUES(700104, 5, 'qqqqqqqqqqqqqqqq');--device_id
INSERT INTO token_attributes VALUES(700104, 7, '2524597200');      --expired in 2050
INSERT INTO token_attributes VALUES(700104, 10, '1610000000');     --issued in 2021

--client is deleted in 2050
INSERT INTO token_attributes VALUES(700105, 2, '|2|');             --scope_ids
INSERT INTO token_attributes VALUES(700105, 3, '40001');           --uid
INSERT INTO token_attributes VALUES(700105, 4, '1005');            --client_id
INSERT INTO token_attributes VALUES(700105, 5, 'wwwwwwwwwwwwwwww');--device_id
INSERT INTO token_attributes VALUES(700105, 7, '2524597200');      --expired in 2050
INSERT INTO token_attributes VALUES(700105, 10, '1610000000');     --issued in 2021
INSERT INTO token_attributes VALUES(700105, 14, '700110');         --xtoken_id

--client is blocked
INSERT INTO token_attributes VALUES(700106, 2, '|2|');             --scope_ids
INSERT INTO token_attributes VALUES(700106, 3, '40001');           --uid
INSERT INTO token_attributes VALUES(700106, 4, '1006');            --client_id
INSERT INTO token_attributes VALUES(700106, 5, 'ssssssssssssssss');--device_id
INSERT INTO token_attributes VALUES(700106, 7, '2524597200');      --expired in 2050
INSERT INTO token_attributes VALUES(700106, 10, '1610000000');     --issued in 2021

--client is missing
INSERT INTO token_attributes VALUES(700107, 2, '|2|');             --scope_ids
INSERT INTO token_attributes VALUES(700107, 3, '40001');           --uid
INSERT INTO token_attributes VALUES(700107, 4, '1007');            --client_id
INSERT INTO token_attributes VALUES(700107, 5, 'aaaaaaaaaaaaaaaa');--device_id
INSERT INTO token_attributes VALUES(700107, 7, '2524597200');      --expired in 2050
INSERT INTO token_attributes VALUES(700107, 10, '1610000000');     --issued in 2021

--missing in `token_by_params`
INSERT INTO token_attributes VALUES(700108, 2, '|2|');             --scope_ids
INSERT INTO token_attributes VALUES(700108, 3, '40001');           --uid
INSERT INTO token_attributes VALUES(700108, 4, '1001');            --client_id
INSERT INTO token_attributes VALUES(700108, 5, 'aaaaaaaaaaaaaaaa');--device_id
INSERT INTO token_attributes VALUES(700108, 7, '2524597200');      --expired in 2050
INSERT INTO token_attributes VALUES(700108, 10, '1610000000');     --issued in 2021

--expired by attr
INSERT INTO token_attributes VALUES(700109, 2, '|2|');             --scope_ids
INSERT INTO token_attributes VALUES(700109, 3, '40001');           --uid
INSERT INTO token_attributes VALUES(700109, 4, '1001');            --client_id
INSERT INTO token_attributes VALUES(700109, 5, 'wwwwwwwwwwwwwwww');--device_id
INSERT INTO token_attributes VALUES(700109, 7, '1620000000');      --expired in 2021.05.03
INSERT INTO token_attributes VALUES(700109, 10, '1610000000');     --issued in 2021

--xtoken
INSERT INTO token_attributes VALUES(700110, 2, '|18|');            --scope_ids
INSERT INTO token_attributes VALUES(700110, 3, '40001');           --uid
INSERT INTO token_attributes VALUES(700110, 4, '1001');            --client_id
INSERT INTO token_attributes VALUES(700110, 5, 'qqqqqqqqqqqqqqqq');--device_id
INSERT INTO token_attributes VALUES(700110, 7, '2524597200');      --expired in 2050
INSERT INTO token_attributes VALUES(700110, 10, '1610000000');     --issued in 2021

--token without client_id
INSERT INTO token_attributes VALUES(700111, 2, '|2|');             --scope_ids
INSERT INTO token_attributes VALUES(700111, 3, '40001');           --uid
INSERT INTO token_attributes VALUES(700111, 5, 'zzzzzzzzzzzzzzzz');--device_id
INSERT INTO token_attributes VALUES(700111, 7, '2524597200');      --expired in 2050
INSERT INTO token_attributes VALUES(700111, 10, '1610000000');     --issued in 2021

--uid is glogouted
INSERT INTO token_attributes VALUES(700201, 2, '|2|');             --scope_ids
INSERT INTO token_attributes VALUES(700201, 3, '40002');           --uid
INSERT INTO token_attributes VALUES(700201, 4, '1001');            --client_id
INSERT INTO token_attributes VALUES(700201, 5, 'qqqqqqqqqqqqqqqq');--device_id
INSERT INTO token_attributes VALUES(700201, 7, '2524597200');      --expired in 2050
INSERT INTO token_attributes VALUES(700201, 10, '1610000000');     --issued in 2021


CREATE TABLE `token_by_params` (
  `uid` INTEGER NOT NULL,
  `client_id` INTEGER NOT NULL,
  `scope_ids` varbinary(128) NOT NULL,
  `device_id` varbinary(128) NOT NULL,
  `id` INTEGER NOT NULL,
  UNIQUE (`uid`,`client_id`,`scope_ids`,`device_id`)
);

INSERT INTO token_by_params VALUES(40001, 1001, '|2|', 'qqqqqqqqqqqqqqqq', 700101);
INSERT INTO token_by_params VALUES(40001, 1002, '|2|', 'qqqqqqqqqqqqqqqq', 700102);
INSERT INTO token_by_params VALUES(40001, 1003, '|2|', 'qqqqqqqqqqqqqqqq', 700103);
INSERT INTO token_by_params VALUES(40001, 1004, '|2|', 'qqqqqqqqqqqqqqqq', 700104);
INSERT INTO token_by_params VALUES(40001, 1005, '|2|', 'wwwwwwwwwwwwwwww', 700105);
INSERT INTO token_by_params VALUES(40001, 1006, '|2|', 'ssssssssssssssss', 700106);
INSERT INTO token_by_params VALUES(40001, 1007, '|2|', 'aaaaaaaaaaaaaaaa', 700107);
--700108 is missing in `token_by_params`
INSERT INTO token_by_params VALUES(40001, 1001, '|2|', 'wwwwwwwwwwwwwwww', 700109);
INSERT INTO token_by_params VALUES(40001, 1001, '|18|', 'qqqqqqqqqqqqqqqq', 700110);
INSERT INTO token_by_params VALUES(40001, 1001, '|2|', 'zzzzzzzzzzzzzzzz', 700111);
INSERT INTO token_by_params VALUES(40002, 1001, '|2|', 'qqqqqqqqqqqqqqqq', 700201);

COMMIT;
