PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;

CREATE TABLE IF NOT EXISTS "keyspaces" (
  "groupid" integer NOT NULL,
  "domainsuff" varchar(50) NOT NULL default '',
  "tablename" varchar(30) NOT NULL default 'randoms',
  "addpref" integer NOT NULL default '0',
  "inuse" integer NOT NULL default '1'
);
INSERT INTO keyspaces VALUES(1,'','randoms',0,0);
INSERT INTO keyspaces VALUES(3,'yandex_ru','randoms',0,1);
INSERT INTO keyspaces VALUES(4,'yandex_ua','randoms_ua',0,1);
INSERT INTO keyspaces VALUES(5,'yandex_kz','randoms_kz',0,1);
INSERT INTO keyspaces VALUES(8,'ndex_ru','randoms_ndx',0,1);
INSERT INTO keyspaces VALUES(11,'yandex_com','randoms_com',0,1);
INSERT INTO keyspaces VALUES(17,'yandex_by','randoms_by',0,1);
INSERT INTO keyspaces VALUES(21,'yandex_com_tr','randoms_comtr',0,1);
INSERT INTO keyspaces VALUES(22,'cookiel','lrandoms',0,1);
INSERT INTO keyspaces VALUES(23,'oauth','randoms_oauth',0,1);
INSERT INTO keyspaces VALUES(24,'signsmth','randoms_signsmth',0,1);
INSERT INTO keyspaces VALUES(25,'signsmth_long','randoms_signsmth_long',0,1);
INSERT INTO keyspaces VALUES(1000,'guard_passport','randoms_guard_passport',0,1);

CREATE TABLE IF NOT EXISTS "randoms" (
  "id" integer NOT NULL,
  "keybody" varchar(20) NOT NULL default '0',
  "start" timestamp NOT NULL default CURRENT_TIMESTAMP
);
INSERT INTO randoms VALUES(33133,'9.93764605468403e+18','2011-02-17 11:00:01');
INSERT INTO randoms VALUES(33132,'6667698838750429184','2011-02-17 10:00:01');
INSERT INTO randoms VALUES(33131,'1912610360595120128','2011-02-17 09:00:01');
INSERT INTO randoms VALUES(33130,'1.5007876486873e+19','2011-02-17 08:00:01');
INSERT INTO randoms VALUES(33129,'1.66133529616781e+19','2011-02-17 07:00:01');

CREATE TABLE IF NOT EXISTS "randoms_ua" (
  "id" integer NOT NULL,
  "keybody" varchar(20) NOT NULL default '0',
  "start" timestamp NOT NULL default CURRENT_TIMESTAMP
);
INSERT INTO randoms_ua VALUES(32922,'1156645865691545600','2011-02-17 10:00:01');
INSERT INTO randoms_ua VALUES(32920,'7129752378541604864','2011-02-17 08:00:01');
INSERT INTO randoms_ua VALUES(32921,'4616314474422861824','2011-02-17 09:00:01');
INSERT INTO randoms_ua VALUES(32919,'1.73771214686126e+19','2011-02-17 07:00:01');
INSERT INTO randoms_ua VALUES(32923,'1.72144918103951e+19','2011-02-17 11:00:01');

CREATE TABLE IF NOT EXISTS "randoms_kz" (
  "id" integer NOT NULL,
  "keybody" varchar(20) NOT NULL default '0',
  "start" timestamp NOT NULL default CURRENT_TIMESTAMP
);
INSERT INTO randoms_kz VALUES(8811,'762066489101713408','2011-02-17 08:00:01');
INSERT INTO randoms_kz VALUES(8813,'1.77374098029126e+19','2011-02-17 10:00:01');
INSERT INTO randoms_kz VALUES(8810,'3558320825656606720','2011-02-17 07:00:01');
INSERT INTO randoms_kz VALUES(8812,'2874433037085638656','2011-02-17 09:00:01');
INSERT INTO randoms_kz VALUES(8814,'8863413233665638400','2011-02-17 11:00:01');

CREATE TABLE IF NOT EXISTS "randoms_com" (
  "id" integer NOT NULL,
  "keybody" varchar(20) NOT NULL default '0',
  "start" timestamp NOT NULL default CURRENT_TIMESTAMP
);
INSERT INTO randoms_com VALUES(8811,'1.35738778640361e+19','2011-02-17 08:00:01');
INSERT INTO randoms_com VALUES(8813,'708626851574644736','2011-02-17 10:00:01');
INSERT INTO randoms_com VALUES(8810,'245930484338065408','2011-02-17 07:00:01');
INSERT INTO randoms_com VALUES(8812,'3603304899202842624','2011-02-17 09:00:01');
INSERT INTO randoms_com VALUES(8814,'6390298259770376192','2011-02-17 11:00:01');

CREATE TABLE IF NOT EXISTS "randoms_by" (
  "id" integer NOT NULL,
  "keybody" varchar(20) NOT NULL default '0',
  "start" timestamp NOT NULL default CURRENT_TIMESTAMP
);
INSERT INTO randoms_by VALUES(8811,'9.30790606905941e+18','2011-02-17 08:00:01');
INSERT INTO randoms_by VALUES(8813,'1.07776213291723e+19','2011-02-17 10:00:01');
INSERT INTO randoms_by VALUES(8810,'5074079354799849472','2011-02-17 07:00:01');
INSERT INTO randoms_by VALUES(8812,'5130779099270021120','2011-02-17 09:00:01');
INSERT INTO randoms_by VALUES(8814,'1247177388559499264','2011-02-17 11:00:01');

CREATE TABLE IF NOT EXISTS "randoms_ndx" (
  "id" integer NOT NULL,
  "keybody" varchar(20) NOT NULL default '0',
  "start" timestamp NOT NULL default CURRENT_TIMESTAMP
);
INSERT INTO randoms_ndx VALUES(8833,'1.06772120710758e+19','2011-02-18 09:00:01');
INSERT INTO randoms_ndx VALUES(8835,'2985468566460694528','2011-02-18 11:00:01');
INSERT INTO randoms_ndx VALUES(8834,'7950476586275045376','2011-02-18 10:00:01');
INSERT INTO randoms_ndx VALUES(8837,'1.24189125003494e+19','2011-02-18 13:00:02');
INSERT INTO randoms_ndx VALUES(8836,'4814375751174062080','2011-02-18 12:00:01');

CREATE TABLE IF NOT EXISTS "randoms_comtr" (
  "id" integer NOT NULL,
  "keybody" varchar(20) NOT NULL default '0',
  "start" timestamp NOT NULL default CURRENT_TIMESTAMP
);
INSERT INTO randoms_comtr VALUES(332,'3770664510051909632','2011-02-18 09:00:01');
INSERT INTO randoms_comtr VALUES(333,'1.66223199066171e+19','2011-02-18 10:00:01');
INSERT INTO randoms_comtr VALUES(334,'373025133269417984','2011-02-18 11:00:01');
INSERT INTO randoms_comtr VALUES(335,'8050176546625880064','2011-02-18 12:00:01');
INSERT INTO randoms_comtr VALUES(336,'1.19198505889285e+19','2011-02-18 13:00:02');

CREATE TABLE IF NOT EXISTS "randoms_oauth" (
  "id" integer NOT NULL PRIMARY KEY,
  "keybody" varbinary(255) NOT NULL default '0',
  "start" timestamp NOT NULL default CURRENT_TIMESTAMP
);
INSERT INTO randoms_oauth VALUES(12345,'172229c14bc525fc8f46f1eb8cfd05332f6988b7771aa72d4f5403489404c012','2017-03-01 21:42:36');
INSERT INTO randoms_oauth VALUES(12346,'4142c4a8f84d729f7fc6d69217c1408e4e0d64f7a01332ac7e32bd5f9dc52628','2017-03-01 21:43:02');
INSERT INTO randoms_oauth VALUES(12347,'57ced903ec8f495fffb3dd8053b730863dafdaa6bac374328cadd4e37d878f4a','2017-03-01 21:43:28');
INSERT INTO randoms_oauth VALUES(12348,'68021b697c649444874f46ff354c6fda6bd1161fe84c90733d8fe0c7179f559a','2017-03-01 21:43:48');
INSERT INTO randoms_oauth VALUES(12349,'2a578d9ff2ab227f7ac9f745a2bdf88e246c987d87edea7b5976cf35e5727843','2017-03-01 21:44:04');
INSERT INTO randoms_oauth VALUES(12350,'22fe3fc10d0ce69d0e6589fcc1a6afa88f4e4f2705122bb368a800fbeb21993a','2017-03-01 21:44:30');

CREATE TABLE IF NOT EXISTS "randoms_signsmth" (
  "id" integer NOT NULL PRIMARY KEY,
  "keybody" varbinary(255) NOT NULL default '0',
  "start" timestamp NOT NULL default CURRENT_TIMESTAMP
);
INSERT INTO randoms_signsmth VALUES(248100,'1e30e1aea2d2a41af56e79d6f731d3220aa4f1debf92e8d696b7397253678bf5','2017-11-15 16:36:05');
INSERT INTO randoms_signsmth VALUES(248101,'752b0d132dec2901fe08fa9b8cfa4a32674f59e21f258730e8f0868e1a1d4f59','2017-11-15 16:35:47');
INSERT INTO randoms_signsmth VALUES(248102,'e3a99b946a812b98b5cc6f678b2bf0102eac5a8f2250fdcab5abdba7e0b87d31','2017-11-15 16:35:32');
INSERT INTO randoms_signsmth VALUES(248105,'1a178557fb51366cdaeb6369cf9063ef59c6682c6f37596ef63bf04cf9cf7cd4','2017-11-15 16:35:22');
INSERT INTO randoms_signsmth VALUES(248106,'8e7bebcdf12efe7219c1aba75ffff96c2c5a81514c64c5770624e3910a8c3e64','2017-11-15 16:35:11');

CREATE TABLE IF NOT EXISTS "randoms_signsmth_long" (
  "id" integer NOT NULL PRIMARY KEY,
  "keybody" varbinary(255) NOT NULL default '0',
  "start" timestamp NOT NULL default CURRENT_TIMESTAMP
);
INSERT INTO randoms_signsmth_long VALUES(527302,'51d792168a3147d9855eae18f783ca045793bff930a13fa1d1999b9987c93218','2019-11-15 16:36:05');
INSERT INTO randoms_signsmth_long VALUES(527304,'acf1581b25796855ed9d86a4e7b0aa2680c6a6df62092bf1910c8fb3f6703f1b','2019-11-15 16:35:47');
INSERT INTO randoms_signsmth_long VALUES(527306,'08d8a81a48e4b591b9f5aec98fc4fa13b3419be41f00aa5ae59d3ce2364ae2cd','2019-11-15 16:35:32');
INSERT INTO randoms_signsmth_long VALUES(527309,'7a8bd31162c5182f9ba6a3703ed033d031471b878691b03ae1a74fdeeb6928fb','2019-11-15 16:35:22');
INSERT INTO randoms_signsmth_long VALUES(527310,'65da31d8baa93dfb681b86ff8ef7e633d155126f8e0af6f8839354a5eb332c85','2019-11-15 16:35:11');

CREATE TABLE IF NOT EXISTS "randoms_guard_passport" (
  "id" integer NOT NULL PRIMARY KEY,
  "keybody" varbinary(255) NOT NULL default '0',
  "start" timestamp NOT NULL default CURRENT_TIMESTAMP
);
INSERT INTO randoms_guard_passport VALUES(527302,'51d792168a3147d9855eae18f783ca045793bff930a13fa1d1999b9987c93218','2019-11-15 16:36:05');

CREATE TABLE IF NOT EXISTS 'lrandoms' (
"id" integer NOT NULL,
"keybody"  varchar(64) NOT NULL default '0',
"start" datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
"valid" datetime NOT NULL DEFAULT '0000-00-00 00:00:00');
INSERT INTO lrandoms VALUES(1002323,'2dL9OKKqcKHbljKQI70PMaaB7R08VnEn3jo5iAI62gPeCQ5zgI5fjjczFOMRvvaQ','2011-02-09 07:00:01',0);
INSERT INTO lrandoms VALUES(1,'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa','2012-02-09 08:00:01',0);
INSERT INTO lrandoms VALUES(2,'bbb','2013-02-09 09:00:01',0);
INSERT INTO lrandoms VALUES(959,'eBTdJvb3gcZUBoYXwcOrYeTweLyiLfRjNbj3X7ULfRZrchvo0tXK776OdyAG46DT','2014-02-09 09:00:01',0);


CREATE TABLE `hosts` (
  `host_id` integer NOT NULL,
  `host_ip` varchar(16) default NULL,
  `host_name` varchar(255) default NULL,
  `db_id` varchar(40) default NULL,
  `sid` integer NOT NULL default '0',
  `prio` integer NOT NULL default '0',
  `host_number` integer NOT NULL default '0',
  `mx` varchar(30) default NULL
);
INSERT INTO hosts VALUES(80,NULL,NULL,'maildb9',2,2500,0,'mx1.yandex.ru');
INSERT INTO hosts VALUES(306,NULL,NULL,'maildb18',2,50,0,'mx1.yandex.ru');
INSERT INTO hosts VALUES(1234,NULL,NULL,'testpg',2,50,0,'mx.yandex.ru');
INSERT INTO hosts VALUES(20,'213.180.199.6','w6.www.narod.ru','maildb',4,50,6,'mx1.yandex.ru');

CREATE TABLE `domains_events` (
  `id` int(11) NOT NULL,
  `type` tinyint(4) NOT NULL,
  `domain` varchar(80) NOT NULL default '',
  `created` timestamp NOT NULL default CURRENT_TIMESTAMP
);

CREATE TABLE `hosted_domains` (
  `domid` int(20) NOT NULL,
  `domain` varchar(80) NOT NULL default '',
  `admin` bigint(20) NOT NULL default '0',
  `mx` tinyint(4) NOT NULL default '0',
  `default_uid` bigint(20) NOT NULL default '0',
  `master_domain` varchar(80) NOT NULL default '',
  `ena` tinyint(1) NOT NULL default '0',
  `options` blob NOT NULL,
  `born_date` datetime NOT NULL default '0000-00-00 00:00:00'
);
INSERT INTO hosted_domains VALUES(1,'okna.ru',1130000000000383,0,1130000000000658,'',1,'','0000-00-00 00:00:00');
INSERT INTO hosted_domains VALUES(15,'dveri.ru',0,1,0,'',1,'','2010-03-05 11:20:49');
INSERT INTO hosted_domains VALUES(17,'disabled.ru',0,0,0,'',0,'','2010-03-05 11:20:49');
INSERT INTO hosted_domains VALUES(22,'zveri.ru',0,1,0,'dveri.ru',1,'','2010-03-05 11:20:49');

CREATE TABLE `domains_hosts` (
  `host_id` integer NOT NULL,
  `host_ip` varchar(16) default NULL,
  `host_name` varchar(255) default NULL,
  `db_id` varchar(40) default NULL,
  `sid` integer NOT NULL default '0',
  `prio` integer NOT NULL default '0',
  `host_number` integer NOT NULL default '0',
  `mx` varchar(30) default NULL
);
INSERT INTO domains_hosts VALUES(1,NULL,NULL,'mdb201',2,150,0,'-1');
INSERT INTO domains_hosts VALUES(7,NULL,NULL,'mdb667',0,170,0,'ya.ya');
INSERT INTO domains_hosts VALUES(13,NULL,NULL,'mdbd',0,1,2,'somemx.someserv.ru');
INSERT INTO domains_hosts VALUES(14,NULL,NULL,'mdb666',2,101,0,'mxc222.yandex.ru');
INSERT INTO domains_hosts VALUES(15,NULL,NULL,'333',2,111,0,'mxc22.yandex.ru');

CREATE TABLE IF NOT EXISTS "aliases" (`uid` integer NOT NULL,
`type` integer NOT NULL,
`value` varchar(128) NOT NULL default '');
INSERT INTO aliases VALUES(543,1,'test_login');
INSERT INTO aliases VALUES(543,2,'test_login2');
INSERT INTO aliases VALUES(544,1,'login2');
INSERT INTO aliases VALUES(545,1,'login3');
INSERT INTO aliases VALUES(57155,1,'malice');
INSERT INTO aliases VALUES(57155,2,'malice1');
INSERT INTO aliases VALUES(126020,1,'malice2');
INSERT INTO aliases VALUES(126020,2,'malice');
INSERT INTO aliases VALUES(1130000000000670,7,'15@kosyak');
INSERT INTO aliases VALUES(1130000000000673,7,'17@neudachnik');
INSERT INTO aliases VALUES(1130000000000674,7,'1@neudachnik');
INSERT INTO aliases VALUES(1130000000000615,7,'1@sveta.snit');
INSERT INTO aliases VALUES(1130000000000615,8,'1@abuse');
INSERT INTO aliases VALUES(1130000000000615,8,'1@info');
INSERT INTO aliases VALUES(1130000000000658,7,'1@svetasn.1');
INSERT INTO aliases VALUES(1130000000000658,8,'1@sj.alias');
INSERT INTO aliases VALUES(57155,3,'malice');
INSERT INTO aliases VALUES(126020,3,'malice2');
INSERT INTO aliases VALUES(42,1,'acc1-test');
INSERT INTO aliases VALUES(43,1,'acc2-test');
INSERT INTO aliases VALUES(44,1,'acc3-test');
INSERT INTO aliases VALUES(100500,1,'acc10-test');
INSERT INTO aliases VALUES(100501,1,'acc11-test');
INSERT INTO aliases VALUES(40001,1,'oauth-user-common');
INSERT INTO aliases VALUES(40002,1,'oauth-user-glogout');
INSERT INTO aliases VALUES(1234,8,'123/somevalue');
INSERT INTO aliases VALUES(1235,8,'123/somevalue');
INSERT INTO aliases VALUES(12345,8,'23/somevalue');
INSERT INTO aliases VALUES(132,1,'some_valid_login');
INSERT INTO aliases VALUES(133,8,'263/somevalue');
INSERT INTO aliases VALUES(133,1,'some_other_valid_login');
INSERT INTO aliases VALUES(134,8,'23/somevalue');
INSERT INTO aliases VALUES(134,1,'some_very_valid_login');

--TODO: move attributes to another file
CREATE TABLE IF NOT EXISTS "attributes" (`uid` integer NOT NULL, `type` integer NOT NULL, `value` varbinary(16000) NOT NULL default '');
INSERT INTO attributes VALUES(543,27,'Name');
INSERT INTO attributes VALUES(543,28,'Surname');
INSERT INTO attributes VALUES(543,17,90);
INSERT INTO attributes VALUES(544,27,'Name2');
INSERT INTO attributes VALUES(544,28,'Surname2');
INSERT INTO attributes VALUES(545,27,'Name3');
INSERT INTO attributes VALUES(545,28,'Surname3');
INSERT INTO attributes VALUES(57155,27,'Denis');
INSERT INTO attributes VALUES(57155,28,'Bartolome');
INSERT INTO attributes VALUES(57155,30,'1980-02-13');
INSERT INTO attributes VALUES(57155,32,'Moscow');
INSERT INTO attributes VALUES(57155,38,306);
INSERT INTO attributes VALUES(57155,31,'tr');
INSERT INTO attributes VALUES(126020,27,'None Нет');
INSERT INTO attributes VALUES(126020,28,'Malice');
INSERT INTO attributes VALUES(126020,29,'f');
INSERT INTO attributes VALUES(126020,32,'Рязань');
INSERT INTO attributes VALUES(126020,1,965245209);
INSERT INTO attributes VALUES(126020,2,'Malice2');
INSERT INTO attributes VALUES(126020,38,80);
INSERT INTO attributes VALUES(1130000000000670,27,'Kosyak');
INSERT INTO attributes VALUES(1130000000000670,28,'Dvernoy');
INSERT INTO attributes VALUES(1130000000000670,1,1267777384);
INSERT INTO attributes VALUES(1130000000000670,38,15);
INSERT INTO attributes VALUES(1130000000000673,1,1267777384);
INSERT INTO attributes VALUES(1130000000000673,38,1);
INSERT INTO attributes VALUES(1130000000000674,3,1);
INSERT INTO attributes VALUES(1130000000000674,1,1268207870);
INSERT INTO attributes VALUES(1130000000000674,38,1);
INSERT INTO attributes VALUES(1130000000000615,27,'Света');
INSERT INTO attributes VALUES(1130000000000615,28,'Снитко');
INSERT INTO attributes VALUES(1130000000000615,31,'ru');
INSERT INTO attributes VALUES(1130000000000615,1,1259592609);
INSERT INTO attributes VALUES(1130000000000615,33,'Europe/Moscow');
INSERT INTO attributes VALUES(1130000000000615,38,15);
INSERT INTO attributes VALUES(1130000000000615,6,1);
INSERT INTO attributes VALUES(1130000000000658,27,'Sveta');
INSERT INTO attributes VALUES(1130000000000658,28,'Sn1');
INSERT INTO attributes VALUES(1130000000000658,30,'1983-12-12');
INSERT INTO attributes VALUES(1130000000000658,31,'ru');
INSERT INTO attributes VALUES(1130000000000658,1,1265372514);
INSERT INTO attributes VALUES(1130000000000658,33,'Europe/Moscow');
INSERT INTO attributes VALUES(1130000000000658,38,1);
INSERT INTO attributes VALUES(1130000000000658,6,1);
INSERT INTO attributes VALUES(57155,1,978341696);
INSERT INTO attributes VALUES(126020,35,79161236789);
INSERT INTO attributes VALUES(126020,36,1136062733);
INSERT INTO attributes VALUES(57155,25,'who am i');
INSERT INTO attributes VALUES(57155,26,'looser');
INSERT INTO attributes VALUES(57155,19,'1:asdfgh');
INSERT INTO attributes VALUES(57155,21,'2:100');
INSERT INTO attributes VALUES(57155,65,100);
INSERT INTO attributes VALUES(126020,94,1);
INSERT INTO attributes VALUES(40002,4,'2524597200'); --glogout in 2050

CREATE TABLE `suid2` (`suid` integer NOT NULL, `uid` integer NOT NULL);
INSERT INTO suid2 VALUES(3433434,543);
INSERT INTO suid2 VALUES(85052,57155);
INSERT INTO suid2 VALUES(281986,126020);
INSERT INTO suid2 VALUES(1130000000001405,1130000000000615);
INSERT INTO suid2 VALUES(1130000000001559,1130000000000670);
INSERT INTO suid2 VALUES(1130000000001567,1130000000000673);
INSERT INTO suid2 VALUES(1130000000001569,1130000000000674);
INSERT INTO suid2 VALUES(1130000000001523,1130000000000658);
INSERT INTO suid2 VALUES(4323,132);
INSERT INTO suid2 VALUES(4324,12345);
INSERT INTO suid2 VALUES(4325,1235);
INSERT INTO suid2 VALUES(4326,134);
INSERT INTO suid2 VALUES(4326,134);
INSERT INTO suid2 VALUES(4327,133);
INSERT INTO suid2 VALUES(4327,133);

CREATE TABLE `domains` (
 `domain_id` int(10) NOT NULL, `master_domain_id` int(10) NOT NULL DEFAULT '0', `name` varbinary(255) NOT NULL DEFAULT '',
 `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `mx` tinyint(3) NOT NULL DEFAULT '0',
  `admin_uid` bigint(20) NOT NULL DEFAULT '0',
  `default_uid` bigint(20) NOT NULL DEFAULT '0',
  `ts` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `options` varbinary(255) NOT NULL DEFAULT '');
INSERT INTO domains VALUES(1,0,'okna.ru',1,0,1130000000000383,1130000000000658,'0000-00-00 00:00:00','');
INSERT INTO domains VALUES(15,0,'dveri.ru',1,1,0,0,'2010-03-05 11:20:49','');
INSERT INTO domains VALUES(17,0,'disabled.ru',0,0,0,0,'2010-03-05 11:20:49','');
INSERT INTO domains VALUES(22,15,'zveri.ru',1,1,0,0,'2010-03-05 11:20:48','');

CREATE TABLE `stop_words` ( `word` varchar(40) NOT NULL DEFAULT '', `ts` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`word`));
INSERT INTO stop_words VALUES('admin','2018-06-21 10:01:03');
INSERT INTO stop_words VALUES('volozh','2018-06-21 10:01:03');
INSERT INTO stop_words VALUES('porno','2018-06-21 10:01:03');
INSERT INTO stop_words VALUES('sex','2018-06-21 10:01:03');
INSERT INTO stop_words VALUES('robot','2018-06-21 10:01:03');

CREATE TABLE `stop_subwords` ( `subword` varchar(40) NOT NULL DEFAULT '', `ts` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (`subword`));
INSERT INTO stop_subwords VALUES('fuck','2018-06-20 17:17:31');
INSERT INTO stop_subwords VALUES('nahui','2018-06-20 17:17:31');
INSERT INTO stop_subwords VALUES('uid-','2018-06-20 17:19:37');
INSERT INTO stop_subwords VALUES('uid.','2018-06-20 17:19:37');
INSERT INTO stop_subwords VALUES('root','2018-06-20 17:19:37');
INSERT INTO stop_subwords VALUES('admin','2018-06-20 17:19:37');


CREATE TABLE device_public_key (
    -- Идентификатор устройства, в котором лежит соответствующий закрытый ключ
    device_id VARBINARY(2048) NOT NULL,
    -- Открытый ключ, которым можно проверить текст подписанный устройством
    public_key VARBINARY(60000) NOT NULL,
    -- Версия определяет, какой алгоритм или его модификация должна
    -- использоваться для проверки подписи.
    version SMALLINT UNSIGNED NOT NULL,
    -- Владелец ключа. В Грантушке заведены соответствующие гранты на создание,
    -- удаление и обновления ключей связанных с этим владельцем.
    owner_id SMALLINT UNSIGNED NOT NULL,
    PRIMARY KEY (device_id)
);
INSERT INTO device_public_key VALUES('good_device_id',replace('-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo6kuQneY+KPoD+KhxO4E\nDvWZVKXxT3CHcNTJNWYmNfJ4ufGaiy1xANq3WTRTXqmEXyteWYsW7dcIaYbjjdOR\nllebSsxnsxTlA8SwOKIZfLuy2Es6eXk0ryTShppB43mLtmWXYcHdphCCAKdvU1VK\n8yFJ9BXl6e7doGvKJEby6KK73LFSFeEp5Ah+ySSLwGOTDZbDvX3XNNBUafkm/IVg\nuPI6Xv+LMdqYIZ4SitSEWNMeJiegnm5Q4y0IXmcsfkgFYR0on5knnM73d9UL1iFk\nX+iZQjOcLwOIrVnprc+OzZopU4zVUfX8lIVGVljTFy39NRpqDDbFJCY4BT7CMJIG\ntQIDAQAB\n-----END PUBLIC KEY-----','\n',char(10)),1,2);
INSERT INTO device_public_key VALUES('bad_version',3333,17,2);
INSERT INTO device_public_key VALUES('bad_public_key',3333,1,2);

CREATE TABLE `family_info` (
  `family_id` INTEGER PRIMARY KEY,
  `admin_uid` INTEGER NOT NULL,
  `meta` varbinary(128) NOT NULL,
  UNIQUE (`admin_uid`)
);
INSERT INTO family_info VALUES(1,42,'');
INSERT INTO family_info VALUES(2,100501,'');

CREATE TABLE `family_members` (
  `family_id` INTEGER,
  `uid` INTEGER PRIMARY KEY,
  `place` INTEGER
);
INSERT INTO family_members VALUES(1,42,1);
INSERT INTO family_members VALUES(1,43,2);
INSERT INTO family_members VALUES(1,44,4);
INSERT INTO family_members VALUES(2,100500,1);
INSERT INTO family_members VALUES(2,100501,3);
INSERT INTO family_members VALUES(5,1235,3);
INSERT INTO family_members VALUES(6,12345,3);
INSERT INTO family_members VALUES(7,132,3);
INSERT INTO family_members VALUES(8,133,3);
INSERT INTO family_members VALUES(9,134,3);

CREATE TABLE IF NOT EXISTS "uid" (
  "uid" integer NOT NULL
);
INSERT INTO uid VALUES(100499);
INSERT INTO uid VALUES(100500);
INSERT INTO uid VALUES(100501);

CREATE TABLE IF NOT EXISTS "pdduid" (
  "uid" integer NOT NULL
);
INSERT INTO pdduid VALUES(40);
INSERT INTO pdduid VALUES(41);
INSERT INTO pdduid VALUES(42);

CREATE TABLE `webauthn_credentials` (
  `credential_id` varbinary(255) NOT NULL,
  `uid` unsigned NOT NULL,
  PRIMARY KEY (`credential_id`),
  UNIQUE (`uid`, `credential_id`)
);

INSERT INTO webauthn_credentials VALUES('existing_credential',42);

COMMIT;
