#include <passport/infra/daemons/blackbox/ut/common/common.h>

#include <passport/infra/daemons/blackbox/src/grants/grants_checker.h>

#include <passport/infra/libs/cpp/request/test/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(PasspUtGrantsChecker) {
    Y_UNIT_TEST(checkMethod) {
        NTest::TRequest request;
        TConsumer consumer;
        TGrantsChecker h(request, consumer, false);

        UNIT_ASSERT_VALUES_EQUAL(h.GetResult().Errors, std::set<TString>({}));

        h.CheckMethodAllowed(TBlackboxMethods::EMethod::Sign);
        UNIT_ASSERT_VALUES_EQUAL(
            h.GetResult().Errors,
            std::set<TString>({
                "no grants for method=",
            }));

        request.Args["method"] = "foobar";
        h.CheckMethodAllowed(TBlackboxMethods::EMethod::Sign);
        h.CheckMethodAllowed(TBlackboxMethods::EMethod::UserInfo);
        UNIT_ASSERT_VALUES_EQUAL(
            h.GetResult().Errors,
            std::set<TString>({
                "no grants for method=",
                "no grants for method=foobar",
                "no grants for method=foobar",
            }));

        consumer.SetAllow(TBlackboxMethods::EMethod::Sign, true);
        consumer.SetAllow(TBlackboxMethods::EMethod::UserInfo, true);

        h.CheckMethodAllowed(TBlackboxMethods::EMethod::Sign);
        h.CheckMethodAllowed(TBlackboxMethods::EMethod::UserInfo);
        UNIT_ASSERT_VALUES_EQUAL(
            h.GetResult().Errors,
            std::set<TString>({
                "no grants for method=",
                "no grants for method=foobar",
                "no grants for method=foobar",
            }));

        // test exception
        TGrantsChecker thr(request, consumer, true);
        UNIT_ASSERT_NO_EXCEPTION(thr.CheckMethodAllowed(TBlackboxMethods::EMethod::Sign));
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            thr.CheckMethodAllowed(TBlackboxMethods::EMethod::Login),
            TBlackboxError,
            "no grants for method=foobar. consumer:  (tvm_id=NULL;IP=)");
    }

    Y_UNIT_TEST(checkNotEmptyArgAllowed) {
        NTest::TRequest request;
        TConsumer consumer;
        TGrantsChecker h(request, consumer, false);

        UNIT_ASSERT_VALUES_EQUAL(h.GetResult().Errors, std::set<TString>({}));

        h.CheckNotEmptyArgAllowed("foobar", TBlackboxFlags::EFlag::ResignCookie);
        UNIT_ASSERT_VALUES_EQUAL(h.GetResult().Errors, std::set<TString>({}));

        request.Args["foobar"] = "";
        UNIT_ASSERT_VALUES_EQUAL(h.GetResult().Errors, std::set<TString>({}));

        request.Args["foobar"] = R"(¯\_(ツ)_/¯)";
        h.CheckNotEmptyArgAllowed("foobar", TBlackboxFlags::EFlag::ResignCookie);
        h.CheckNotEmptyArgAllowed("foobar", TBlackboxFlags::EFlag::ResignCookie);
        UNIT_ASSERT_VALUES_EQUAL(
            h.GetResult().Errors,
            std::set<TString>({
                "no grants for arg 'foobar'",
                "no grants for arg 'foobar'",
            }));

        consumer.SetAllow(TBlackboxFlags::EFlag::ResignCookie, true);
        h.CheckNotEmptyArgAllowed("foobar", TBlackboxFlags::EFlag::ResignCookie);
        UNIT_ASSERT_VALUES_EQUAL(
            h.GetResult().Errors,
            std::set<TString>({
                "no grants for arg 'foobar'",
                "no grants for arg 'foobar'",
            }));

        request.Args["some string"] = "42";
        h.CheckNotEmptyArgAllowed("some string", TBlackboxFlags::EFlag::GetPublicName);
        UNIT_ASSERT_VALUES_EQUAL(
            h.GetResult().Errors,
            std::set<TString>({
                "no grants for arg 'foobar'",
                "no grants for arg 'foobar'",
                "no grants for arg 'some string'",
            }));

        consumer.SetAllow(TBlackboxFlags::EFlag::GetPublicName, true);
        h.CheckNotEmptyArgAllowed("some string", TBlackboxFlags::EFlag::GetPublicName);
        UNIT_ASSERT_VALUES_EQUAL(
            h.GetResult().Errors,
            std::set<TString>({
                "no grants for arg 'foobar'",
                "no grants for arg 'foobar'",
                "no grants for arg 'some string'",
            }));

        // test exception
        request.Args["some other string"] = "42";
        TGrantsChecker thr(request, consumer, true);
        UNIT_ASSERT_NO_EXCEPTION(thr.CheckNotEmptyArgAllowed("some string", TBlackboxFlags::EFlag::GetPublicName));
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            thr.CheckNotEmptyArgAllowed("some other string", TBlackboxFlags::EFlag::LoginByUid),
            TBlackboxError,
            "no grants for arg 'some other string'. consumer:  (tvm_id=NULL;IP=)");
    }

    Y_UNIT_TEST(add) {
        NTest::TRequest request;
        TConsumer consumer;
        TGrantsChecker h(request, consumer, false);

        h.Add("abc");
        h.Add("asd");
        h.Add("dfg");
        h.Add("qwe");
        h.Add("zxc");
        UNIT_ASSERT_VALUES_EQUAL(
            h.GetResult().Errors,
            std::set<TString>({
                "abc",
                "asd",
                "dfg",
                "qwe",
                "zxc",
            }));

        // test exception
        TGrantsChecker thr(request, consumer, true);
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            thr.Add("abc"),
            TBlackboxError,
            "abc. consumer:  (tvm_id=NULL;IP=)");
    }
}
