#include <passport/infra/daemons/blackbox/ut/common/common.h>

#include <passport/infra/daemons/blackbox/src/grants/grants_checker.h>
#include <passport/infra/daemons/blackbox/src/helpers/base_result_helper.h>
#include <passport/infra/daemons/blackbox/src/misc/attributes.h>

#include <passport/infra/libs/cpp/request/test/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(PasspUtBaseResultHelper) {
    Y_UNIT_TEST(checkPhoneOperationsGrants) {
        NTest::TRequest req;
        TConsumer c;
        TGrantsChecker checker(req, c, false);

        auto check = [&](const std::set<TString>& expected) {
            TBaseResultHelper::CheckPhoneOperationsGrants(checker);
            UNIT_ASSERT_VALUES_EQUAL(checker.GetResult().Errors, expected);
            const_cast<decltype(checker.GetResult().Errors)*>(&checker.GetResult().Errors)->clear();
        };

        check({});

        req.Args["getphoneoperations"] = "yes";
        check({"no grants for phone operations"});

        c.SetAllow(TBlackboxMethods::PhoneOperations, true);
        check({});
    }

    Y_UNIT_TEST(checkPhoneBindingsGrants) {
        NTest::TRequest req;
        TConsumer c;
        TGrantsChecker checker(req, c, false);

        auto check = [&](const std::set<TString>& expected) {
            TBaseResultHelper::CheckPhoneBindingsGrants(checker);
            UNIT_ASSERT_VALUES_EQUAL(checker.GetResult().Errors, expected);
            const_cast<decltype(checker.GetResult().Errors)*>(&checker.GetResult().Errors)->clear();
        };

        req.Args["getphonebindings"] = "akljdnaksjdn";
        check({});

        req.Args["getphonebindings"] = "all";
        check({"no grants for phone bindings"});
        req.Args["getphonebindings"] = "unbound";
        check({"no grants for phone bindings"});
        req.Args["getphonebindings"] = "current";
        check({"no grants for phone bindings"});

        c.SetAllow(TBlackboxMethods::PhoneBindings, true);
        check({});
    }
}
