#include <passport/infra/daemons/blackbox/ut/common/common.h>

#include <passport/infra/daemons/blackbox/src/grants/grants_checker.h>
#include <passport/infra/daemons/blackbox/src/helpers/dbfields_helper.h>
#include <passport/infra/daemons/blackbox/src/misc/dbfields_settings.h>

#include <passport/infra/libs/cpp/request/test/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(PasspUtDbFieldsHelper) {
    Y_UNIT_TEST(checkGrants) {
        NTest::TRequest req;
        TConsumer c;
        TGrantsChecker checker(req, c, false);

        TDbFieldsSettings settings("asd,foo,bar");
        c.AddField("foo", TConsumer::ERank::HasCred);
        c.AddField("bar", TConsumer::ERank::NoCred);

        req.Args["dbfields"] = "asd,asd,foo,foo,bar,bar,kek,kek";

        auto check = [&](TConsumer::ERank rank, const std::set<TString>& expected) {
            TDbFieldsHelper::CheckGrants(rank, settings, checker);
            UNIT_ASSERT_VALUES_EQUAL(checker.GetResult().Errors, expected);
            const_cast<decltype(checker.GetResult().Errors)*>(&checker.GetResult().Errors)->clear();
        };

        check(TConsumer::ERank::NoCred,
              {
                  "no grants for dbfield 'asd'",
                  "no grants for dbfield 'foo'",
              });
        check(TConsumer::ERank::HasCred,
              {
                  "no grants for dbfield 'asd'",
              });
    }
}
