#include <passport/infra/daemons/blackbox/ut/common/common.h>

#include <passport/infra/daemons/blackbox/src/helpers/plus_subscriber_state_helper.h>
#include <passport/infra/daemons/blackbox/src/output/plus_subscriber_state_chunk.h>

#include <passport/infra/libs/cpp/request/test/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(PasspUtPlusSubscriberStateHelper) {
    Y_UNIT_TEST(plusSubscriberStateHelper) {
        NTest::TRequest req;

        std::unique_ptr<TTestDbFetcher> fetcher = TTestDbHolder::GetSingleton().CreateFetcher();
        auto& attrs = const_cast<TDbProfile::TAttrs&>(fetcher->DefaultProfile().Attrs());

        // no get_plus_subscriber_state arg
        TPlusSubscriberStateHelper h1(*fetcher, req);

        UNIT_ASSERT(attrs.empty());
        UNIT_ASSERT(!h1.Result(nullptr));
        UNIT_ASSERT(!h1.Result(&fetcher->DefaultProfile()));

        // bad get_plus_subscriber_state arg
        req.Args["get_plus_subscriber_state"] = "gimmi pliz";
        UNIT_ASSERT_EXCEPTION_CONTAINS(TPlusSubscriberStateHelper(*fetcher, req),
                                       TBlackboxError,
                                       "Unsupported get_plus_subscriber_state value: 'gimmi pliz'");

        UNIT_ASSERT(attrs.empty());

        // good get_plus_subscriber_state arg
        req.Args["get_plus_subscriber_state"] = "all";
        TPlusSubscriberStateHelper h2(*fetcher, req);

        UNIT_ASSERT_VALUES_EQUAL(attrs, TDbProfile::TAttrs({{TAttr::ACCOUNT_PLUS_SUBSCRIBER_STATE, TDbValue()}}));

        // broken protobuf
        attrs[TAttr::ACCOUNT_PLUS_SUBSCRIBER_STATE] = TDbValue(NUtils::Base64ToBin("abc"));

        UNIT_ASSERT(!h2.Result(nullptr));
        UNIT_ASSERT(!h2.Result(&fetcher->DefaultProfile()));

        // valid protobuf
        attrs[TAttr::ACCOUNT_PLUS_SUBSCRIBER_STATE] = TDbValue(NUtils::Base64ToBin("ChUIgQESCnNvbWUgdmFsdWUYp7n9lAYKBAiUkQYQwOL8lAYaFQiJBhIQc29tZSBvdGhlciB2YWx1ZQ=="));

        UNIT_ASSERT(!h2.Result(nullptr));

        std::unique_ptr<TPlusSubscriberStateChunk> c = h2.Result(&fetcher->DefaultProfile(), TInstant::Seconds(1654599999));
        UNIT_ASSERT(c);
        UNIT_ASSERT_VALUES_EQUAL(2, c->AvailableFeatures.size());
        UNIT_ASSERT_VALUES_EQUAL(1, c->FrozenFeatures.size());

        UNIT_ASSERT_VALUES_EQUAL(129, c->AvailableFeatures[0].Id);
        UNIT_ASSERT_VALUES_EQUAL("some value", c->AvailableFeatures[0].Value);
        UNIT_ASSERT_VALUES_EQUAL(TInstant::Seconds(1654611111), c->AvailableFeatures[0].End);

        UNIT_ASSERT_VALUES_EQUAL(100500, c->AvailableFeatures[1].Id);
        UNIT_ASSERT_VALUES_EQUAL("", c->AvailableFeatures[1].Value);
        UNIT_ASSERT_VALUES_EQUAL(TInstant::Seconds(1654600000), c->AvailableFeatures[1].End);

        UNIT_ASSERT_VALUES_EQUAL(777, c->FrozenFeatures[0].Id);
        UNIT_ASSERT_VALUES_EQUAL("some other value", c->FrozenFeatures[0].Value);

        c = h2.Result(&fetcher->DefaultProfile(), TInstant::Seconds(1654600000));
        UNIT_ASSERT(c);
        UNIT_ASSERT_VALUES_EQUAL(1, c->AvailableFeatures.size());
        UNIT_ASSERT_VALUES_EQUAL(129, c->AvailableFeatures[0].Id);
        UNIT_ASSERT_VALUES_EQUAL(1, c->FrozenFeatures.size());
        UNIT_ASSERT_VALUES_EQUAL(777, c->FrozenFeatures[0].Id);

        c = h2.Result(&fetcher->DefaultProfile(), TInstant::Seconds(1654611111));
        UNIT_ASSERT(c);
        UNIT_ASSERT_VALUES_EQUAL(0, c->AvailableFeatures.size());
        UNIT_ASSERT_VALUES_EQUAL(1, c->FrozenFeatures.size());
        UNIT_ASSERT_VALUES_EQUAL(777, c->FrozenFeatures[0].Id);
    }
}
