#include <passport/infra/daemons/blackbox/ut/common/common.h>

#include <passport/infra/daemons/blackbox/src/loggers/authlog.h>

#include <passport/infra/libs/cpp/utils/log/file_logger.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/file.h>
#include <util/system/fs.h>

using namespace NPassport;
using namespace NPassport::NBb;

const TString tmpFileName("tmp_log_file");

Y_UNIT_TEST_SUITE(AuthLog) {
    Y_UNIT_TEST(authLog) {
        NFs::Remove(tmpFileName);
        std::unique_ptr<NUtils::TFileLogger> log;

        SetLocalTimeZone();

        UNIT_ASSERT_NO_EXCEPTION(log = std::make_unique<NUtils::TFileLogger>(tmpFileName, "DEBUG", true));
        {
            TAuthLog auth_log(std::move(log), "0xFE");
            TString bad_sym(" a`b\t\v\r\nc");
            bad_sym[0] = '\0';

            auth_log.Write("70700", "test-user", "2", "web", TAuthLog::EFlag::OK, "", "attr", true, "127.0.0.1", "8.8.8.8", "123123123123123", "ref", "retpath.ru", "Firefox 2.0");
            auth_log.Write("70700", "test-user", "2", "mail", TAuthLog::EFlag::BLOCKED, "", "attr", true, "127.0.0.1", "8.8.8.8", "123123123123123", "ref", "retpath.ru", "Firefox 2.0");
            auth_log.Write("70700", "test-user", "2", "verify", TAuthLog::EFlag::OK, "", "attr", true, "127.0.0.1", "8.8.8.8", "123123123123123", "ref", "retpath.ru", "Firefox 2.0");
            auth_log.Write("", "test-user", "2", "web", TAuthLog::EFlag::CAPTCHA, bad_sym, "", false, "127.0.0.2", "88.88.88.88", "", "bad\tvalue\n", "", "");
            auth_log.Write("0", "", "", "", TAuthLog::EFlag::SECONDSTEP, "", "", false, "", "", "", "", "", "");
        }

        {
            TFileInput log_file(tmpFileName);
            UNIT_ASSERT_STRING_CONTAINS(log_file.ReadLine(), "+03 0xFE bb 70700 test-user 2 web successful attr;cpt=1 127.0.0.1 8.8.8.8 123123123123123 ref retpath.ru `Firefox 2.0`");
            UNIT_ASSERT_STRING_CONTAINS(log_file.ReadLine(), "+03 0xFE bb - test-user 2 web blocked `\0a``b\\t\\v\\r\\nc;askcpt=1` 127.0.0.2 88.88.88.88 - `bad\\tvalue\\n` - -");
            UNIT_ASSERT_STRING_CONTAINS(log_file.ReadLine(), "+03 0xFE bb - - - unknown second_step - - - - - - -");
        }
    }

    Y_UNIT_TEST(authLogTime) {
        class TTestLogger: public TAuthLog {
        public:
            using TAuthLog::FormatTimestamp;
        };

        SetLocalTimeZone();

        TString str = "kek ";
        TTestLogger::FormatTimestamp(str, TInstant::FromValue(100500));
        UNIT_ASSERT_STRINGS_EQUAL("kek 1970-01-01T03:00:00.100500+03", str);
    }
}
