#include <passport/infra/daemons/blackbox/ut/common/common.h>

#include <passport/infra/daemons/blackbox/src/loggers/authlog.h>

#include <passport/infra/libs/cpp/utils/thread_local_id.h>
#include <passport/infra/libs/cpp/utils/log/file_logger.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/file.h>
#include <util/system/fs.h>

using namespace NPassport;
using namespace NPassport::NBb;

const TString tmpFileName("tmp_log_file");

Y_UNIT_TEST_SUITE(TskvLog) {
    Y_UNIT_TEST(tskvlog) {
        NFs::Remove(tmpFileName);
        std::unique_ptr<NUtils::TFileLogger> log;
        NUtils::SetThreadLocalRequestId(nullptr);

        UNIT_ASSERT_NO_EXCEPTION(log = std::make_unique<NUtils::TFileLogger>(tmpFileName, "DEBUG", true));
        {
            TTskvLog tskv_log(std::move(log));

            tskv_log.LogBadauthBan("admin", "0", "x\\\r\n\v\t123", "login_pwd", "100500", "127.0.0.1", true);
            tskv_log.LogDeadSession("70500", "1234567890:AbcDe:ff", -500);
            tskv_log.LogBadauthBan("admin", "1", "x\\\r\n\v\t123", "login_pwd", "100500", "127.0.0.1", false, true);

            TString request_id("test_req_id");
            NUtils::SetThreadLocalRequestId(&request_id);

            tskv_log.LogOAuth("12345", true, "Ok", "70500", "123", "read,write", "", "0", "999", "", "ab-cd-ef", "AiPhone", false, "None", "yabro", "127.0.0.118");
            tskv_log.LogSesCheck("70500,70600,1234", "1234", "a\\b+c.ya.ru", "my_auth_id", "bla\tbla", "", "8.8.8.8", "someport", "yabro", "127.0.0.118", 242);
        }
        {
            TFileInput log_file(tmpFileName);
            UNIT_ASSERT_STRING_CONTAINS(log_file.ReadLine(), "\taction=bruteforce_ban\tlogin=admin\tuid=0\tyandexuid=x\\\\\\r\\n\\v\\t123\trule=login_pwd\tcount=100500\tip=127.0.0.1\tshow_captcha=1");
            UNIT_ASSERT_STRING_CONTAINS(log_file.ReadLine(), "\taction=dead_session\tuid=70500\tauthid=1234567890:AbcDe:ff\tdelta=-500");
            UNIT_ASSERT_STRING_CONTAINS(log_file.ReadLine(), "\taction=bruteforce_half_ip_ban\tlogin=admin\tuid=1\tyandexuid=x\\\\\\r\\n\\v\\t123\trule=login_pwd\tcount=100500\tip=127.0.0.1\tshow_captcha=0");
            UNIT_ASSERT_STRING_CONTAINS(log_file.ReadLine(), "\treq_id=test_req_id\tmode=verify_token\tfull_check=1\tby_alias=1\tstatus=Ok\ttoken_id=12345\tuid=70500\tclient_id=123\tscopes=read,write\tissue_time=0\texpire_time=999\tdevice_id=ab-cd-ef\tdevice_name=AiPhone\tneeds_refresh=0\treason=None\t__consumer=yabro\t__consumer_ip=127.0.0.118");
            UNIT_ASSERT_STRING_CONTAINS(log_file.ReadLine(), "\treq_id=test_req_id\taction=sescheck\tuids=70500,70600,1234\tdef_uid=1234\thost=a\\\\b+c.ya.ru\tauthid=my_auth_id\tidnt=bla\\tbla\tuserip=8.8.8.8\tuser_port=someport\t__consumer=yabro\t__consumer_ip=127.0.0.118\t__consumer_tvm_id=242");
        }
    }
}
