#include <passport/infra/daemons/blackbox/ut/common/common.h>

#include <passport/infra/daemons/blackbox/src/blackbox.h>
#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>
#include <passport/infra/daemons/blackbox/src/methods/checkip.h>
#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/output/typed_value_result.h>

#include <passport/infra/libs/cpp/request/test/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(PasspMethodCheckip) {
    Y_UNIT_TEST_F(common, TBlackboxFixture) {
        TConsumer peer;
        NTest::TRequest request;
        TCheckIpProcessor proc(*Bb->Impl, request);

        // no grants
        UNIT_ASSERT_EXCEPTION_SATISFIES(
            proc.Process(peer),
            TBlackboxError,
            [](const TBlackboxError& e) { return e.Status() == TBlackboxError::EType::AccessDenied; });
        peer.SetAllow(TBlackboxMethods::CheckIp, true);

        // invalid arguments
        UNIT_ASSERT_EXCEPTION_SATISFIES(
            proc.Process(peer),
            TBlackboxError,
            [=](const TBlackboxError& e) {
                UNIT_ASSERT_VALUES_EQUAL("Missing ip argument", e.what());
                return e.Status() == TBlackboxError::EType::InvalidParams;
            });

        request.Args["ip"] = "127.0.0.1";
        UNIT_ASSERT_EXCEPTION_SATISFIES(
            proc.Process(peer),
            TBlackboxError,
            [=](const TBlackboxError& e) {
                UNIT_ASSERT_VALUES_EQUAL("Missing nets argument", e.what());
                return e.Status() == TBlackboxError::EType::InvalidParams;
            });

        request.Args["nets"] = "all";
        UNIT_ASSERT_EXCEPTION_SATISFIES(
            proc.Process(peer),
            TBlackboxError,
            [=](const TBlackboxError& e) {
                UNIT_ASSERT_VALUES_EQUAL("Unknown value of nets argument: 'all'", e.what());
                return e.Status() == TBlackboxError::EType::InvalidParams;
            });

        request.Args["nets"] = "yandexusers";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "0");

        request.Args["ip"] = "5.45.199.0";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "1");

        request.Args["ip"] = "5.45.199.27";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "1");

        request.Args["ip"] = "5.45.199.28";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "0");

        request.Args["ip"] = "5.45.199.30";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "0");

        request.Args["ip"] = "5.45.199.31";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "0");

        request.Args["ip"] = "5.45.199.32";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "1");

        request.Args["ip"] = "5.45.199.127";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "1");

        request.Args["ip"] = "5.45.199.128";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "0");

        request.Args["ip"] = "5.45.100.0";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "0");

        request.Args["ip"] = "2a02:6b8:c00:6603::1";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "0");

        request.Args["ip"] = "2a02:6b8:c00:6602::1";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "1");

        request.Args["ip"] = "2a02:6b8:c00:6602:0:663::1";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "0");

        request.Args["ip"] = "2a02:6b8:c00:6602:0:664::1";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "1");

        request.Args["ip"] = "2a02:6b8:c00:6602:0:666::1";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "0");

        request.Args["ip"] = "2a02:6b8:c00:6602:0:666::2";
        UNIT_ASSERT_VALUES_EQUAL(proc.Process(peer)->Value, "0");
    }
}
