#include <passport/infra/daemons/blackbox/ut/common/common.h>

#include <passport/infra/daemons/blackbox/src/blackbox.h>
#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>
#include <passport/infra/daemons/blackbox/src/methods/get_max_uid.h>
#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/output/get_max_uid_result.h>

#include <passport/infra/libs/cpp/request/test/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(PasspMethodGetMaxUid) {
    Y_UNIT_TEST_F(common, TBlackboxFixture) {
        TConsumer peer;
        NTest::TRequest request;
        TGetMaxUidProcessor proc(*Bb->Impl, request);

        UNIT_ASSERT_EXCEPTION_SATISFIES(
            proc.Process(peer),
            TBlackboxError,
            [](const TBlackboxError& e) { return e.Status() == TBlackboxError::EType::AccessDenied; });
        peer.SetAllow(TBlackboxMethods::GetMaxUid, true);

        std::unique_ptr<TGetMaxUidResult> result;
        UNIT_ASSERT_NO_EXCEPTION(result = proc.Process(peer));
        UNIT_ASSERT_VALUES_EQUAL(100501, result->Uid);
        UNIT_ASSERT(result->Pdduid);
        UNIT_ASSERT_VALUES_EQUAL(42, *result->Pdduid);
    }
}
