#include <passport/infra/daemons/blackbox/ut/common/common.h>

#include <passport/infra/daemons/blackbox/src/blackbox.h>
#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>
#include <passport/infra/daemons/blackbox/src/methods/webauthn_credentials.h>
#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/output/webauthn_credentials_result.h>

#include <passport/infra/libs/cpp/request/test/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(PasspMethodWebauthnCredentials) {
    Y_UNIT_TEST_F(common, TBlackboxFixture) {
        TConsumer peer;
        NTest::TRequest request;
        TWebauthnCredentialsProcessor proc(*Bb->Impl, request);

        UNIT_ASSERT_EXCEPTION_SATISFIES(
            proc.Process(peer),
            TBlackboxError,
            [](const TBlackboxError& e) { return e.Status() == TBlackboxError::EType::AccessDenied; });

        peer.SetAllow(TBlackboxMethods::WebauthnCredentials, true);

        UNIT_ASSERT_EXCEPTION_SATISFIES(
            proc.Process(peer),
            TBlackboxError,
            [=](const TBlackboxError& e) {
                UNIT_ASSERT_VALUES_EQUAL("Missing credential_id argument", e.what());
                return e.Status() == TBlackboxError::EType::InvalidParams;
            });

        std::unique_ptr<TWebauthnCredentialsResult> result;

        request.Args["credential_id"] = "unknown";
        UNIT_ASSERT_NO_EXCEPTION(result = proc.Process(peer));
        UNIT_ASSERT_VALUES_EQUAL("unknown", result->CredentialId);
        UNIT_ASSERT_VALUES_EQUAL("", result->Uid);

        request.Args["credential_id"] = "existing_credential";
        UNIT_ASSERT_NO_EXCEPTION(result = proc.Process(peer));
        UNIT_ASSERT_VALUES_EQUAL("existing_credential", result->CredentialId);
        UNIT_ASSERT_VALUES_EQUAL("42", result->Uid);
    }
}
