#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>
#include <passport/infra/daemons/blackbox/src/ip/usernets_list.h>

#include <passport/infra/libs/cpp/request/test/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NBb;
using namespace NPassport::NUtils;

Y_UNIT_TEST_SUITE(PasspBbAcl) {
    Y_UNIT_TEST(aclUsernets) {
        // bad usernets
        UNIT_ASSERT_EXCEPTION_CONTAINS(TUsernetsList(""), yexception, "Usernets: broken json: ");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TUsernetsList("}"), yexception, "Usernets: broken json: }");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TUsernetsList("{}"), yexception, "Usernets: broken usernets json member 'internal_explicit'; expected array: {}");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TUsernetsList("{\"allow\":\"yes\"}"), yexception,
                                       "Usernets: broken usernets json member 'internal_explicit'; expected array: {\"allow\":\"yes\"}");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TUsernetsList("{\"internal_explicit\":[],\"deny\":{}}"), yexception,
                                       "Usernets: broken usernets json member 'robot_explicit'; expected array: {\"internal_explicit\":[],\"deny\":{}}");
        TUsernetsList nets(R"({
            "internal_explicit": [],
            "robot_explicit": [],
            "allow":[
                {"ip": "77.88.0.0/18", "macro_name": "foo"},
                {"ip": "37.140.180.0/18", "macro_name": "foo"},
                {"ip": "2a02:6b8::/32", "macro_name": "foo"}
            ],
            "deny":[
                {"ip": "5.45.198.29", "macro_name": "foo"},
                {"ip": "2a02:6b8:0:1619::129", "macro_name": "foo"},
                {"ip": "10000@2a02:6b8:c00::/40", "macro_name": "foo"}
            ],
            "robots":[
                {"ip": "127.0.0.1", "macro_name": "foo"},
                {"ip": "37.140.181.5", "macro_name": "foo"},
                {"ip": "2a02:6b8:c00:0:1::12", "macro_name": "foo"},
                {"ip": "663@2a02:6b8:0::/40", "macro_name": "foo"}
            ]
        })");

        NPassport::NTest::TRequest req;
        UNIT_ASSERT_VALUES_EQUAL(ENetworkKind::External, nets.FindNetwork(TString("127.0.0.1"), req));
        UNIT_ASSERT_VALUES_EQUAL(ENetworkKind::External, nets.FindNetwork(TString("37.140.10.10"), req));
        UNIT_ASSERT_VALUES_EQUAL(ENetworkKind::External, nets.FindNetwork(TString("5.45.198.29"), req));

        UNIT_ASSERT_VALUES_EQUAL(ENetworkKind::Internal, nets.FindNetwork(TString("77.88.11.88"), req));
        UNIT_ASSERT_VALUES_EQUAL(ENetworkKind::Internal, nets.FindNetwork(TString("2a02:6b8:0:1619::128"), req));
        UNIT_ASSERT_VALUES_EQUAL(ENetworkKind::Internal, nets.FindNetwork(TString("2a02:6b8:c00:0:11::1"), req));
        UNIT_ASSERT_VALUES_EQUAL(ENetworkKind::Internal, nets.FindNetwork(TString("37.140.181.6"), req));

        UNIT_ASSERT_VALUES_EQUAL(ENetworkKind::External, nets.FindNetwork(TString("2a02:6b8:0:1619::129"), req));
        UNIT_ASSERT_VALUES_EQUAL(ENetworkKind::External, nets.FindNetwork(TString("2a02:6b8:c00:0:1::12"), req));
        UNIT_ASSERT_VALUES_EQUAL(ENetworkKind::External, nets.FindNetwork(TString("2a02:6b8:c00:0:1::1"), req));

        UNIT_ASSERT_VALUES_EQUAL(ENetworkKind::Robot, nets.FindNetwork(TString("37.140.181.5"), req));
        UNIT_ASSERT_VALUES_EQUAL(ENetworkKind::Robot, nets.FindNetwork(TString("2a02:6b8:0:0:0:663::1"), req));
        UNIT_ASSERT_VALUES_EQUAL(ENetworkKind::Robot, nets.FindNetwork(TString("2a02:6b8:0:0:0:663::1000"), req));
    }
}
