#include <passport/infra/daemons/blackbox/src/misc/anonymiser.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(PasspBbAnonymiser) {
    Y_UNIT_TEST(anonymizeEmails) {
        TAnonymiser a;
        TString value;
        unsigned num = 1;
        UNIT_ASSERT(!a.MapEmail(value, "login", num));
        UNIT_ASSERT_VALUES_EQUAL("", value);
        UNIT_ASSERT_VALUES_EQUAL(1, num);

        a.SetEmailDomain("fake", ".domain.");

        value = "";
        UNIT_ASSERT(a.MapEmail(value, "", num));
        UNIT_ASSERT_VALUES_EQUAL("@fake1.domain.ru", value);
        UNIT_ASSERT_VALUES_EQUAL(2, num);

        UNIT_ASSERT(a.MapEmail(value, "login", num));
        UNIT_ASSERT_VALUES_EQUAL("login@fake2.domain.ru", value);
        UNIT_ASSERT_VALUES_EQUAL(3, num);

        value = "@";
        UNIT_ASSERT(a.MapEmail(value, "", num));
        UNIT_ASSERT_VALUES_EQUAL("@fake3.domain.ru", value);
        UNIT_ASSERT_VALUES_EQUAL(4, num);

        UNIT_ASSERT(a.MapEmail(value, "login", num));
        UNIT_ASSERT_VALUES_EQUAL("login@fake4.domain.ru", value);
        UNIT_ASSERT_VALUES_EQUAL(5, num);

        value = "com";
        UNIT_ASSERT(a.MapEmail(value, "", num));
        UNIT_ASSERT_VALUES_EQUAL("com@fake5.domain.ru", value);
        UNIT_ASSERT_VALUES_EQUAL(6, num);

        UNIT_ASSERT(a.MapEmail(value, "login", num));
        UNIT_ASSERT_VALUES_EQUAL("login@fake6.domain.ru", value);
        UNIT_ASSERT_VALUES_EQUAL(7, num);

        value = "gmail.fr";
        UNIT_ASSERT(a.MapEmail(value, "", num));
        UNIT_ASSERT_VALUES_EQUAL("gmail.fr@fake7.domain.fr", value);
        UNIT_ASSERT_VALUES_EQUAL(8, num);

        UNIT_ASSERT(a.MapEmail(value, "login", num));
        UNIT_ASSERT_VALUES_EQUAL("login@fake8.domain.fr", value);
        UNIT_ASSERT_VALUES_EQUAL(9, num);

        value = "brin@gmail.com";
        UNIT_ASSERT(a.MapEmail(value, "", num));
        UNIT_ASSERT_VALUES_EQUAL("brin@fake9.domain.com", value);
        UNIT_ASSERT_VALUES_EQUAL(10, num);

        UNIT_ASSERT(a.MapEmail(value, "login", num));
        UNIT_ASSERT_VALUES_EQUAL("login@fake10.domain.com", value);
        UNIT_ASSERT_VALUES_EQUAL(11, num);

        value = "some@bad@format.email";
        UNIT_ASSERT(a.MapEmail(value, "", num));
        UNIT_ASSERT_VALUES_EQUAL("some@fake11.domain.email", value);
        UNIT_ASSERT_VALUES_EQUAL(12, num);

        UNIT_ASSERT(a.MapEmail(value, "login", num));
        UNIT_ASSERT_VALUES_EQUAL("login@fake12.domain.email", value);
        UNIT_ASSERT_VALUES_EQUAL(13, num);
    }

    Y_UNIT_TEST(anonymizeAttributes) {
        TAnonymiser a;
        a.AddAttribute("100", "500");
        TString value;

        UNIT_ASSERT(!a.MapAttribute("", value));
        UNIT_ASSERT_VALUES_EQUAL("", value);
        UNIT_ASSERT(!a.MapAttribute("10", value));
        UNIT_ASSERT_VALUES_EQUAL("", value);
        UNIT_ASSERT(!a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("", value);

        UNIT_ASSERT(a.MapAttribute("100", value));
        UNIT_ASSERT_VALUES_EQUAL("500", value);

        UNIT_ASSERT(!a.MapAttribute("10", value));
        UNIT_ASSERT_VALUES_EQUAL("500", value);

        a.AddAttribute("10", "100500");

        UNIT_ASSERT(a.MapAttribute("10", value));
        UNIT_ASSERT_VALUES_EQUAL("100500", value);

        a.SetNickname("Джон Смит", "");

        value.clear();
        UNIT_ASSERT(!a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("", value);

        value = "Я робот!";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("Джон Смит", value);

        value = "p:Яробот";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("p:Джон.Смит", value);

        value = "t:I love {login}";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("", value);

        value = "s:Someone";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("s:Someone:", value);

        value = "s:Вк:Ок";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("s:Вк:Ок:Джон.Смит", value);

        value = "s:one:two:three:four";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("s:one:two:", value);

        value = "+";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("", value);

        a.SetNickname("", "John Doe");

        value.clear();
        UNIT_ASSERT(!a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("", value);

        value = "Я робот!";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("", value);

        value = "p:Яробот";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("p:", value);

        value = "t:I love {login}";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("John Doe", value);

        value = "s:Someone";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("s:Someone:John.Doe", value);

        value = "s:Вк:Ок";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("s:Вк:Ок:", value);

        value = "s:one:two:three:four";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("s:one:two:John.Doe", value);

        value = "+";
        UNIT_ASSERT(a.MapAttribute("16", value));
        UNIT_ASSERT_VALUES_EQUAL("John.Doe", value);
    }

    Y_UNIT_TEST(anonymizePhones) {
        TAnonymiser a;
        TString value;
        UNIT_ASSERT(!a.MapPhone(value));
        UNIT_ASSERT_VALUES_EQUAL("", value);

        value = "007";
        UNIT_ASSERT(!a.MapPhone(value));
        UNIT_ASSERT_VALUES_EQUAL("007", value);

        value = "1234";
        UNIT_ASSERT(a.MapPhone(value));
        UNIT_ASSERT_VALUES_EQUAL("1034", value);

        value = "+12345";
        UNIT_ASSERT(a.MapPhone(value));
        UNIT_ASSERT_VALUES_EQUAL("+00045", value);

        value = "malformed";
        UNIT_ASSERT(a.MapPhone(value));
        UNIT_ASSERT_VALUES_EQUAL("m000000ed", value);

        value = "79161234567";
        UNIT_ASSERT(a.MapPhone(value));
        UNIT_ASSERT_VALUES_EQUAL("70000000067", value);
    }
}
