#include <passport/infra/daemons/blackbox/ut/common/common.h>

using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(fetchingByFamilyId_deletedDomainsTreat_test) {
    const TString EXISTING_DOMAIN_ID = "23";

    Y_UNIT_TEST(fetch_pddAliasWithDeadDomain) {
        // Arrange
        const TString uid = "1235";
        const TString familyId = "5";
        TDomainFetcherMock domainFetcher;
        std::unique_ptr dbFetcher = TTestDbHolder::GetSingleton().GetMockedDbFetcher(domainFetcher);

        // Act
        dbFetcher->FetchAliasesByFamilyId(familyId, false);

        const TDbProfile* profile = dbFetcher->ProfileByUid(uid);

        // Assert
        UNIT_ASSERT(!profile);
    }

    Y_UNIT_TEST(fetch_pddAliasWithWorkingDomain) {
        // Arrange
        const TString uid = "12345";
        const TString familyId = "6";
        TDomainFetcherMock domainFetcherMock;
        std::unique_ptr dbFetcher = TTestDbHolder::GetSingleton().GetMockedDbFetcher(domainFetcherMock, EXISTING_DOMAIN_ID);

        // Act
        dbFetcher->FetchAliasesByFamilyId(familyId, false);
        const TDbProfile* profile = dbFetcher->ProfileByUid(uid);

        // Assert
        UNIT_ASSERT(profile);
        TTestDbProfile testProfileWithDomain(*profile);
        UNIT_ASSERT(!testProfileWithDomain.IsEmpty());
    }

    Y_UNIT_TEST(fetch_portalAlias) {
        // Arrange
        const TString uid = "132";
        const TString familyId = "7";
        TDomainFetcherMock domainFetcherMock;
        std::unique_ptr dbFetcher = TTestDbHolder::GetSingleton().GetMockedDbFetcher(domainFetcherMock, EXISTING_DOMAIN_ID);

        // Act
        dbFetcher->FetchAliasesByFamilyId(familyId, false);
        const TDbProfile* profile = dbFetcher->ProfileByUid(uid);

        // Assert
        UNIT_ASSERT(profile);
        TTestDbProfile testProfileWithDomain(*profile);
        UNIT_ASSERT(!testProfileWithDomain.IsEmpty());
    }

    Y_UNIT_TEST(fetch_pddAliasWithWorkingDomain_andPortalAlias) {
        // Arrange
        const TString uid = "134";
        const TString familyId = "9";
        TDomainFetcherMock domainFetcherMock;
        std::unique_ptr dbFetcher = TTestDbHolder::GetSingleton().GetMockedDbFetcher(domainFetcherMock, EXISTING_DOMAIN_ID, true);

        // Act
        dbFetcher->FetchAliasesByFamilyId(familyId, false);
        const TDbProfile* profile = dbFetcher->ProfileByUid(uid);

        // Assert
        UNIT_ASSERT(profile);

        TTestDbProfile testProfile(*profile);

        UNIT_ASSERT(!testProfile.IsEmpty());
        UNIT_ASSERT(testProfile.HasAlias(TAlias::PORTAL_LOGIN));
        UNIT_ASSERT(testProfile.HasAlias(TAlias::PDD_ALIAS_LOGIN));
    }

    Y_UNIT_TEST(fetch_pddAliasWithDeadDomain_andPortalAlias) {
        // Arrange
        const TString uid = "133";
        const TString familyId = "8";
        TDomainFetcherMock domainFetcherMock;
        std::unique_ptr dbFetcher = TTestDbHolder::GetSingleton().GetMockedDbFetcher(domainFetcherMock, EXISTING_DOMAIN_ID, true);

        // Act
        dbFetcher->FetchAliasesByFamilyId(familyId, false);
        const TDbProfile* profile = dbFetcher->ProfileByUid(uid);

        // Assert
        UNIT_ASSERT(profile);
        TTestDbProfile testProfile(*profile);

        UNIT_ASSERT(!testProfile.IsEmpty());
        UNIT_ASSERT(testProfile.HasAlias(TAlias::PORTAL_LOGIN));
        UNIT_ASSERT(!testProfile.HasAlias(TAlias::PDD_ALIAS_LOGIN));
    }

}
