#include <passport/infra/daemons/blackbox/ut/common/common.h>

using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(fetchingByUid_deletedDomainsTreat_test) {
    const TString EXISTING_DOMAIN_ID = "23";

    Y_UNIT_TEST(fetch_pddAliasWithDeadDomain) {
        // Arrange
        const TString uid = "1234";
        TDomainFetcherMock domainFetcherMock;
        std::unique_ptr dbFetcher = TTestDbHolder::GetSingleton().GetMockedDbFetcher(domainFetcherMock, EXISTING_DOMAIN_ID, true);

        // Act
        dbFetcher->FetchByUid(uid);
        const TDbProfile* profile = dbFetcher->ProfileByUid(uid);

        // Assert
        UNIT_ASSERT(!profile);
    }

    Y_UNIT_TEST(fetch_pddAliasWithWorkingDomain) {
        // Arrange
        const TString uid = "12345";
        TDomainFetcherMock domainFetcherMock;
        std::unique_ptr dbFetcher = TTestDbHolder::GetSingleton().GetMockedDbFetcher(domainFetcherMock, EXISTING_DOMAIN_ID, true);

        // Act
        dbFetcher->FetchByUid(uid);
        const TDbProfile* profile = dbFetcher->ProfileByUid(uid);

        // Assert
        UNIT_ASSERT(profile);
        TTestDbProfile testProfileWithDomain(*profile);
        UNIT_ASSERT(!testProfileWithDomain.IsEmpty());
    }

    Y_UNIT_TEST(fetch_portalAlias) {
        // Arrange
        const TString uid = "132";
        TDomainFetcherMock domainFetcherMock;
        std::unique_ptr dbFetcher = TTestDbHolder::GetSingleton().GetMockedDbFetcher(domainFetcherMock, EXISTING_DOMAIN_ID, true);

        // Act
        dbFetcher->FetchByUid(uid);
        const TDbProfile* profile = dbFetcher->ProfileByUid(uid);

        // Assert
        UNIT_ASSERT(profile);
        TTestDbProfile testProfileWithDomain(*profile);
        UNIT_ASSERT(!testProfileWithDomain.IsEmpty());
    }

    Y_UNIT_TEST(fetch_pddAliasWithWorkingDomain_andPortalAlias) {
        // Arrange
        const TString uid = "134";
        TDomainFetcherMock domainFetcherMock;
        std::unique_ptr dbFetcher = TTestDbHolder::GetSingleton().GetMockedDbFetcher(domainFetcherMock, EXISTING_DOMAIN_ID, true);

        // Act
        dbFetcher->FetchByUid(uid);
        const TDbProfile* profile = dbFetcher->ProfileByUid(uid);

        // Assert
        UNIT_ASSERT(profile);

        TTestDbProfile testProfile(*profile);

        UNIT_ASSERT(!testProfile.IsEmpty());
        UNIT_ASSERT(testProfile.HasAlias(TAlias::PORTAL_LOGIN));
        UNIT_ASSERT(testProfile.HasAlias(TAlias::PDD_ALIAS_LOGIN));
    }

    Y_UNIT_TEST(fetch_pddAliasWithDeadDomain_andPortalAlias) {
        // Arrange
        const TString uid = "133";
        TDomainFetcherMock domainFetcherMock;
        std::unique_ptr dbFetcher = TTestDbHolder::GetSingleton().GetMockedDbFetcher(domainFetcherMock, EXISTING_DOMAIN_ID, true);

        // Act
        dbFetcher->FetchByUid(uid);
        const TDbProfile* profile = dbFetcher->ProfileByUid(uid);

        // Assert
        UNIT_ASSERT(profile);

        TTestDbProfile testProfile(*profile);

        UNIT_ASSERT(!testProfile.IsEmpty());
        UNIT_ASSERT(testProfile.HasAlias(TAlias::PORTAL_LOGIN));
        UNIT_ASSERT(!testProfile.HasAlias(TAlias::PDD_ALIAS_LOGIN));
    }
}
