#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/misc/invalid_value.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(PasspBbInvalidValue) {
    template <typename T>
    TString Print(const T& v) {
        return TStringBuilder() << InvalidValue(v);
    }

    TString Print(const char* v) {
        return TStringBuilder() << InvalidValue(TString(v));
    }

    Y_UNIT_TEST(printInvalidValue) {
        UNIT_ASSERT_VALUES_EQUAL("'0'", Print(0));
        UNIT_ASSERT_VALUES_EQUAL("'42'", Print(ui64(42)));
        UNIT_ASSERT_VALUES_EQUAL("''", Print(""));

        UNIT_ASSERT_VALUES_EQUAL("'asdvjhkasdads'", Print("asdvjhkasdads"));
        UNIT_ASSERT_VALUES_EQUAL("'asdvj...'",
                                 TStringBuilder() << InvalidValue(TString("asdvjhkasdads"), 5));

        TString nonPrintable("asdvjhkasdads");
        nonPrintable[3] = 0;
        UNIT_ASSERT_VALUES_EQUAL("(base64)'YXNkAGpoa2FzZGFkcw=='", Print(nonPrintable));
        UNIT_ASSERT_VALUES_EQUAL("(base64)'YXNkAGo=...'",
                                 TStringBuilder() << InvalidValue(nonPrintable, 5));
    }
}
