#include <passport/infra/daemons/blackbox/ut/common/common.h>

#include <passport/infra/daemons/blackbox/src/misc/lrandoms_dumper.h>

#include <passport/infra/libs/cpp/auth_core/sessionsigner.h>
#include <passport/infra/libs/cpp/dbpool/db_pool.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/file.h>
#include <util/system/fs.h>

using namespace NPassport;
using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(PasspBbLRandomsDumper) {
    Y_UNIT_TEST(common) {
        SetLocalTimeZone();

        NDbPool::TDbPool db(NDbPool::TDbPoolSettings{
            .Dsn = NDbPool::TDestination::CreateSqlite(TestsDir() + "db/safeguarddb.sqlite3.sql"),
            .Size = 2,
        });
        NAuth::TSessionSigner s(db);
        s.AddKeyspace("cookiel");

        const TString filename = "./test.file";
        const TString tmpfilename = filename + ".tmp";
        const TString lrandoms = "1002323;2dL9OKKqcKHbljKQI70PMaaB7R08VnEn3jo5iAI62gPeCQ5zgI5fjjczFOMRvvaQ;1297234801\n"
                                 "959;eBTdJvb3gcZUBoYXwcOrYeTweLyiLfRjNbj3X7ULfRZrchvo0tXK776OdyAG46DT;1391936401\n"
                                 "2;bbb;1360400401\n"
                                 "1;aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa;1328774401\n";

        TLRandomsDumper d(filename, s);

        UNIT_ASSERT(NFs::Exists(filename));
        UNIT_ASSERT(!NFs::Exists(tmpfilename));
        UNIT_ASSERT_VALUES_EQUAL(lrandoms, TFileInput(filename).ReadAll());

        {
            TFileOutput f(tmpfilename);
            f << "some string";
        }
        d.Run();

        UNIT_ASSERT(NFs::Exists(filename));
        UNIT_ASSERT(!NFs::Exists(tmpfilename));
        UNIT_ASSERT_VALUES_EQUAL(lrandoms, TFileInput(filename).ReadAll());

        UNIT_ASSERT_NO_EXCEPTION(TFile(filename, OpenExisting | RdOnly));
        UNIT_ASSERT_EXCEPTION_CONTAINS(TFile(filename, RdWr), yexception, "Permission denied");
    }
}
