#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/misc/partitions.h>

#include <passport/infra/libs/cpp/xml/config.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NBb;
using namespace NPassport;

Y_UNIT_TEST_SUITE(TPasspBbPartitionsConfigTest) {
    Y_UNIT_TEST(getPatitionId) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TPartitionsSettings({}, "custom_default"),
            yexception,
            "Missing default partition 'custom_default'");

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TPartitionsSettings({{"yango", 1}}, "custom_default"),
            yexception,
            "Missing default partition 'custom_default'");

        TPartitionsSettings config({{"custom_default", 17}, {"part1", 1}, {"part2", 2}}, "custom_default");

        UNIT_ASSERT(config.IsDefaultPartition(17));
        UNIT_ASSERT(!config.IsDefaultPartition(1));
        UNIT_ASSERT(!config.IsDefaultPartition(2));
        UNIT_ASSERT(!config.IsDefaultPartition(100500));

        UNIT_ASSERT(config.IsDefaultPartition("custom_default"));
        UNIT_ASSERT(!config.IsDefaultPartition("part1"));
        UNIT_ASSERT(!config.IsDefaultPartition("part2"));

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            config.IsDefaultPartition("nonexistent"),
            TBlackboxError,
            "Unsupported partition 'nonexistent'");

        UNIT_ASSERT_VALUES_EQUAL(17, config.GetDefaultPartitionId());

        UNIT_ASSERT_VALUES_EQUAL(17, config.GetPartitionId(""));
        UNIT_ASSERT_VALUES_EQUAL(17, config.GetPartitionId("custom_default"));

        UNIT_ASSERT_VALUES_EQUAL(1, config.GetPartitionId("part1"));
        UNIT_ASSERT_VALUES_EQUAL(2, config.GetPartitionId("part2"));

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            config.GetPartitionId("nonexistent"),
            TBlackboxError,
            "Unsupported partition 'nonexistent'");

        UNIT_ASSERT_VALUES_EQUAL("custom_default", config.GetPartitionName(17));
        UNIT_ASSERT_VALUES_EQUAL("part1", config.GetPartitionName(1));
        UNIT_ASSERT_VALUES_EQUAL("part2", config.GetPartitionName(2));

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            config.GetPartitionName(100500),
            yexception,
            "Invalid partition id '100500'");
    }
}
