#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/misc/rate_limiter.h>

#include <passport/infra/libs/cpp/dbpool/query.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(RateLimiting) {
    Y_UNIT_TEST(buildQuery) {
        TRateLimiterSettings settings{
            .Period = 10,
            .Keyspace = "foo",
        };

        NDbPool::TQuery query = TKolmogorBasedRateLimiter::BuildQuery(settings, "bar", 18);
        UNIT_ASSERT_VALUES_EQUAL(
            "POST",
            query.HttpMethod());
        UNIT_ASSERT_VALUES_EQUAL(
            R"({"foo":[{"inc_if_less_than":180,"keys":["bar"]}]})",
            query.HttpBody());
    }

    Y_UNIT_TEST(parseResponse) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TKolmogorBasedRateLimiter::ParseResponse("{", "foo", "bar"),
            yexception,
            "invalid json");

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TKolmogorBasedRateLimiter::ParseResponse(R"({"kek":{}})",
                                                     "foo",
                                                     "bar"),
            yexception,
            "failed to get space 'foo' from response:");

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TKolmogorBasedRateLimiter::ParseResponse(R"({"foo":{}})",
                                                     "foo",
                                                     "bar"),
            yexception,
            "failed to get key 'bar' from response");

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TKolmogorBasedRateLimiter::ParseResponse(R"({"foo":{"bar":{}}})",
                                                     "foo",
                                                     "bar"),
            yexception,
            "failed to get key 'was_incremented' from response:");

        bool value = false;
        UNIT_ASSERT_NO_EXCEPTION(
            value = TKolmogorBasedRateLimiter::ParseResponse(R"({"foo":{"bar":{"was_incremented":false}}})",
                                                             "foo",
                                                             "bar"));
        UNIT_ASSERT(!value);

        UNIT_ASSERT_NO_EXCEPTION(
            value = TKolmogorBasedRateLimiter::ParseResponse(R"({"foo":{"bar":{"was_incremented":true}}})",
                                                             "foo",
                                                             "bar"));
        UNIT_ASSERT(value);
    }
}
