#include "synthetic_attrs_ut.h"

#include <passport/infra/daemons/blackbox/src/misc/db_profile.h>
#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/misc/synthetic_attrs.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NBb;
using namespace NPassport;

Y_UNIT_TEST_SUITE(PasspBbSyntheticWebauthnTest) {
    Y_UNIT_TEST(badAttrs) {
        TFixture fix;

        for (const auto& attr : std::vector<TString>({"1", "2", "10", "20", "101", "1001", "10001"})) {
            UNIT_ASSERT_EXCEPTION_CONTAINS(
                fix.SyntheticAttrs.GetSyntheticExtWebauthnFunc(*fix.Fetcher, attr),
                TBlackboxError,
                "invalid synthetic extended webauthn attribute type: '" + attr + "'");
        }
    }
}
