#include "generators.h"

#include <passport/infra/daemons/blackbox/src/misc/db_types.h>
#include <passport/infra/daemons/blackbox/src/misc/dbfields_converter.h>
#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/oauth/token_info.h>
#include <passport/infra/daemons/blackbox/src/output/account_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/all_tracks_result.h>
#include <passport/infra/daemons/blackbox/src/output/attributes_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/auth_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/authid_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/base_result.h>
#include <passport/infra/daemons/blackbox/src/output/billing_features_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/check_device_signature_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_grants_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_has_plus_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_rfc_totp_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_sign_result.h>
#include <passport/infra/daemons/blackbox/src/output/create_oauth_token_result.h>
#include <passport/infra/daemons/blackbox/src/output/create_session_result.h>
#include <passport/infra/daemons/blackbox/src/output/dbfields_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/decrease_sessionid_lifetime_result.h>
#include <passport/infra/daemons/blackbox/src/output/display_name_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/edit_totp_result.h>
#include <passport/infra/daemons/blackbox/src/output/emails_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/ext_attrs_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/family_info_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/family_info_result.h>
#include <passport/infra/daemons/blackbox/src/output/find_by_phone_numbers_result.h>
#include <passport/infra/daemons/blackbox/src/output/get_debug_user_ticket_result.h>
#include <passport/infra/daemons/blackbox/src/output/get_device_public_key_result.h>
#include <passport/infra/daemons/blackbox/src/output/get_max_uid_result.h>
#include <passport/infra/daemons/blackbox/src/output/get_oauth_tokens_result.h>
#include <passport/infra/daemons/blackbox/src/output/karma_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/lcookie_result.h>
#include <passport/infra/daemons/blackbox/src/output/list_result.h>
#include <passport/infra/daemons/blackbox/src/output/login_result.h>
#include <passport/infra/daemons/blackbox/src/output/loginoccupation_result.h>
#include <passport/infra/daemons/blackbox/src/output/new_session_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/oauth_result.h>
#include <passport/infra/daemons/blackbox/src/output/phone_bindings_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/phone_bindings_result.h>
#include <passport/infra/daemons/blackbox/src/output/phone_operations_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/prove_key_diag_result.h>
#include <passport/infra/daemons/blackbox/src/output/pwdhistory_result.h>
#include <passport/infra/daemons/blackbox/src/output/resigned_cookies.h>
#include <passport/infra/daemons/blackbox/src/output/sessguard_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/session_result.h>
#include <passport/infra/daemons/blackbox/src/output/table_result.h>
#include <passport/infra/daemons/blackbox/src/output/test_pwd_hashes_result.h>
#include <passport/infra/daemons/blackbox/src/output/track_result.h>
#include <passport/infra/daemons/blackbox/src/output/typed_value_result.h>
#include <passport/infra/daemons/blackbox/src/output/uid_chunk.h>
#include <passport/infra/daemons/blackbox/src/output/user_info_result.h>
#include <passport/infra/daemons/blackbox/src/output/user_ticket_result.h>
#include <passport/infra/daemons/blackbox/src/output/webauthn_credentials_result.h>

#include <contrib/libs/rapidjson/include/rapidjson/document.h>

#include <util/generic/string.h>

#include <map>
#include <vector>

namespace NPassport::NBb {
    std::unique_ptr<TAccountChunk> TChunkGenerator::GenAccountChunk() {
        TAccountChunk::TAliasesType map;
        map.insert({"", ""});
        map.insert({"7", TString("pdd7").append(1, '\0')});
        map.insert({"8", TString("pdd8").append(1, '\0')});
        map.insert({"18", TString().append(1, '\0')});
        map.insert({"18", TString().append(1, '\0')});
        map.insert({"19", "public"});
        map.insert({"20", "old-public"});

        std::unique_ptr<TAccountChunk> res = std::make_unique<TAccountChunk>();
        res->Aliases = std::move(map);
        res->HavePassword = true;
        res->HaveHint = false;
        res->Login = "Вася";
        res->AreAliasesRequired = true;

        return res;
    }

    std::unique_ptr<TAttributesChunk> TChunkGenerator::GenAttributesChunk() {
        TAttributesChunk::TAttributesType map;
        map[""] = "";
        map["118"] = TString().append(1, 0x1f).append(1, 0x13);
        map["1"] = TString().append(1, 0x4).append(1, 0x47);

        return std::make_unique<TAttributesChunk>(std::move(map));
    }

    std::unique_ptr<TAuthChunk> TChunkGenerator::GenAuthChunk() {
        return std::make_unique<TAuthChunk>(15, "s:google:123", false, true);
    }

    std::unique_ptr<TAuthIdChunk> TChunkGenerator::GenAuthIdChunk() {
        return std::make_unique<TAuthIdChunk>("1524483488711:AeZg_v8QS_4FFAAAuAYCKg:12c",
                                              "1524483488711", "2a02:6b8:0:1405:fe4b:10ff:fe60:e601", "12c");
    }

    std::unique_ptr<TBillingFeaturesChunk> TChunkGenerator::GenBillingFeaturesChunk() {
        std::unique_ptr<TBillingFeaturesChunk> res = std::make_unique<TBillingFeaturesChunk>();

        TBillingFeaturesChunk::TBillingFeatures map;
        TBillingFeaturesChunk::TFeatureAttributes attrs;
        attrs.RegionId = 9999;
        map.insert({"Music_Premium", attrs});
        attrs.InTrial = true;
        attrs.TrialDuration = 0;
        attrs.PaidTrial = false;
        attrs.RegionId = 0;
        attrs.Brand = "Apple_Music";
        map.insert({"100% cashback", attrs});

        res->Features = std::move(map);

        return res;
    }

    std::unique_ptr<TDbFieldsChunk> TChunkGenerator::GenDbFieldsChunk() {
        auto res = std::make_unique<TDbFieldsChunk>();

        TDbFieldsResult r([](const TDbProfile*) { return TString(); });

        res->Fields.push_back({"name1", r.Value(nullptr)});
        res->Fields.push_back({"subscription.suid.669", r.Value(nullptr)});

        return res;
    }

    std::unique_ptr<TDisplayNameChunk> TChunkGenerator::GenDislpayNameChunk() {
        std::unique_ptr<TDisplayNameChunk> res = std::make_unique<TDisplayNameChunk>(R"(\\\\\\.....////000)", true);

        res->Regname = "`1234567890-=~!@#$%^&*()_+/\\*-+.0\n";
        res->SetSocial("mine ", "Билайн телеком", "1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba");
        res->DisplayName = "\t\v\r\n";
        res->IsDisplayNameEmpty = false;
        res->PublicName = TPublicNameData{
            .Name = "Магистр Й.",
            .HasPublicProfile = false,
            .ThirdPartyCanUse = true,
        };

        return res;
    }

    std::unique_ptr<TEmailsChunk> TChunkGenerator::GenEmailsChunk() {
        TValidatorEmaillist emails;
        emails.AddNativeAddr("___ @ <<<<<", "789456", false, true);
        return std::make_unique<TEmailsChunk>(std::move(emails));
    }

    std::unique_ptr<TExtAttrsChunk> TChunkGenerator::GenEmailAttrs() {
        TExtAttrsChunk::TExtAttrs attrs =
            {{"entity_id3", {{"key5", "val5"}, {"key6", "val6"}}},
             {"entity_id4", {{"key7", "val7"}, {"key8", "val8"}}}};

        return std::make_unique<TExtAttrsChunk>(std::move(attrs));
    }

    std::unique_ptr<TExtAttrsChunk> TChunkGenerator::GenPhoneAttrs() {
        TExtAttrsChunk::TExtAttrs attrs =
            {{"entity_id1", {{"key1", "val1"}, {"key2", "val2"}}},
             {"entity_id2", {{"key3", "val3"}, {"key4", "val4"}}}};

        return std::make_unique<TExtAttrsChunk>(std::move(attrs));
    }

    std::unique_ptr<TExtAttrsChunk> TChunkGenerator::GenWebauthnAttrs() {
        TExtAttrsChunk::TExtAttrs attrs =
            {{"entity_id5", {{"11", "val11"}, {"12", "val12"}}},
             {"entity_id6", {{"13", "val13"}, {"14", "val14"}}}};

        return std::make_unique<TExtAttrsChunk>(std::move(attrs));
    }

    std::unique_ptr<TKarmaChunk> TChunkGenerator::GenKarmaChunk() {
        std::unique_ptr<TKarmaChunk> res = std::make_unique<TKarmaChunk>(-18, 800000000);

        res->Bantime = "789564321";

        return res;
    }

    std::unique_ptr<TNewSessionChunk> TChunkGenerator::GenNewSessionChunk() {
        auto res = std::make_unique<TNewSessionChunk>("yandex.co.il");

        res->Value = "3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0";
        res->LegacyValue = res->Value;
        res->Expires = 100009;

        return res;
    }

    std::unique_ptr<TResignedCookiesChunk> TChunkGenerator::GenResignedCookies() {
        std::unique_ptr res = std::make_unique<TResignedCookiesChunk>();
        res->Cookies.emplace("beta.beru.ru", GenNewSessionChunk());
        return res;
    }

    std::unique_ptr<TPhoneBindingsChunk> TChunkGenerator::GenPhoneBindingsChunk() {
        TPhoneBindingsChunk::TPhoneBindings vec;
        vec.push_back({"current", "79161112222", "1796513", "789564321", "1522334258", "1"});

        std::unique_ptr<TPhoneBindingsChunk> res = std::make_unique<TPhoneBindingsChunk>();
        res->Bindings = std::move(vec);
        res->Bindings.push_back({"history", "84959998877", "12321", "1130000000035661", "1522133764", "0"});

        return res;
    }

    std::unique_ptr<TPhoneOperationsChunk> TChunkGenerator::GenPhoneOperationsChunk() {
        std::unique_ptr<TPhoneOperationsChunk> res = std::make_unique<TPhoneOperationsChunk>();

        TPhoneOperationsChunk::TPhoneOperations map;
        map.insert({"key18", "val18"});
        map.insert({"key20", "val20"});
        map.insert({"key111", "val111"});

        res->Ops = std::move(map);

        return res;
    }

    std::unique_ptr<TPlusSubscriberStateChunk> TChunkGenerator::GetPlusSubscriberStateChunk() {
        std::unique_ptr<TPlusSubscriberStateChunk> res = std::make_unique<TPlusSubscriberStateChunk>();

        res->AvailableFeatures.emplace_back(TPlusSubscriberStateChunk::TAvailableFeature{
            .Id = 111,
            .Value = "foo",
            .End = TInstant::Seconds(1234567890),
        });
        res->AvailableFeatures.emplace_back(TPlusSubscriberStateChunk::TAvailableFeature{
            .Id = 222,
            .End = TInstant::Seconds(1234567899),
        });

        res->FrozenFeatures.emplace_back(TPlusSubscriberStateChunk::TFrozenFeature{
            .Id = 333,
            .Value = "bar",
        });
        res->FrozenFeatures.emplace_back(TPlusSubscriberStateChunk::TFrozenFeature{
            .Id = 444,
        });

        return res;
    }

    std::unique_ptr<TSessguardChunk> TChunkGenerator::GenSessguardChunk() {
        std::unique_ptr<TSessguardChunk> res = std::make_unique<TSessguardChunk>();

        res->Cookies.emplace("www.dev.passport.yandex.ru", TCookieChunk("sess.guard.value", ".passport.yandex.ru", 12345));
        res->Cookies.emplace("oauth.yandex.com", TCookieChunk("1.another.value", ".oauth.yandex.com", 54321));

        return res;
    }

    std::unique_ptr<TUidChunk> TChunkGenerator::GenUidChunk() {
        std::unique_ptr<TUidChunk> res = std::make_unique<TUidChunk>();

        res->Hosted = true;
        res->Uid = "1130000000035661";
        res->CatchAll = true;
        res->Lite = false;
        res->Domain = "havroshik.ru";
        res->DomainEna = true;
        res->DomainId = "1796513";
        res->Mx = false;

        return res;
    }

    std::unique_ptr<TFamilyInfoChunk> TChunkGenerator::GenFamilyChunk() {
        std::unique_ptr<TFamilyInfoChunk> res = std::make_unique<TFamilyInfoChunk>();

        res->FamilyId = "f100500";
        res->AdminUid = "789546";

        return res;
    }

    namespace {
        std::unique_ptr<rapidjson::Document> GenRapidJson() {
            std::unique_ptr<rapidjson::Document> res = std::make_unique<rapidjson::Document>();
            res->Parse(R"({"some key":"some value"})");
            return res;
        }
    }

    std::unique_ptr<TBlackboxError> TResultGenerator::GenBlackboxError() {
        auto res = std::make_unique<TBlackboxError>(TBlackboxError::EType::AccessDenied);
        (*res) << "Хочу интерфейс попроще";
        return res;
    }

    std::unique_ptr<TSessionUser> TResultGenerator::GenSessionUser() {
        std::unique_ptr<TSessionUser> res = std::make_unique<TSessionUser>();

        res->Status = TSessionidProcessor::ESessionStatus::DISABLED;
        res->Comment = "User has globally logged out";
        res->Auth = TChunkGenerator::GenAuthChunk();

        PrepareBaseResult(*res);

        return res;
    }

    std::unique_ptr<TAllTracksResult> TResultGenerator::GetAllTracksResult() {
        std::unique_ptr<TAllTracksResult> res = std::make_unique<TAllTracksResult>();

        res->Tracks.push_back(GetTrackResult());
        res->Tracks.push_back(GetTrackResult());
        res->Tracks.push_back(GetTrackResult());
        res->Tracks.push_back(GetTrackResult());

        return res;
    }

    std::unique_ptr<TBulkUserInfoResult> TResultGenerator::GetBulkUserInfoResult() {
        std::unique_ptr<TBulkUserInfoResult> res = std::make_unique<TBulkUserInfoResult>();

        res->Results.push_back({"545649841568645678", GenUserInfoResult()});

        return res;
    }

    std::unique_ptr<TBulkUserInfoResult> TResultGenerator::GetEmptyBulkUserInfoResult() {
        std::unique_ptr<TBulkUserInfoResult> res = std::make_unique<TBulkUserInfoResult>();

        res->Results.push_back({"5456498415686412345", std::make_unique<TUserInfoResult>()});
        res->Results.push_back({"", std::make_unique<TUserInfoResult>()});

        return res;
    }

    std::unique_ptr<TCheckRfcTotpResult> TResultGenerator::GetCheckRfcTotpResult() {
        return std::make_unique<TCheckRfcTotpResult>("SECRET_NOT_FOUND", 123123123);
    }

    std::unique_ptr<TCheckSignResult> TResultGenerator::GetCheckSignResult() {
        return std::make_unique<TCheckSignResult>("OK", "Custom value: %<&\"+-.");
    }

    std::unique_ptr<TCreateOAuthTokenResult> TResultGenerator::GetCreateOAuthTokenResult() {
        return std::make_unique<TCreateOAuthTokenResult>(
            "1.1130000000035661.1111.1515151515.1489673861057.136.7haq5WAB5FQRP-FH.AHG3GvbJBdK3R_mDC7xs290CPqkA3EIx135bG6W-bpPMgXnjccQrN9ghNSGAGGiI8YloyOsy.peNUloIa5tThhRoWhqou6Q",
            "14896738610571130000000035661");
    }

    std::unique_ptr<TCreateSessionResult> TResultGenerator::GetCreateSessionResult() {
        std::unique_ptr<TCreateSessionResult> res = std::make_unique<TCreateSessionResult>();

        res->DefaultUid = "105000500";
        res->NewSession = TChunkGenerator::GenNewSessionChunk();
        res->NewSessguards = TChunkGenerator::GenSessguardChunk();
        res->AuthId = TChunkGenerator::GenAuthIdChunk();
        res->LoginId = "t:custom_login_id";

        return res;
    }

    std::unique_ptr<TEditTotpResult> TResultGenerator::GetEditTotpResult() {
        std::unique_ptr<TEditTotpResult> res = std::make_unique<TEditTotpResult>();

        res->SetError("lmxkvlmvkd;lmkdfsm sdf 23lk e23 2323");
        res->SetSecretValue("3:1:1:ysYHxLwafIr4T7i7HTbQVQ==:KeTT2u0oRjwkA5en40xNUeklE4LKy8hS1kPTDbzYRGHvozLvnhCBEEPPrgHRfZit:CGuBJy5J2/+jHuie+iy4b/n4M2nKtaX3lsKsxXVmMgY=", "123123123");
        res->SetJunkSecretValue("ibhj23j3k 3i2h341io 190;l,./<>Msad");

        return res;
    }

    std::unique_ptr<TLCookieResult> TResultGenerator::GetLCookieResult() {
        std::unique_ptr<TLCookieResult> res = std::make_unique<TLCookieResult>();

        res->Uid = "646151263511236512";
        res->Timestamp = "12313915";
        res->Login = ">>>>>qadadads";
        res->DisplayLogin = " 😂 ";

        return res;
    }

    std::unique_ptr<TListResult> TResultGenerator::GetListResult() {
        std::unique_ptr<TListResult> res = std::make_unique<TListResult>("oijdsanoisasad ", "KUYAGOADBAS8a8dasdsadsa");

        res->TotalCount = 17;
        TListResult::TStringVector vec =
            {"123123<<>>", "1231tegsgdf ", "904rjwrogi"};
        res->Data = std::move(vec);

        return res;
    }

    std::unique_ptr<TLoginOccupationResult> TResultGenerator::GetLoginOccupationResult() {
        std::unique_ptr<TLoginOccupationResult> res = std::make_unique<TLoginOccupationResult>();

        TLoginOccupationStatusMap map;
        map.emplace("OccupiedLogin", TLoginOccupationStatus(TLoginOccupationStatus::Busy, "12345"));
        map.emplace("Stop-word.Login", TLoginOccupationStatus(TLoginOccupationStatus::Stop));
        map.emplace("M@lformed@", TLoginOccupationStatus(TLoginOccupationStatus::Malformed));
        map.emplace("Public_id.login", TLoginOccupationStatus(TLoginOccupationStatus::PublicId, "100500"));
        map.emplace("", TLoginOccupationStatus(TLoginOccupationStatus::Malformed));
        res->Statuses = std::move(map);

        return res;
    }

    std::unique_ptr<TLoginResult> TResultGenerator::GetLoginResult() {
        std::unique_ptr<TLoginResult> res = std::make_unique<TLoginResult>();

        res->LoginStatus = 0;
        res->LoginStatusStr = "What's up!";
        res->PasswordStatus = 2;
        res->PasswordStatusStr = "2What'123s zcx```up!";
        res->Comment = "frkjfen ew ewfoiv 9`jwef";
        res->ApiVersion = 18;
        res->ResistPolicy = TLoginResult::Expired;
        res->ResistDelay = 12;
        res->RestrictSession = true;
        res->TotpCheckTime = 1231231243554;
        res->ConnectionId = "t:111111243";
        res->BadauthCounts = TBadauthCountersChunk();
        res->BadauthCounts->Counters = {{"login", 1, 10}, {"password", 100, 20}};

        PrepareBaseResult(*res);

        return res;
    }

    std::unique_ptr<TLoginResult> TResultGenerator::GetLoginResultDelay() {
        std::unique_ptr<TLoginResult> res = std::make_unique<TLoginResult>();

        res->LoginStatus = 0;
        res->LoginStatusStr = "What's up!";
        res->PasswordStatus = 2;
        res->PasswordStatusStr = "2What'123s zcx```up!";
        res->Comment = "frkjfen ew ewfoiv 9`jwef";
        res->ApiVersion = 18;
        res->ResistPolicy = TLoginResult::Delay;
        res->ResistDelay = 180;
        res->RestrictSession = false;
        res->ConnectionId = "t:111111243";
        res->AllowedSecondSteps = "sms,totp";
        res->ScholarSession = true;

        PrepareBaseResult(*res);

        return res;
    }

    std::unique_ptr<TOAuthResult> TResultGenerator::GetOAuthResult() {
        std::unique_ptr<TOAuthTokenInfo> info = std::make_unique<TOAuthTokenInfo>(false);
        info->SetScopes(TOAuthScopes("mail:imap_full mobile:all mobmail:all",
                                     true,
                                     19,
                                     std::unordered_set<TString>{"scope номер раз", "скоуп 2"}));
        info->Uid = "";
        info->TokenId = "< >?";
        info->DeviceId = "<>?";
        info->SetTokenAttr(TOAuthTokenAttr::DEVICE_NAME, "Ай😂фонь");
        info->CreateTime = "fgb";
        info->IssueTime = "sfsfdsgdfgdfga12312312";
        info->ExpireTime = "something";
        info->CreateTimeTs = 78;
        info->IssueTimeTs = -100500;
        info->ExpireTimeTs = 0;
        info->IsRefreshRequired = false;
        info->IsTtlRefreshable = true;
        info->SetClientAttr(TOAuthClientAttr::DISPLAY_ID, "   \\ s");
        info->SetClientAttr(TOAuthClientAttr::DEFAULT_TITLE, "IKM");
        info->ClientIcon = "OL<";
        info->SetClientAttr(TOAuthClientAttr::HOMEPAGE, "https://mail.ru");
        info->ClientCreatetime = "{|";
        info->ClientIsYandex = false;
        info->SetTokenAttr(TOAuthTokenAttr::X_TOKEN_ID, "15016677547314001096104");
        info->SetTokenAttr(TOAuthTokenAttr::META, "\\ []]");
        info->NullExpire = true;
        info->SetTokenAttr("19", "1");

        std::unique_ptr<TOAuthResult> res = std::make_unique<TOAuthResult>();
        res->OauthChunk.TokenInfo = std::move(info);

        res->OauthChunk.Status = TOAuthStatus::Disabled;
        res->OauthChunk.Comment = "ничего интересного";
        res->ConnectionId = "t:15016677547314001096104";
        res->OauthChunk.LoginId = "s:1524483488777:AeZg_v8QS_4FFAAAuAYCKg:1";

        TAttributesChunk::TAttributesType tokenAttrs;
        tokenAttrs["1"] = "12345";
        tokenAttrs["3"] = "True";
        tokenAttrs["11"] = "value";
        res->OauthChunk.TokenAttrs = std::make_unique<TAttributesChunk>(std::move(tokenAttrs));

        TAttributesChunk::TAttributesType clientAttrs;
        clientAttrs["2"] = "-1";
        clientAttrs["6"] = "0";
        clientAttrs["8"] = "";
        res->OauthChunk.ClientAttrs = std::make_unique<TAttributesChunk>(std::move(clientAttrs));

        PrepareBaseResult(*res);

        return res;
    }

    std::unique_ptr<TPhoneBindingsResult> TResultGenerator::GetPhoneBindingsResult() {
        std::unique_ptr<TPhoneBindingsResult> res = std::make_unique<TPhoneBindingsResult>();

        res->PhoneBindingsChunk = TChunkGenerator::GenPhoneBindingsChunk();

        return res;
    }

    std::unique_ptr<TProveKeyDiagResult> TResultGenerator::GetProveKeyDiagResult() {
        std::unique_ptr<TProveKeyDiagResult> res = std::make_unique<TProveKeyDiagResult>();

        res->IsSecretIdCorrect = {false, 5498181};
        res->IsPinSecretCorrect = {true, 1231};
        res->IsTotpCorrect = {false, 23412312};
        res->CorrectTimestamp = {13123, 12321};

        return res;
    }

    std::unique_ptr<TPwdHistoryResult> TResultGenerator::GetPwdHistoryResult() {
        std::unique_ptr<TPwdHistoryResult> res = std::make_unique<TPwdHistoryResult>();
        res->Reason = "><><><>|??L";
        return res;
    }

    std::unique_ptr<TSessionResult> TResultGenerator::GetSessionResult(bool isMultisession) {
        std::unique_ptr<TSessionResult> res = std::make_unique<TSessionResult>();

        res->IsMultisession = isMultisession;
        res->Status = TSessionidProcessor::ESessionStatus::NOAUTH;
        res->Comment = "horay!!<<<>>";
        res->Age = 127;
        res->Expires = 128;
        res->Ttl = "5";
        res->AuthId = TChunkGenerator::GenAuthIdChunk();
        res->NewSession = TChunkGenerator::GenNewSessionChunk();
        res->ResignedCookies = TChunkGenerator::GenResignedCookies();
        res->NewSessguards = TChunkGenerator::GenSessguardChunk();
        res->SpecialKind = TSessionResult::Stress;
        res->ConnectionId = "s:1524483488711:AeZg_v8QS_4FFAAAuAYCKg:12c";
        res->LoginId = "t:15456677547314001096104";
        res->DefaultId = 0;
        res->AllowMoreUsers = true;
        res->Users.push_back({"18", GenSessionUser()});
        res->Users.back().second->IsRegCompletionRecommended = true;
        res->Users.push_back({"12", GenSessionUser()});
        res->UserTicket = "3:user:CA0Q__________9_GiMKAgh7CgMIyAMQyAMaB2JiOnNlc3MaCGJiOnNlc3MyIBIoAQ:GQy3cNgiJW";

        return res;
    }

    std::unique_ptr<TSessionResult> TResultGenerator::GetSessionResultSimple() {
        std::unique_ptr<TSessionResult> res = std::make_unique<TSessionResult>();

        res->Status = TSessionidProcessor::ESessionStatus::NEED_RESET;
        res->Comment = "horay!!<<<>>";
        res->Users.push_back({"-1", std::unique_ptr<TSessionUser>()});
        res->Users.push_back({"0", std::make_unique<TSessionUser>()});
        res->IsMultisession = true;

        return res;
    }
    std::unique_ptr<TTableResult> TResultGenerator::GetTableResult() {
        TTableResult::TStringVector col =
            {"123", "еще одна", "и еще"};
        std::unique_ptr<TTableResult> res = std::make_unique<TTableResult>("Мой любимый результат", col);

        res->Rows = {
            {"номер1", "ключ1", "значение1"},
            {"номер2", "ключ2", "значение2"},
            {"номер3", "ключ3"},
        };

        return res;
    }

    std::unique_ptr<TTestPwdHashesResult> TResultGenerator::GetTestPwdHashesResult() {
        std::unique_ptr<TTestPwdHashesResult> res = std::make_unique<TTestPwdHashesResult>();

        res->Data = {
            {"ога", false},
            {"агу", true},
        };

        return res;
    }

    std::unique_ptr<TTrackResult> TResultGenerator::GetTrackResult() {
        std::unique_ptr<TTrackResult> res = std::make_unique<TTrackResult>("78953621", "12312312312adsa<<");

        res->Created = "465153138981";
        res->Expired = "98794511";
        res->Content = "my json";
        res->ContentRapidObj = GenRapidJson();

        return res;
    }

    std::unique_ptr<TUserInfoResult> TResultGenerator::GenUserInfoResult() {
        std::unique_ptr<TUserInfoResult> res = std::make_unique<TUserInfoResult>();

        res->PinStatus = std::make_unique<bool>(false);

        PrepareBaseResult(*res);

        return res;
    }

    std::unique_ptr<TCheckDeviceSignatureResult> TResultGenerator::GenCheckDeviceSignatureResult() {
        return std::make_unique<TCheckDeviceSignatureResult>("SOME.STATUS", "some MEGA 10005000 error");
    }

    std::unique_ptr<TGetDevicePublicKeyResult> TResultGenerator::GenGetDevicePublicKeyResult() {
        return std::make_unique<TGetDevicePublicKeyResult>(
            "OK.STATUS",
            "some value",
            "mega version",
            "mega_master",
            "fatal кошмар");
    }

    std::unique_ptr<TCheckHasPlusResult> TResultGenerator::GenCheckHasPlusResult(bool has) {
        if (has) {
            return std::make_unique<TCheckHasPlusResult>(true, "100500");
        }

        return std::make_unique<TCheckHasPlusResult>(false, "");
    }

    std::unique_ptr<TFamilyInfoResult> TResultGenerator::GenFamilyInfoResult(bool found) {
        std::unique_ptr<TFamilyInfoResult> res = std::make_unique<TFamilyInfoResult>();

        res->Status.Value = "__some_status_value__";
        if (!found) {
            res->Status.Description = "__some_status_description__";
        }

        res->FamilyId = "__some_family_id__";

        if (found) {
            res->AdminUid = "__some_admin_uid__";
            res->Users = {
                {.Uid = "42", .IsKid = true},
                {.Uid = "43", .Place = "17"},
                {.Uid = "44", .IsChild = true},
                {.Uid = "45"},
                {.Uid = "46", .BaseResult = std::make_shared<TBaseResult>()},
            };
            PrepareBaseResult(*res->Users.back().BaseResult);
        }

        res->AllowMoreKids = found;

        return res;
    }

    std::unique_ptr<TFindByPhoneNumbersResult> TResultGenerator::GenFindByPhoneNumbersResult() {
        std::unique_ptr<TFindByPhoneNumbersResult> res = std::make_unique<TFindByPhoneNumbersResult>();

        res->Data["79161112233"] = {};
        res->Data["79992223344"] = {"12345", "56789", "1130000000035661"};

        return res;
    }

    std::unique_ptr<TUserTicketResult> TResultGenerator::GenUserTicketResult() {
        std::unique_ptr<TUserTicketResult> res = std::make_unique<TUserTicketResult>();

        std::unique_ptr user = std::make_unique<TUserInfoResult>();
        PrepareBaseResult(*user);
        res->Results.emplace_back("1130000000035661", std::move(user));

        res->ForKid = TUserTicketResult::TForKid{
            .Error = "some big error",
            .UserTicket = "some user ticket",
        };

        return res;
    }

    std::unique_ptr<TWebauthnCredentialsResult> TResultGenerator::GenWebauthnCredentialsResult() {
        return std::make_unique<TWebauthnCredentialsResult>("credential_id_string", "100500");
    }

    std::unique_ptr<TCheckGrantsResult> TResultGenerator::GenCheckGrantsResult() {
        std::unique_ptr<TCheckGrantsResult> res = std::make_unique<TCheckGrantsResult>();

        res->Errors = {
            "some error 1",
            "all errors of this world",
        };

        return res;
    }

    std::unique_ptr<TGetMaxUidResult> TResultGenerator::GenGetMaxUidResult() {
        std::unique_ptr<TGetMaxUidResult> res = std::make_unique<TGetMaxUidResult>();

        res->Uid = 100500;
        res->Pdduid = 42;

        return res;
    }

    std::unique_ptr<TGetDebugUserTicketResult> TResultGenerator::GenGetDebugUserTicketResult() {
        std::unique_ptr<TGetDebugUserTicketResult> res = std::make_unique<TGetDebugUserTicketResult>();

        res->Status = "SOMESTATUS";
        res->Comment = "some comment";
        res->UsetTicket = "some userticket";

        return res;
    }

    std::unique_ptr<TGetOAuthTokensResult> TResultGenerator::GenGetOAuthTokensResult() {
        std::unique_ptr res = std::make_unique<TGetOAuthTokensResult>();

        auto convert = [&res](std::unique_ptr<TOAuthResult> tokenResult) {
            res->Tokens.push_back(std::move(tokenResult->OauthChunk));
        };

        convert(GetOAuthResult());

        std::unique_ptr tokenResult = GetOAuthResult();
        tokenResult->OauthChunk.TokenInfo->TokenId = "789654123";
        convert(std::move(tokenResult));

        return res;
    }

    std::unique_ptr<TDecreaseSessionidLifetimeResult> TResultGenerator::GenDecreaseSessionidLifetimeResult() {
        std::unique_ptr<TDecreaseSessionidLifetimeResult> res = std::make_unique<TDecreaseSessionidLifetimeResult>();

        res->Status = "SOMESTATUS";
        res->Comment = "some comment";
        res->Session = "some session";

        return res;
    }

    void TResultGenerator::PrepareBaseResult(TBaseResult& res) {
        res.Uid = TChunkGenerator::GenUidChunk();
        res.Account = TChunkGenerator::GenAccountChunk();
        res.Karma = TChunkGenerator::GenKarmaChunk();
        res.DisplayName = TChunkGenerator::GenDislpayNameChunk();
        res.Dbfields = TChunkGenerator::GenDbFieldsChunk();
        res.Attributes = TChunkGenerator::GenAttributesChunk();
        res.Emails = TChunkGenerator::GenEmailsChunk();
        res.PhoneAttrs = TChunkGenerator::GenPhoneAttrs();
        res.EmailAttrs = TChunkGenerator::GenEmailAttrs();
        res.WebauthnAttrs = TChunkGenerator::GenWebauthnAttrs();
        res.PhoneOperations = TChunkGenerator::GenPhoneOperationsChunk();
        res.PhoneBindings = TChunkGenerator::GenPhoneBindingsChunk();
        res.UserTicket = "2:3:4:fasdfd==";
        res.BillingFeatures = TChunkGenerator::GenBillingFeaturesChunk();
        res.PlusSubscriberState = TChunkGenerator::GetPlusSubscriberStateChunk();
        res.PublicId = std::make_unique<TString>("Y:abc.def.asdfghjik123");
        res.FamilyInfo = TChunkGenerator::GenFamilyChunk();
    }
}
