#pragma once

#include <memory>

namespace NPassport::NBb {
    class TAccountChunk;
    class TAttributesChunk;
    class TAuthChunk;
    class TAuthIdChunk;
    class TBillingFeaturesChunk;
    class TDbFieldsChunk;
    class TDisplayNameChunk;
    class TEmailsChunk;
    class TExtAttrsChunk;
    class TFamilyInfoChunk;
    class TGetDevicePublicKeyResult;
    class TKarmaChunk;
    class TNewSessionChunk;
    class TPhoneBindingsChunk;
    class TPhoneOperationsChunk;
    class TPlusSubscriberStateChunk;
    class TResignedCookiesChunk;
    class TSessguardChunk;
    class TUidChunk;

    class TChunkGenerator {
    public:
        static std::unique_ptr<TAccountChunk> GenAccountChunk();
        static std::unique_ptr<TAttributesChunk> GenAttributesChunk();
        static std::unique_ptr<TAuthChunk> GenAuthChunk();
        static std::unique_ptr<TAuthIdChunk> GenAuthIdChunk();
        static std::unique_ptr<TBillingFeaturesChunk> GenBillingFeaturesChunk();
        static std::unique_ptr<TDbFieldsChunk> GenDbFieldsChunk();
        static std::unique_ptr<TDisplayNameChunk> GenDislpayNameChunk();
        static std::unique_ptr<TEmailsChunk> GenEmailsChunk();
        static std::unique_ptr<TExtAttrsChunk> GenEmailAttrs();
        static std::unique_ptr<TExtAttrsChunk> GenPhoneAttrs();
        static std::unique_ptr<TExtAttrsChunk> GenWebauthnAttrs();
        static std::unique_ptr<TKarmaChunk> GenKarmaChunk();
        static std::unique_ptr<TNewSessionChunk> GenNewSessionChunk();
        static std::unique_ptr<TResignedCookiesChunk> GenResignedCookies();
        static std::unique_ptr<TPhoneBindingsChunk> GenPhoneBindingsChunk();
        static std::unique_ptr<TPhoneOperationsChunk> GenPhoneOperationsChunk();
        static std::unique_ptr<TPlusSubscriberStateChunk> GetPlusSubscriberStateChunk();
        static std::unique_ptr<TSessguardChunk> GenSessguardChunk();
        static std::unique_ptr<TUidChunk> GenUidChunk();
        static std::unique_ptr<TFamilyInfoChunk> GenFamilyChunk();
    };

    class TBlackboxError;
    class TSessionUser;

    class TAllTracksResult;
    class TBaseResult;
    class TBulkUserInfoResult;
    class TCheckDeviceSignatureResult;
    class TCheckGrantsResult;
    class TCheckHasPlusResult;
    class TCheckRfcTotpResult;
    class TCheckSignResult;
    class TCreateOAuthTokenResult;
    class TCreateSessionResult;
    class TDecreaseSessionidLifetimeResult;
    class TEditTotpResult;
    class TFamilyInfoResult;
    class TFindByPhoneNumbersResult;
    class TGetDebugUserTicketResult;
    class TGetMaxUidResult;
    class TGetOAuthTokensResult;
    class TLCookieResult;
    class TListResult;
    class TLoginOccupationResult;
    class TLoginResult;
    class TOAuthResult;
    class TPhoneBindingsResult;
    class TProveKeyDiagResult;
    class TPwdHistoryResult;
    class TSessionResult;
    class TTableResult;
    class TTestPwdHashesResult;
    class TTrackResult;
    class TTypedValueResult;
    class TUserInfoResult;
    class TUserTicketResult;
    class TWebauthnCredentialsResult;

    class TResultGenerator {
    public:
        static std::unique_ptr<TBlackboxError> GenBlackboxError();
        static std::unique_ptr<TSessionUser> GenSessionUser();

        static std::unique_ptr<TAllTracksResult> GetAllTracksResult();
        static std::unique_ptr<TBulkUserInfoResult> GetBulkUserInfoResult();
        static std::unique_ptr<TBulkUserInfoResult> GetEmptyBulkUserInfoResult();
        static std::unique_ptr<TCheckRfcTotpResult> GetCheckRfcTotpResult();
        static std::unique_ptr<TCheckSignResult> GetCheckSignResult();
        static std::unique_ptr<TCreateOAuthTokenResult> GetCreateOAuthTokenResult();
        static std::unique_ptr<TCreateSessionResult> GetCreateSessionResult();
        static std::unique_ptr<TEditTotpResult> GetEditTotpResult();
        static std::unique_ptr<TLCookieResult> GetLCookieResult();
        static std::unique_ptr<TListResult> GetListResult();
        static std::unique_ptr<TLoginOccupationResult> GetLoginOccupationResult();
        static std::unique_ptr<TLoginResult> GetLoginResult();
        static std::unique_ptr<TLoginResult> GetLoginResultDelay();
        static std::unique_ptr<TOAuthResult> GetOAuthResult();
        static std::unique_ptr<TPhoneBindingsResult> GetPhoneBindingsResult();
        static std::unique_ptr<TProveKeyDiagResult> GetProveKeyDiagResult();
        static std::unique_ptr<TPwdHistoryResult> GetPwdHistoryResult();
        static std::unique_ptr<TSessionResult> GetSessionResult(bool isMultisession);
        static std::unique_ptr<TSessionResult> GetSessionResultSimple();
        static std::unique_ptr<TTableResult> GetTableResult();
        static std::unique_ptr<TTestPwdHashesResult> GetTestPwdHashesResult();
        static std::unique_ptr<TTrackResult> GetTrackResult();
        template <typename T>
        static std::unique_ptr<TTypedValueResult> GetTypedValueResult(T arg);
        static std::unique_ptr<TUserInfoResult> GenUserInfoResult();
        static std::unique_ptr<TCheckDeviceSignatureResult> GenCheckDeviceSignatureResult();
        static std::unique_ptr<TGetDevicePublicKeyResult> GenGetDevicePublicKeyResult();
        static std::unique_ptr<TCheckHasPlusResult> GenCheckHasPlusResult(bool has);
        static std::unique_ptr<TFamilyInfoResult> GenFamilyInfoResult(bool found);
        static std::unique_ptr<TFindByPhoneNumbersResult> GenFindByPhoneNumbersResult();
        static std::unique_ptr<TUserTicketResult> GenUserTicketResult();
        static std::unique_ptr<TWebauthnCredentialsResult> GenWebauthnCredentialsResult();
        static std::unique_ptr<TCheckGrantsResult> GenCheckGrantsResult();
        static std::unique_ptr<TGetMaxUidResult> GenGetMaxUidResult();
        static std::unique_ptr<TGetDebugUserTicketResult> GenGetDebugUserTicketResult();
        static std::unique_ptr<TGetOAuthTokensResult> GenGetOAuthTokensResult();
        static std::unique_ptr<TDecreaseSessionidLifetimeResult> GenDecreaseSessionidLifetimeResult();

        static void PrepareBaseResult(TBaseResult& res);
    };

    template <typename T>
    std::unique_ptr<TTypedValueResult> TResultGenerator::GetTypedValueResult(T arg) {
        return std::make_unique<TTypedValueResult>("123456789.", arg);
    }

}
