#include "generators.h"

#include <passport/infra/daemons/blackbox/ut/common/common.h>

#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/output/all_tracks_result.h>
#include <passport/infra/daemons/blackbox/src/output/base_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_device_signature_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_grants_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_has_plus_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_rfc_totp_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_sign_result.h>
#include <passport/infra/daemons/blackbox/src/output/create_oauth_token_result.h>
#include <passport/infra/daemons/blackbox/src/output/create_session_result.h>
#include <passport/infra/daemons/blackbox/src/output/decrease_sessionid_lifetime_result.h>
#include <passport/infra/daemons/blackbox/src/output/edit_totp_result.h>
#include <passport/infra/daemons/blackbox/src/output/family_info_result.h>
#include <passport/infra/daemons/blackbox/src/output/find_by_phone_numbers_result.h>
#include <passport/infra/daemons/blackbox/src/output/get_debug_user_ticket_result.h>
#include <passport/infra/daemons/blackbox/src/output/get_device_public_key_result.h>
#include <passport/infra/daemons/blackbox/src/output/get_max_uid_result.h>
#include <passport/infra/daemons/blackbox/src/output/get_oauth_tokens_result.h>
#include <passport/infra/daemons/blackbox/src/output/json_serializer.h>
#include <passport/infra/daemons/blackbox/src/output/lcookie_result.h>
#include <passport/infra/daemons/blackbox/src/output/list_result.h>
#include <passport/infra/daemons/blackbox/src/output/login_result.h>
#include <passport/infra/daemons/blackbox/src/output/loginoccupation_result.h>
#include <passport/infra/daemons/blackbox/src/output/oauth_result.h>
#include <passport/infra/daemons/blackbox/src/output/phone_bindings_result.h>
#include <passport/infra/daemons/blackbox/src/output/prove_key_diag_result.h>
#include <passport/infra/daemons/blackbox/src/output/pwdhistory_result.h>
#include <passport/infra/daemons/blackbox/src/output/session_result.h>
#include <passport/infra/daemons/blackbox/src/output/table_result.h>
#include <passport/infra/daemons/blackbox/src/output/test_pwd_hashes_result.h>
#include <passport/infra/daemons/blackbox/src/output/track_result.h>
#include <passport/infra/daemons/blackbox/src/output/typed_value_result.h>
#include <passport/infra/daemons/blackbox/src/output/user_info_result.h>
#include <passport/infra/daemons/blackbox/src/output/user_ticket_result.h>
#include <passport/infra/daemons/blackbox/src/output/webauthn_credentials_result.h>

#include <passport/infra/libs/cpp/request/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(PasspBbJson) {
    template <typename T>
    void T(T res, const TString& expected) {
        TString buf = TJsonSerializer::Serialize(*res);
        UNIT_ASSERT_VALUES_EQUAL(expected, buf);
    }

    void T(const TBlackboxError& res, const TString& expected) {
        TExceptionInfo info;
        info.Status = res.Status();
        info.Msg = res.what();
        info.ExtendedDescription = "Please request grants here: https://forms.yandex-team.ru/surveys/4901 . "
                                   "If you are sure you have grants, please mail to passport-admin@yandex-team.ru";
        info.Method = "userinfo";
        info.Host = "mega.blackbox";
        info.Hostname = "some-f1.blackbox";
        info.CurrentTime = "some correct time";

        TString buf = TJsonSerializer::SerializeException(info);
        UNIT_ASSERT_VALUES_EQUAL(expected, buf);
    }

    Y_UNIT_TEST(blackboxError) {
        T(*TResultGenerator::GenBlackboxError(),
          R"({"exception":{"value":"ACCESS_DENIED","id":21},"error":"\u0425\u043E\u0447\u0443 \u0438\u043D\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u043F\u043E\u043F\u0440\u043E\u0449\u0435. )"
          R"(request_id=. )"
          R"(ext=Please request grants here: https:\/\/forms.yandex-team.ru\/surveys\/4901 . If you are sure you have grants, please mail to passport-admin@yandex-team.ru. )"
          R"(method=userinfo. )"
          R"(host=mega.blackbox. )"
          R"(hostname=some-f1.blackbox. )"
          R"(current_time=some correct time)"
          R"("})");
    }

    Y_UNIT_TEST(allTracksResult) {
        T(TResultGenerator::GetAllTracksResult(),
          R"({"track":[)"
          R"({"uid":"78953621","track_id":"12312312312adsa<<","content":{"some key":"some value"},"created":"465153138981","expired":"98794511"},)"
          R"({"uid":"78953621","track_id":"12312312312adsa<<","content":{"some key":"some value"},"created":"465153138981","expired":"98794511"},)"
          R"({"uid":"78953621","track_id":"12312312312adsa<<","content":{"some key":"some value"},"created":"465153138981","expired":"98794511"},)"
          R"({"uid":"78953621","track_id":"12312312312adsa<<","content":{"some key":"some value"},"created":"465153138981","expired":"98794511"}]})");
    }

    Y_UNIT_TEST(bulkUserInfoResult) {
        T(TResultGenerator::GetEmptyBulkUserInfoResult(),
          R"({"users":[{"id":"5456498415686412345"},{"id":""}]})");

        T(TResultGenerator::GetBulkUserInfoResult(),
          R"({"users":[{"id":"545649841568645678",)"
          R"("uid":{"value":"1130000000035661","lite":false,"hosted":true,"domid":"1796513","domain":"havroshik.ru","mx":"0","domain_ena":"1","catch_all":true},)"
          R"("login":"\u0412\u0430\u0441\u044F","have_password":true,"have_hint":false,)"
          R"("aliases":{"":"","18":"\u0000","18":"\u0000","19":"public","20":["old-public"],"7":"pdd7\u0000","8":["pdd8\u0000"]},)"
          R"("karma":{"value":-18,"allow-until":789564321},"karma_status":{"value":800000000},)"
          R"("regname":"`1234567890-=~!@#$%^&*()_+\/\\*-+.0\n",)"
          R"("display_name":{"name":"\t\u000B\r\n","display_name_empty":false,"public_name":"\u041C\u0430\u0433\u0438\u0441\u0442\u0440 \u0419.",)"
          R"("has_public_profile":false,"third_party_can_use":true,"avatar":{"default":"\\\\\\\\\\\\.....\/\/\/\/000","empty":false},"verified":true,)"
          R"("social":{"profile_id":"mine ","provider":"\u0411\u0438\u043B\u0430\u0439\u043D \u0442\u0435\u043B\u0435\u043A\u043E\u043C",)"
          R"("redirect_target":"1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba"}},)"
          R"("dbfields":{"name1":"","subscription.suid.669":""},"attributes":{"":"","1":"\u0004G","118":"\u001F\u0013"},)"
          R"("address-list":[{"address":"___ @ <<<<<","validated":true,"default":false,"rpop":false,"silent":false,"unsafe":false,"native":true,"born-date":"789456"}],)"
          R"("phones":[{"id":"entity_id1","attributes":{"key1":"val1","key2":"val2"}},{"id":"entity_id2","attributes":{"key3":"val3","key4":"val4"}}],)"
          R"("emails":[{"id":"entity_id3","attributes":{"key5":"val5","key6":"val6"}},{"id":"entity_id4","attributes":{"key7":"val7","key8":"val8"}}],)"
          R"("webauthn_credentials":[{"id":"entity_id5","attributes":{"11":"val11","12":"val12"}},{"id":"entity_id6","attributes":{"13":"val13","14":"val14"}}],)"
          R"("phone_operations":{"key111":"val111","key18":"val18","key20":"val20"},)"
          R"("phone_bindings":[{"type":"current","number":"79161112222","phone_id":"1796513","uid":"789564321","bound":"1522334258","flags":"1"},{"type":"history","number":"84959998877","phone_id":"12321","uid":"1130000000035661","bound":"1522133764","flags":"0"}],)"
          R"("billing_features":{"100% cashback":{"in_trial":true,"paid_trial":false,"region_id":0,"trial_duration":0,"brand":"Apple_Music"},"Music_Premium":{"region_id":9999}},)"
          R"("plus_subscriber_state":{"available_features":[{"id":111,"end":1234567890,"value":"foo"},{"id":222,"end":1234567899}],"frozen_features":[{"id":333,"value":"bar"},{"id":444}]},)"
          R"("family_info":{"family_id":"f100500","admin_uid":"789546"},)"
          R"("user_ticket":"2:3:4:fasdfd==",)"
          R"("public_id":"Y:abc.def.asdfghjik123",)"
          R"("pin_status":false}]})");
    }

    Y_UNIT_TEST(checkRfcTotpResult) {
        T(TResultGenerator::GetCheckRfcTotpResult(),
          R"({"status":"SECRET_NOT_FOUND","time":123123123})");
    }

    Y_UNIT_TEST(checkSignResult) {
        T(TResultGenerator::GetCheckSignResult(),
          R"({"status":"OK","value":"Custom value: %<&\"+-."})");
    }

    Y_UNIT_TEST(createOAuthTokenResult) {
        T(TResultGenerator::GetCreateOAuthTokenResult(),
          R"({"oauth_token":"1.1130000000035661.1111.1515151515.1489673861057.136.7haq5WAB5FQRP-FH.AHG3GvbJBdK3R_mDC7xs290CPqkA3EIx135bG6W-bpPMgXnjccQrN9ghNSGAGGiI8YloyOsy.peNUloIa5tThhRoWhqou6Q",)"
          R"("token_id":"14896738610571130000000035661"})");
    }

    Y_UNIT_TEST(createSessionResult) {
        T(TResultGenerator::GetCreateSessionResult(),
          R"({"default_uid":"105000500",)"
          R"("new-session":{"value":"3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0","domain":"yandex.co.il","expires":100009,"http-only":true,"secure":true},)"
          R"("new-sslsession":{"value":"3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0","domain":"yandex.co.il","expires":100009,"http-only":true,"secure":true},)"
          R"("new-sessguards":{"www.dev.passport.yandex.ru":{"sessguard":{"value":"sess.guard.value","domain":".passport.yandex.ru","expires":12345}},"oauth.yandex.com":{"sessguard":{"value":"1.another.value","domain":".oauth.yandex.com","expires":54321}}},)"
          R"("authid":{"id":"1524483488711:AeZg_v8QS_4FFAAAuAYCKg:12c","time":"1524483488711","ip":"2a02:6b8:0:1405:fe4b:10ff:fe60:e601","host":"12c"},)"
          R"("login_id":"t:custom_login_id"})");
    }

    Y_UNIT_TEST(editTotpResult) {
        T(TResultGenerator::GetEditTotpResult(),
          R"({"error":"lmxkvlmvkd;lmkdfsm sdf 23lk e23 2323","secret_value":"3:1:1:ysYHxLwafIr4T7i7HTbQVQ==:KeTT2u0oRjwkA5en40xNUeklE4LKy8hS1kPTDbzYRGHvozLvnhCBEEPPrgHRfZit:CGuBJy5J2\/+jHuie+iy4b\/n4M2nKtaX3lsKsxXVmMgY=","check_time":"123123123","junk_secret_value":"ibhj23j3k 3i2h341io 190;l,.\/<>Msad"})");
    }

    Y_UNIT_TEST(lCookieResult) {
        T(TResultGenerator::GetLCookieResult(),
          R"({"uid":"646151263511236512","timestamp":"12313915","login":">>>>>qadadads","display_login":" \uD83D\uDE02 "})");
    }

    Y_UNIT_TEST(listResult) {
        T(TResultGenerator::GetListResult(),
          R"({"count":"3","total_count":"17","oijdsanoisasad ":["123123<<>>","1231tegsgdf ","904rjwrogi"]})");
    }

    Y_UNIT_TEST(loginOccupationResult) {
        T(TResultGenerator::GetLoginOccupationResult(),
          R"({"logins":{"":{"status":"malformed"},"M@lformed@":{"status":"malformed"},"OccupiedLogin":{"status":"occupied","uid":"12345"},"Public_id.login":{"status":"public_id","uid":"100500"},"Stop-word.Login":{"status":"stoplist"}}})");
    }

    Y_UNIT_TEST(loginResult) {
        T(TResultGenerator::GetLoginResult(),
          R"({"login_status":{"value":"What's up!","id":0},)"
          R"("password_status":{"value":"2What'123s zcx```up!","id":2},)"
          R"("bruteforce_policy":{"value":"password_expired"},"comment":"frkjfen ew ewfoiv 9`jwef",)"
          R"("uid":{"value":"1130000000035661","lite":false,"hosted":true,"domid":"1796513","domain":"havroshik.ru","mx":"0","domain_ena":"1","catch_all":true},)"
          R"("login":"\u0412\u0430\u0441\u044F","have_password":true,"have_hint":false,)"
          R"("aliases":{"":"","18":"\u0000","18":"\u0000","19":"public","20":["old-public"],"7":"pdd7\u0000","8":["pdd8\u0000"]},)"
          R"("karma":{"value":-18,"allow-until":789564321},"karma_status":{"value":800000000},)"
          R"("regname":"`1234567890-=~!@#$%^&*()_+\/\\*-+.0\n",)"
          R"("display_name":{"name":"\t\u000B\r\n","display_name_empty":false,"public_name":"\u041C\u0430\u0433\u0438\u0441\u0442\u0440 \u0419.",)"
          R"("has_public_profile":false,"third_party_can_use":true,"avatar":{"default":"\\\\\\\\\\\\.....\/\/\/\/000","empty":false},"verified":true,)"
          R"("social":{"profile_id":"mine ","provider":"\u0411\u0438\u043B\u0430\u0439\u043D \u0442\u0435\u043B\u0435\u043A\u043E\u043C","redirect_target":"1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba"}},)"
          R"("dbfields":{"name1":"","subscription.suid.669":""},)"
          R"("attributes":{"":"","1":"\u0004G","118":"\u001F\u0013"},)"
          R"("address-list":[{"address":"___ @ <<<<<","validated":true,"default":false,"rpop":false,"silent":false,"unsafe":false,"native":true,"born-date":"789456"}],)"
          R"("phones":[{"id":"entity_id1","attributes":{"key1":"val1","key2":"val2"}},{"id":"entity_id2","attributes":{"key3":"val3","key4":"val4"}}],)"
          R"("emails":[{"id":"entity_id3","attributes":{"key5":"val5","key6":"val6"}},{"id":"entity_id4","attributes":{"key7":"val7","key8":"val8"}}],)"
          R"("webauthn_credentials":[{"id":"entity_id5","attributes":{"11":"val11","12":"val12"}},{"id":"entity_id6","attributes":{"13":"val13","14":"val14"}}],)"
          R"("phone_operations":{"key111":"val111","key18":"val18","key20":"val20"},)"
          R"("phone_bindings":[{"type":"current","number":"79161112222","phone_id":"1796513","uid":"789564321","bound":"1522334258","flags":"1"},{"type":"history","number":"84959998877","phone_id":"12321","uid":"1130000000035661","bound":"1522133764","flags":"0"}],)"
          R"("billing_features":{"100% cashback":{"in_trial":true,"paid_trial":false,"region_id":0,"trial_duration":0,"brand":"Apple_Music"},"Music_Premium":{"region_id":9999}},)"
          R"("plus_subscriber_state":{"available_features":[{"id":111,"end":1234567890,"value":"foo"},{"id":222,"end":1234567899}],"frozen_features":[{"id":333,"value":"bar"},{"id":444}]},)"
          R"("family_info":{"family_id":"f100500","admin_uid":"789546"},)"
          R"("user_ticket":"2:3:4:fasdfd==",)"
          R"("public_id":"Y:abc.def.asdfghjik123",)"
          R"("restricted_session":true,"totp_check_time":1231231243554,"connection_id":"t:111111243",)"
          R"("badauth_counts":{"login":{"value":1,"limit":10},"password":{"value":100,"limit":20}}})");

        T(TResultGenerator::GetLoginResultDelay(),
          R"({"login_status":{"value":"What's up!","id":0},)"
          R"("password_status":{"value":"2What'123s zcx```up!","id":2},)"
          R"("bruteforce_policy":{"value":"delay","delay":180},"comment":"frkjfen ew ewfoiv 9`jwef",)"
          R"("uid":{"value":"1130000000035661","lite":false,"hosted":true,"domid":"1796513","domain":"havroshik.ru","mx":"0","domain_ena":"1","catch_all":true},)"
          R"("login":"\u0412\u0430\u0441\u044F","have_password":true,"have_hint":false,)"
          R"("aliases":{"":"","18":"\u0000","18":"\u0000","19":"public","20":["old-public"],"7":"pdd7\u0000","8":["pdd8\u0000"]},)"
          R"("karma":{"value":-18,"allow-until":789564321},"karma_status":{"value":800000000},)"
          R"("regname":"`1234567890-=~!@#$%^&*()_+\/\\*-+.0\n",)"
          R"("display_name":{"name":"\t\u000B\r\n","display_name_empty":false,"public_name":"\u041C\u0430\u0433\u0438\u0441\u0442\u0440 \u0419.",)"
          R"("has_public_profile":false,"third_party_can_use":true,"avatar":{"default":"\\\\\\\\\\\\.....\/\/\/\/000","empty":false},"verified":true,)"
          R"("social":{"profile_id":"mine ","provider":"\u0411\u0438\u043B\u0430\u0439\u043D \u0442\u0435\u043B\u0435\u043A\u043E\u043C","redirect_target":"1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba"}},)"
          R"("dbfields":{"name1":"","subscription.suid.669":""},)"
          R"("attributes":{"":"","1":"\u0004G","118":"\u001F\u0013"},)"
          R"("address-list":[{"address":"___ @ <<<<<","validated":true,"default":false,"rpop":false,"silent":false,"unsafe":false,"native":true,"born-date":"789456"}],)"
          R"("phones":[{"id":"entity_id1","attributes":{"key1":"val1","key2":"val2"}},{"id":"entity_id2","attributes":{"key3":"val3","key4":"val4"}}],)"
          R"("emails":[{"id":"entity_id3","attributes":{"key5":"val5","key6":"val6"}},{"id":"entity_id4","attributes":{"key7":"val7","key8":"val8"}}],)"
          R"("webauthn_credentials":[{"id":"entity_id5","attributes":{"11":"val11","12":"val12"}},{"id":"entity_id6","attributes":{"13":"val13","14":"val14"}}],)"
          R"("phone_operations":{"key111":"val111","key18":"val18","key20":"val20"},)"
          R"("phone_bindings":[{"type":"current","number":"79161112222","phone_id":"1796513","uid":"789564321","bound":"1522334258","flags":"1"},{"type":"history","number":"84959998877","phone_id":"12321","uid":"1130000000035661","bound":"1522133764","flags":"0"}],)"
          R"("billing_features":{"100% cashback":{"in_trial":true,"paid_trial":false,"region_id":0,"trial_duration":0,"brand":"Apple_Music"},"Music_Premium":{"region_id":9999}},)"
          R"("plus_subscriber_state":{"available_features":[{"id":111,"end":1234567890,"value":"foo"},{"id":222,"end":1234567899}],"frozen_features":[{"id":333,"value":"bar"},{"id":444}]},)"
          R"("family_info":{"family_id":"f100500","admin_uid":"789546"},)"
          R"("user_ticket":"2:3:4:fasdfd==",)"
          R"("public_id":"Y:abc.def.asdfghjik123",)"
          R"("connection_id":"t:111111243",)"
          R"("allowed_second_steps":"sms,totp","is_scholar_session":true})");
    }

    Y_UNIT_TEST(oauthResult) {
        T(TResultGenerator::GetOAuthResult(),
          R"({"oauth":{"uid":null,"token_id":"< >?","device_id":"<>?","device_name":"\u0410\u0439\uD83D\uDE02\u0444\u043E\u043D\u044C",)"
          R"("scope":"mail:imap_full mobile:all mobmail:all",)"
          R"("ctime":"fgb","issue_time":"sfsfdsgdfgdfga12312312","expire_time":null,"is_ttl_refreshable":true,)"
          R"("client_id":"   \\ s","client_name":"IKM","client_icon":"OL<","client_homepage":"https:\/\/mail.ru","client_ctime":"{|",)"
          R"("client_is_yandex":false,"xtoken_id":"15016677547314001096104","is_xtoken_trusted":true,"meta":"\\ []]",)"
          R"("token_attributes":{"1":"12345","11":"value","3":"True"},"client_attributes":{"2":"-1","6":"0","8":""}},)"
          R"("status":{"value":"DISABLED","id":4},)"
          R"("error":"\u043D\u0438\u0447\u0435\u0433\u043E \u0438\u043D\u0442\u0435\u0440\u0435\u0441\u043D\u043E\u0433\u043E",)"
          R"("login_id":"s:1524483488777:AeZg_v8QS_4FFAAAuAYCKg:1",)"
          R"("uid":{"value":"1130000000035661","lite":false,"hosted":true,"domid":"1796513","domain":"havroshik.ru","mx":"0","domain_ena":"1","catch_all":true},)"
          R"("login":"\u0412\u0430\u0441\u044F","have_password":true,"have_hint":false,)"
          R"("aliases":{"":"","18":"\u0000","18":"\u0000","19":"public","20":["old-public"],"7":"pdd7\u0000","8":["pdd8\u0000"]},)"
          R"("karma":{"value":-18,"allow-until":789564321},"karma_status":{"value":800000000},)"
          R"("regname":"`1234567890-=~!@#$%^&*()_+\/\\*-+.0\n",)"
          R"("display_name":{"name":"\t\u000B\r\n","display_name_empty":false,"public_name":"\u041C\u0430\u0433\u0438\u0441\u0442\u0440 \u0419.",)"
          R"("has_public_profile":false,"third_party_can_use":true,"avatar":{"default":"\\\\\\\\\\\\.....\/\/\/\/000","empty":false},"verified":true,)"
          R"("social":{"profile_id":"mine ","provider":"\u0411\u0438\u043B\u0430\u0439\u043D \u0442\u0435\u043B\u0435\u043A\u043E\u043C","redirect_target":"1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba"}},)"
          R"("dbfields":{"name1":"","subscription.suid.669":""},)"
          R"("attributes":{"":"","1":"\u0004G","118":"\u001F\u0013"},)"
          R"("address-list":[{"address":"___ @ <<<<<","validated":true,"default":false,"rpop":false,"silent":false,"unsafe":false,"native":true,"born-date":"789456"}],)"
          R"("phones":[{"id":"entity_id1","attributes":{"key1":"val1","key2":"val2"}},{"id":"entity_id2","attributes":{"key3":"val3","key4":"val4"}}],)"
          R"("emails":[{"id":"entity_id3","attributes":{"key5":"val5","key6":"val6"}},{"id":"entity_id4","attributes":{"key7":"val7","key8":"val8"}}],)"
          R"("webauthn_credentials":[{"id":"entity_id5","attributes":{"11":"val11","12":"val12"}},{"id":"entity_id6","attributes":{"13":"val13","14":"val14"}}],)"
          R"("phone_operations":{"key111":"val111","key18":"val18","key20":"val20"},)"
          R"("phone_bindings":[{"type":"current","number":"79161112222","phone_id":"1796513","uid":"789564321","bound":"1522334258","flags":"1"},{"type":"history","number":"84959998877","phone_id":"12321","uid":"1130000000035661","bound":"1522133764","flags":"0"}],)"
          R"("billing_features":{"100% cashback":{"in_trial":true,"paid_trial":false,"region_id":0,"trial_duration":0,"brand":"Apple_Music"},"Music_Premium":{"region_id":9999}},)"
          R"("plus_subscriber_state":{"available_features":[{"id":111,"end":1234567890,"value":"foo"},{"id":222,"end":1234567899}],"frozen_features":[{"id":333,"value":"bar"},{"id":444}]},)"
          R"("family_info":{"family_id":"f100500","admin_uid":"789546"},)"
          R"("user_ticket":"2:3:4:fasdfd==",)"
          R"("public_id":"Y:abc.def.asdfghjik123",)"
          R"("connection_id":"t:15016677547314001096104"})");
    }

    Y_UNIT_TEST(phoneBindingsResult) {
        T(TResultGenerator::GetPhoneBindingsResult(),
          R"({"phone_bindings":[{"type":"current","number":"79161112222","phone_id":"1796513","uid":"789564321","bound":"1522334258","flags":"1"},{"type":"history","number":"84959998877","phone_id":"12321","uid":"1130000000035661","bound":"1522133764","flags":"0"}]})");
    }

    Y_UNIT_TEST(proveKeyDiagResult) {
        T(TResultGenerator::GetProveKeyDiagResult(),
          R"({"totp_id":{"is_correct":false,"correct_timestamp":"13123","id":"12321"},)"
          R"("pin_secret_id":{"is_correct":true,"id":"1231"},)"
          R"("secret_id":{"is_correct":false,"id":"5498181"}})");
    }

    Y_UNIT_TEST(pwdHistoryResult) {
        T(TResultGenerator::GetPwdHistoryResult(),
          R"({"password_history_result":"found","reason":"><><><>|??L"})");
    }

    Y_UNIT_TEST(sessionResult_multi) {
        T(TResultGenerator::GetSessionResult(true),
          R"({"status":{"value":"NOAUTH","id":3},"error":"horay!!<<<>>",)"
          R"("age":127,"expires_in":1,"ttl":"5","default_uid":"18",)"
          R"("users":[{"id":"18","status":{"value":"DISABLED","id":4},"is_reg_completion_recommended":true,)"
          R"("uid":{"value":"1130000000035661","lite":false,"hosted":true,"domid":"1796513","domain":"havroshik.ru","mx":"0","domain_ena":"1","catch_all":true},)"
          R"("login":"\u0412\u0430\u0441\u044F","have_password":true,"have_hint":false,)"
          R"("aliases":{"":"","18":"\u0000","18":"\u0000","19":"public","20":["old-public"],"7":"pdd7\u0000","8":["pdd8\u0000"]},)"
          R"("karma":{"value":-18,"allow-until":789564321},"karma_status":{"value":800000000},)"
          R"("regname":"`1234567890-=~!@#$%^&*()_+\/\\*-+.0\n",)"
          R"("display_name":{"name":"\t\u000B\r\n","display_name_empty":false,"public_name":"\u041C\u0430\u0433\u0438\u0441\u0442\u0440 \u0419.",)"
          R"("has_public_profile":false,"third_party_can_use":true,"avatar":{"default":"\\\\\\\\\\\\.....\/\/\/\/000","empty":false},"verified":true,)"
          R"("social":{"profile_id":"mine ","provider":"\u0411\u0438\u043B\u0430\u0439\u043D \u0442\u0435\u043B\u0435\u043A\u043E\u043C","redirect_target":"1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba"}},)"
          R"("dbfields":{"name1":"","subscription.suid.669":""},)"
          R"("attributes":{"":"","1":"\u0004G","118":"\u001F\u0013"},)"
          R"("address-list":[{"address":"___ @ <<<<<","validated":true,"default":false,"rpop":false,"silent":false,"unsafe":false,"native":true,"born-date":"789456"}],)"
          R"("phones":[{"id":"entity_id1","attributes":{"key1":"val1","key2":"val2"}},{"id":"entity_id2","attributes":{"key3":"val3","key4":"val4"}}],)"
          R"("emails":[{"id":"entity_id3","attributes":{"key5":"val5","key6":"val6"}},{"id":"entity_id4","attributes":{"key7":"val7","key8":"val8"}}],)"
          R"("webauthn_credentials":[{"id":"entity_id5","attributes":{"11":"val11","12":"val12"}},{"id":"entity_id6","attributes":{"13":"val13","14":"val14"}}],)"
          R"("phone_operations":{"key111":"val111","key18":"val18","key20":"val20"},)"
          R"("phone_bindings":[{"type":"current","number":"79161112222","phone_id":"1796513","uid":"789564321","bound":"1522334258","flags":"1"},{"type":"history","number":"84959998877","phone_id":"12321","uid":"1130000000035661","bound":"1522133764","flags":"0"}],)"
          R"("billing_features":{"100% cashback":{"in_trial":true,"paid_trial":false,"region_id":0,"trial_duration":0,"brand":"Apple_Music"},"Music_Premium":{"region_id":9999}},)"
          R"("plus_subscriber_state":{"available_features":[{"id":111,"end":1234567890,"value":"foo"},{"id":222,"end":1234567899}],"frozen_features":[{"id":333,"value":"bar"},{"id":444}]},)"
          R"("family_info":{"family_id":"f100500","admin_uid":"789546"},)"
          R"("user_ticket":"2:3:4:fasdfd==",)"
          R"("public_id":"Y:abc.def.asdfghjik123",)"
          R"("auth":{"password_verification_age":15,"have_password":false,"secure":true,)"
          R"("partner_pdd_token":false,"social":{"profile_id":"s:google:123"},"is_scholar_session":true}},)"
          R"({"id":"12","status":{"value":"DISABLED","id":4},)"
          R"("uid":{"value":"1130000000035661","lite":false,"hosted":true,"domid":"1796513","domain":"havroshik.ru","mx":"0","domain_ena":"1","catch_all":true},)"
          R"("login":"\u0412\u0430\u0441\u044F","have_password":true,"have_hint":false,)"
          R"("aliases":{"":"","18":"\u0000","18":"\u0000","19":"public","20":["old-public"],"7":"pdd7\u0000","8":["pdd8\u0000"]},)"
          R"("karma":{"value":-18,"allow-until":789564321},"karma_status":{"value":800000000},)"
          R"("regname":"`1234567890-=~!@#$%^&*()_+\/\\*-+.0\n",)"
          R"("display_name":{"name":"\t\u000B\r\n","display_name_empty":false,"public_name":"\u041C\u0430\u0433\u0438\u0441\u0442\u0440 \u0419.",)"
          R"("has_public_profile":false,"third_party_can_use":true,"avatar":{"default":"\\\\\\\\\\\\.....\/\/\/\/000","empty":false},"verified":true,)"
          R"("social":{"profile_id":"mine ","provider":"\u0411\u0438\u043B\u0430\u0439\u043D \u0442\u0435\u043B\u0435\u043A\u043E\u043C","redirect_target":"1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba"}},)"
          R"("dbfields":{"name1":"","subscription.suid.669":""},"attributes":{"":"","1":"\u0004G","118":"\u001F\u0013"},)"
          R"("address-list":[{"address":"___ @ <<<<<","validated":true,"default":false,"rpop":false,"silent":false,"unsafe":false,"native":true,"born-date":"789456"}],)"
          R"("phones":[{"id":"entity_id1","attributes":{"key1":"val1","key2":"val2"}},{"id":"entity_id2","attributes":{"key3":"val3","key4":"val4"}}],)"
          R"("emails":[{"id":"entity_id3","attributes":{"key5":"val5","key6":"val6"}},{"id":"entity_id4","attributes":{"key7":"val7","key8":"val8"}}],)"
          R"("webauthn_credentials":[{"id":"entity_id5","attributes":{"11":"val11","12":"val12"}},{"id":"entity_id6","attributes":{"13":"val13","14":"val14"}}],)"
          R"("phone_operations":{"key111":"val111","key18":"val18","key20":"val20"},)"
          R"("phone_bindings":[{"type":"current","number":"79161112222","phone_id":"1796513","uid":"789564321","bound":"1522334258","flags":"1"},{"type":"history","number":"84959998877","phone_id":"12321","uid":"1130000000035661","bound":"1522133764","flags":"0"}],)"
          R"("billing_features":{"100% cashback":{"in_trial":true,"paid_trial":false,"region_id":0,"trial_duration":0,"brand":"Apple_Music"},"Music_Premium":{"region_id":9999}},)"
          R"("plus_subscriber_state":{"available_features":[{"id":111,"end":1234567890,"value":"foo"},{"id":222,"end":1234567899}],"frozen_features":[{"id":333,"value":"bar"},{"id":444}]},)"
          R"("family_info":{"family_id":"f100500","admin_uid":"789546"},)"
          R"("user_ticket":"2:3:4:fasdfd==",)"
          R"("public_id":"Y:abc.def.asdfghjik123",)"
          R"("auth":{"password_verification_age":15,"have_password":false,"secure":true,)"
          R"("partner_pdd_token":false,"social":{"profile_id":"s:google:123"},"is_scholar_session":true}}],)"
          R"("allow_more_users":true,)"
          R"("authid":{"id":"1524483488711:AeZg_v8QS_4FFAAAuAYCKg:12c","time":"1524483488711","ip":"2a02:6b8:0:1405:fe4b:10ff:fe60:e601","host":"12c"},)"
          R"("new-session":{"value":"3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0","domain":"yandex.co.il","expires":100009,"http-only":true,"secure":true},)"
          R"("new-sslsession":{"value":"3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0","domain":"yandex.co.il","expires":100009,"http-only":true,"secure":true},)"
          R"("resigned_cookies":{"beta.beru.ru":{"new-session":{"value":"3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0","domain":"yandex.co.il","expires":100009,"http-only":true,"secure":true},"new-sslsession":{"value":"3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0","domain":"yandex.co.il","expires":100009,"http-only":true,"secure":true}}},)"
          R"("new-sessguards":{"www.dev.passport.yandex.ru":{"sessguard":{"value":"sess.guard.value","domain":".passport.yandex.ru","expires":12345}},"oauth.yandex.com":{"sessguard":{"value":"1.another.value","domain":".oauth.yandex.com","expires":54321}}},)"
          R"("special":{"value":"STRESS","id":2},)"
          R"("connection_id":"s:1524483488711:AeZg_v8QS_4FFAAAuAYCKg:12c",)"
          R"("login_id":"t:15456677547314001096104",)"
          R"("user_ticket":"3:user:CA0Q__________9_GiMKAgh7CgMIyAMQyAMaB2JiOnNlc3MaCGJiOnNlc3MyIBIoAQ:GQy3cNgiJW"})");

        T(TResultGenerator::GetSessionResultSimple(),
          R"({"status":{"value":"NEED_RESET","id":1},"error":"horay!!<<<>>","default_uid":"-1","users":[{"id":"-1"},{"id":"0"}],"allow_more_users":true})");
    }

    Y_UNIT_TEST(sessionResult_solo) {
        T(TResultGenerator::GetSessionResult(false),
          R"({"age":127,"expires_in":1,"ttl":"5","error":"User has globally logged out",)"
          R"("status":{"value":"DISABLED","id":4},"is_reg_completion_recommended":true,)"
          R"("uid":{"value":"1130000000035661","lite":false,"hosted":true,"domid":"1796513","domain":"havroshik.ru","mx":"0","domain_ena":"1","catch_all":true},)"
          R"("login":"\u0412\u0430\u0441\u044F","have_password":true,"have_hint":false,)"
          R"("aliases":{"":"","18":"\u0000","18":"\u0000","19":"public","20":["old-public"],"7":"pdd7\u0000","8":["pdd8\u0000"]},)"
          R"("karma":{"value":-18,"allow-until":789564321},"karma_status":{"value":800000000},)"
          R"("regname":"`1234567890-=~!@#$%^&*()_+\/\\*-+.0\n",)"
          R"("display_name":{"name":"\t\u000B\r\n","display_name_empty":false,"public_name":"\u041C\u0430\u0433\u0438\u0441\u0442\u0440 \u0419.",)"
          R"("has_public_profile":false,"third_party_can_use":true,"avatar":{"default":"\\\\\\\\\\\\.....\/\/\/\/000","empty":false},"verified":true,)"
          R"("social":{"profile_id":"mine ","provider":"\u0411\u0438\u043B\u0430\u0439\u043D \u0442\u0435\u043B\u0435\u043A\u043E\u043C","redirect_target":"1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba"}},)"
          R"("dbfields":{"name1":"","subscription.suid.669":""},)"
          R"("attributes":{"":"","1":"\u0004G","118":"\u001F\u0013"},)"
          R"("address-list":[{"address":"___ @ <<<<<","validated":true,"default":false,"rpop":false,"silent":false,"unsafe":false,"native":true,"born-date":"789456"}],)"
          R"("phones":[{"id":"entity_id1","attributes":{"key1":"val1","key2":"val2"}},{"id":"entity_id2","attributes":{"key3":"val3","key4":"val4"}}],)"
          R"("emails":[{"id":"entity_id3","attributes":{"key5":"val5","key6":"val6"}},{"id":"entity_id4","attributes":{"key7":"val7","key8":"val8"}}],)"
          R"("webauthn_credentials":[{"id":"entity_id5","attributes":{"11":"val11","12":"val12"}},{"id":"entity_id6","attributes":{"13":"val13","14":"val14"}}],)"
          R"("phone_operations":{"key111":"val111","key18":"val18","key20":"val20"},)"
          R"("phone_bindings":[{"type":"current","number":"79161112222","phone_id":"1796513","uid":"789564321","bound":"1522334258","flags":"1"},{"type":"history","number":"84959998877","phone_id":"12321","uid":"1130000000035661","bound":"1522133764","flags":"0"}],)"
          R"("billing_features":{"100% cashback":{"in_trial":true,"paid_trial":false,"region_id":0,"trial_duration":0,"brand":"Apple_Music"},"Music_Premium":{"region_id":9999}},)"
          R"("plus_subscriber_state":{"available_features":[{"id":111,"end":1234567890,"value":"foo"},{"id":222,"end":1234567899}],"frozen_features":[{"id":333,"value":"bar"},{"id":444}]},)"
          R"("family_info":{"family_id":"f100500","admin_uid":"789546"},)"
          R"("user_ticket":"2:3:4:fasdfd==",)"
          R"("public_id":"Y:abc.def.asdfghjik123",)"
          R"("auth":{"password_verification_age":15,"have_password":false,"secure":true,)"
          R"("partner_pdd_token":false,"social":{"profile_id":"s:google:123"},"is_scholar_session":true},)"
          R"("authid":{"id":"1524483488711:AeZg_v8QS_4FFAAAuAYCKg:12c","time":"1524483488711","ip":"2a02:6b8:0:1405:fe4b:10ff:fe60:e601","host":"12c"},)"
          R"("new-session":{"value":"3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0","domain":"yandex.co.il","expires":100009,"http-only":true,"secure":true},)"
          R"("new-sslsession":{"value":"3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0","domain":"yandex.co.il","expires":100009,"http-only":true,"secure":true},)"
          R"("resigned_cookies":{"beta.beru.ru":{"new-session":{"value":"3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0","domain":"yandex.co.il","expires":100009,"http-only":true,"secure":true},"new-sslsession":{"value":"3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0","domain":"yandex.co.il","expires":100009,"http-only":true,"secure":true}}},)"
          R"("new-sessguards":{"www.dev.passport.yandex.ru":{"sessguard":{"value":"sess.guard.value","domain":".passport.yandex.ru","expires":12345}},"oauth.yandex.com":{"sessguard":{"value":"1.another.value","domain":".oauth.yandex.com","expires":54321}}},)"
          R"("special":{"value":"STRESS","id":2},)"
          R"("connection_id":"s:1524483488711:AeZg_v8QS_4FFAAAuAYCKg:12c",)"
          R"("login_id":"t:15456677547314001096104",)"
          R"("user_ticket":"3:user:CA0Q__________9_GiMKAgh7CgMIyAMQyAMaB2JiOnNlc3MaCGJiOnNlc3MyIBIoAQ:GQy3cNgiJW"})");
    }

    Y_UNIT_TEST(tableResult) {
        T(TResultGenerator::GetTableResult(),
          R"({"\u041C\u043E\u0439 \u043B\u044E\u0431\u0438\u043C\u044B\u0439 \u0440\u0435\u0437\u0443\u043B\u044C\u0442\u0430\u0442":)"
          R"([{"123":"\u043D\u043E\u043C\u0435\u04401",)"
          R"("\u0435\u0449\u0435 \u043E\u0434\u043D\u0430":"\u043A\u043B\u044E\u04471",)"
          R"("\u0438 \u0435\u0449\u0435":"\u0437\u043D\u0430\u0447\u0435\u043D\u0438\u04351"},)"
          R"({"123":"\u043D\u043E\u043C\u0435\u04402",)"
          R"("\u0435\u0449\u0435 \u043E\u0434\u043D\u0430":"\u043A\u043B\u044E\u04472",)"
          R"("\u0438 \u0435\u0449\u0435":"\u0437\u043D\u0430\u0447\u0435\u043D\u0438\u04352"},)"
          R"({"123":"\u043D\u043E\u043C\u0435\u04403",)"
          R"("\u0435\u0449\u0435 \u043E\u0434\u043D\u0430":"\u043A\u043B\u044E\u04473"}]})");
    }

    Y_UNIT_TEST(testPwdHashesResult) {
        T(TResultGenerator::GetTestPwdHashesResult(),
          R"({"hashes":{"\u0430\u0433\u0443":true,"\u043E\u0433\u0430":false}})");
    }

    Y_UNIT_TEST(trackResult) {
        T(TResultGenerator::GetTrackResult(),
          R"({"uid":"78953621","track_id":"12312312312adsa<<","content":{"some key":"some value"},"created":"465153138981","expired":"98794511"})");
    }

    Y_UNIT_TEST(typedValueResult) {
        T(TResultGenerator::GetTypedValueResult(TString("Stalin aşan")),
          R"({"123456789.":"Stalin a\u015Fan"})");

        T(TResultGenerator::GetTypedValueResult(i32(296546512)),
          R"({"123456789.":296546512})");

        T(TResultGenerator::GetTypedValueResult(false),
          R"({"123456789.":false})");
    }

    Y_UNIT_TEST(checkDeviceSignatureResult) {
        T(TResultGenerator::GenCheckDeviceSignatureResult(),
          R"({"status":"SOME.STATUS","error":"some MEGA 10005000 error"})");
    }

    Y_UNIT_TEST(getDevicePublicKeyResult) {
        T(TResultGenerator::GenGetDevicePublicKeyResult(),
          R"({"status":"OK.STATUS","value":"some value","version":"mega version","owner_id":"mega_master","error":"fatal \u043A\u043E\u0448\u043C\u0430\u0440"})");
    }

    Y_UNIT_TEST(checkHasPlusResult) {
        T(TResultGenerator::GenCheckHasPlusResult(false),
          R"({"has_plus":false,"uids":[]})");

        T(TResultGenerator::GenCheckHasPlusResult(true),
          R"({"has_plus":true,"uids":["100500"]})");
    }

    Y_UNIT_TEST(familyInfoResult) {
        T(TResultGenerator::GenFamilyInfoResult(true),
          R"({"status":{"value":"__some_status_value__"},)"
          R"("family":{"__some_family_id__":{"admin_uid":"__some_admin_uid__","allow_more_kids":true,"users":[)"
          R"({"uid":"42","is_kid":true},{"uid":"43","place":"17"},{"uid":"44","is_child":true},{"uid":"45"},)"
          R"({"uid":"46","info":{)"
          R"("uid":{"value":"1130000000035661","lite":false,"hosted":true,"domid":"1796513","domain":"havroshik.ru","mx":"0","domain_ena":"1","catch_all":true},)"
          R"("login":"\u0412\u0430\u0441\u044F","have_password":true,"have_hint":false,)"
          R"("aliases":{"":"","18":"\u0000","18":"\u0000","19":"public","20":["old-public"],"7":"pdd7\u0000","8":["pdd8\u0000"]},)"
          R"("karma":{"value":-18,"allow-until":789564321},"karma_status":{"value":800000000},)"
          R"("regname":"`1234567890-=~!@#$%^&*()_+\/\\*-+.0\n",)"
          R"("display_name":{"name":"\t\u000B\r\n","display_name_empty":false,"public_name":"\u041C\u0430\u0433\u0438\u0441\u0442\u0440 \u0419.",)"
          R"("has_public_profile":false,"third_party_can_use":true,"avatar":{"default":"\\\\\\\\\\\\.....\/\/\/\/000","empty":false},"verified":true,)"
          R"("social":{"profile_id":"mine ","provider":"\u0411\u0438\u043B\u0430\u0439\u043D \u0442\u0435\u043B\u0435\u043A\u043E\u043C","redirect_target":"1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba"}},)"
          R"("dbfields":{"name1":"","subscription.suid.669":""},)"
          R"("attributes":{"":"","1":"\u0004G","118":"\u001F\u0013"},)"
          R"("address-list":[{"address":"___ @ <<<<<","validated":true,"default":false,"rpop":false,"silent":false,"unsafe":false,"native":true,"born-date":"789456"}],)"
          R"("phones":[{"id":"entity_id1","attributes":{"key1":"val1","key2":"val2"}},{"id":"entity_id2","attributes":{"key3":"val3","key4":"val4"}}],)"
          R"("emails":[{"id":"entity_id3","attributes":{"key5":"val5","key6":"val6"}},{"id":"entity_id4","attributes":{"key7":"val7","key8":"val8"}}],)"
          R"("webauthn_credentials":[{"id":"entity_id5","attributes":{"11":"val11","12":"val12"}},{"id":"entity_id6","attributes":{"13":"val13","14":"val14"}}],)"
          R"("phone_operations":{"key111":"val111","key18":"val18","key20":"val20"},)"
          R"("phone_bindings":[{"type":"current","number":"79161112222","phone_id":"1796513","uid":"789564321","bound":"1522334258","flags":"1"},{"type":"history","number":"84959998877","phone_id":"12321","uid":"1130000000035661","bound":"1522133764","flags":"0"}],)"
          R"("billing_features":{"100% cashback":{"in_trial":true,"paid_trial":false,"region_id":0,"trial_duration":0,"brand":"Apple_Music"},"Music_Premium":{"region_id":9999}},)"
          R"("plus_subscriber_state":{"available_features":[{"id":111,"end":1234567890,"value":"foo"},{"id":222,"end":1234567899}],"frozen_features":[{"id":333,"value":"bar"},{"id":444}]},)"
          R"("family_info":{"family_id":"f100500","admin_uid":"789546"},)"
          R"("user_ticket":"2:3:4:fasdfd==",)"
          R"("public_id":"Y:abc.def.asdfghjik123")"
          R"(}}]}}})");

        T(TResultGenerator::GenFamilyInfoResult(false),
          R"({"status":{"value":"__some_status_value__","description":"__some_status_description__"},)"
          R"("family":{"__some_family_id__":{}}})");
    }

    Y_UNIT_TEST(findByPhoneNumbersResult) {
        T(TResultGenerator::GenFindByPhoneNumbersResult(),
          R"({"79161112233":{"uids":[]},"79992223344":{"uids":["12345","56789","1130000000035661"]}})");
    }

    Y_UNIT_TEST(userTicketResult) {
        T(TResultGenerator::GenUserTicketResult(),
          R"({"users":[{"id":"1130000000035661",)"
          R"("uid":{"value":"1130000000035661","lite":false,"hosted":true,"domid":"1796513","domain":"havroshik.ru","mx":"0","domain_ena":"1","catch_all":true},)"
          R"("login":"\u0412\u0430\u0441\u044F","have_password":true,"have_hint":false,)"
          R"("aliases":{"":"","18":"\u0000","18":"\u0000","19":"public","20":["old-public"],"7":"pdd7\u0000","8":["pdd8\u0000"]},)"
          R"("karma":{"value":-18,"allow-until":789564321},"karma_status":{"value":800000000},)"
          R"("regname":"`1234567890-=~!@#$%^&*()_+\/\\*-+.0\n",)"
          R"("display_name":{"name":"\t\u000B\r\n","display_name_empty":false,"public_name":"\u041C\u0430\u0433\u0438\u0441\u0442\u0440 \u0419.",)"
          R"("has_public_profile":false,"third_party_can_use":true,"avatar":{"default":"\\\\\\\\\\\\.....\/\/\/\/000","empty":false},"verified":true,"social":{"profile_id":"mine ","provider":"\u0411\u0438\u043B\u0430\u0439\u043D \u0442\u0435\u043B\u0435\u043A\u043E\u043C","redirect_target":"1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba"}},)"
          R"("dbfields":{"name1":"","subscription.suid.669":""},"attributes":{"":"","1":"\u0004G","118":"\u001F\u0013"},)"
          R"("address-list":[{"address":"___ @ <<<<<","validated":true,"default":false,"rpop":false,"silent":false,"unsafe":false,"native":true,"born-date":"789456"}],)"
          R"("phones":[{"id":"entity_id1","attributes":{"key1":"val1","key2":"val2"}},{"id":"entity_id2","attributes":{"key3":"val3","key4":"val4"}}],)"
          R"("emails":[{"id":"entity_id3","attributes":{"key5":"val5","key6":"val6"}},{"id":"entity_id4","attributes":{"key7":"val7","key8":"val8"}}],)"
          R"("webauthn_credentials":[{"id":"entity_id5","attributes":{"11":"val11","12":"val12"}},{"id":"entity_id6","attributes":{"13":"val13","14":"val14"}}],)"
          R"("phone_operations":{"key111":"val111","key18":"val18","key20":"val20"},"phone_bindings":[{"type":"current","number":"79161112222","phone_id":"1796513","uid":"789564321","bound":"1522334258","flags":"1"},{"type":"history","number":"84959998877","phone_id":"12321","uid":"1130000000035661","bound":"1522133764","flags":"0"}],)"
          R"("billing_features":{"100% cashback":{"in_trial":true,"paid_trial":false,"region_id":0,"trial_duration":0,"brand":"Apple_Music"},"Music_Premium":{"region_id":9999}},)"
          R"("plus_subscriber_state":{"available_features":[{"id":111,"end":1234567890,"value":"foo"},{"id":222,"end":1234567899}],"frozen_features":[{"id":333,"value":"bar"},{"id":444}]},)"
          R"("family_info":{"family_id":"f100500","admin_uid":"789546"},)"
          R"("user_ticket":"2:3:4:fasdfd==",)"
          R"("public_id":"Y:abc.def.asdfghjik123")"
          R"(}],)"
          R"("for_kid":{"error":"some big error"})"
          R"(})");
    }

    Y_UNIT_TEST(webauthnCredentialsResult) {
        T(TResultGenerator::GenWebauthnCredentialsResult(),
          R"({"credential_id_string":{"uid":"100500"}})");
    }

    Y_UNIT_TEST(checkGrants) {
        TString buf = TJsonSerializer::SerializeCheckGrants(*TResultGenerator::GenCheckGrantsResult());
        UNIT_ASSERT_VALUES_EQUAL(R"({"grants_status":"OK"})", buf);

        TExceptionInfo info;
        info.Status = TBlackboxError::EType::AccessDenied;
        info.Msg = "some error message";
        info.ExtendedDescription = "Please request grants here: https://forms.yandex-team.ru/surveys/4901 . "
                                   "If you are sure you have grants, please mail to passport-admin@yandex-team.ru";
        info.Method = "userinfo";
        info.Host = "mega.blackbox";
        info.Hostname = "some-f1.blackbox";
        info.CurrentTime = "some correct time";

        UNIT_ASSERT_VALUES_EQUAL(
            R"({"grants_status":"ACCESS_DENIED","description":"some error message. request_id=. ext=Please request grants here: https:\/\/forms.yandex-team.ru\/surveys\/4901 . If you are sure you have grants, please mail to passport-admin@yandex-team.ru. method=userinfo. host=mega.blackbox. hostname=some-f1.blackbox. current_time=some correct time","check_grants_errors":["all errors of this world","some error 1"]})",
            TJsonSerializer::SerializeCheckGrants(*TResultGenerator::GenCheckGrantsResult(), &info));
    }

    Y_UNIT_TEST(getMaxUid) {
        T(TResultGenerator::GenGetMaxUidResult(),
          R"({"max_uid":100500,"max_pdd_uid":42})");
    }

    Y_UNIT_TEST(getDebugUserTicket) {
        T(TResultGenerator::GenGetDebugUserTicketResult(),
          R"({"status":"SOMESTATUS","comment":"some comment","user_ticket":"some userticket"})");
    }

    Y_UNIT_TEST(getOAuthTokens) {
        T(TResultGenerator::GenGetOAuthTokensResult(),
          R"({"tokens":[)"
          R"({"oauth":{"uid":null,"token_id":"< >?","device_id":"<>?","device_name":"\u0410\u0439\uD83D\uDE02\u0444\u043E\u043D\u044C","scope":"mail:imap_full mobile:all mobmail:all","ctime":"fgb","issue_time":"sfsfdsgdfgdfga12312312","expire_time":null,"is_ttl_refreshable":true,"client_id":"   \\ s","client_name":"IKM","client_icon":"OL<","client_homepage":"https:\/\/mail.ru","client_ctime":"{|","client_is_yandex":false,"xtoken_id":"15016677547314001096104","is_xtoken_trusted":true,"meta":"\\ []]","token_attributes":{"1":"12345","11":"value","3":"True"},"client_attributes":{"2":"-1","6":"0","8":""}},"status":{"value":"DISABLED","id":4},"error":"\u043D\u0438\u0447\u0435\u0433\u043E \u0438\u043D\u0442\u0435\u0440\u0435\u0441\u043D\u043E\u0433\u043E","login_id":"s:1524483488777:AeZg_v8QS_4FFAAAuAYCKg:1"},)"
          R"({"oauth":{"uid":null,"token_id":"789654123","device_id":"<>?","device_name":"\u0410\u0439\uD83D\uDE02\u0444\u043E\u043D\u044C","scope":"mail:imap_full mobile:all mobmail:all","ctime":"fgb","issue_time":"sfsfdsgdfgdfga12312312","expire_time":null,"is_ttl_refreshable":true,"client_id":"   \\ s","client_name":"IKM","client_icon":"OL<","client_homepage":"https:\/\/mail.ru","client_ctime":"{|","client_is_yandex":false,"xtoken_id":"15016677547314001096104","is_xtoken_trusted":true,"meta":"\\ []]","token_attributes":{"1":"12345","11":"value","3":"True"},"client_attributes":{"2":"-1","6":"0","8":""}},"status":{"value":"DISABLED","id":4},"error":"\u043D\u0438\u0447\u0435\u0433\u043E \u0438\u043D\u0442\u0435\u0440\u0435\u0441\u043D\u043E\u0433\u043E","login_id":"s:1524483488777:AeZg_v8QS_4FFAAAuAYCKg:1"})"
          R"(]})");
    }

    Y_UNIT_TEST(decreaseSessionidLifetime) {
        T(TResultGenerator::GenDecreaseSessionidLifetimeResult(),
          R"({"status":"SOMESTATUS","comment":"some comment","new-session":"some session"})");
    }
}
