#include "generators.h"

#include <passport/infra/daemons/blackbox/ut/common/common.h>

#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/output/all_tracks_result.h>
#include <passport/infra/daemons/blackbox/src/output/base_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_device_signature_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_grants_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_has_plus_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_rfc_totp_result.h>
#include <passport/infra/daemons/blackbox/src/output/check_sign_result.h>
#include <passport/infra/daemons/blackbox/src/output/create_oauth_token_result.h>
#include <passport/infra/daemons/blackbox/src/output/create_session_result.h>
#include <passport/infra/daemons/blackbox/src/output/decrease_sessionid_lifetime_result.h>
#include <passport/infra/daemons/blackbox/src/output/edit_totp_result.h>
#include <passport/infra/daemons/blackbox/src/output/family_info_result.h>
#include <passport/infra/daemons/blackbox/src/output/find_by_phone_numbers_result.h>
#include <passport/infra/daemons/blackbox/src/output/get_debug_user_ticket_result.h>
#include <passport/infra/daemons/blackbox/src/output/get_device_public_key_result.h>
#include <passport/infra/daemons/blackbox/src/output/get_max_uid_result.h>
#include <passport/infra/daemons/blackbox/src/output/get_oauth_tokens_result.h>
#include <passport/infra/daemons/blackbox/src/output/lcookie_result.h>
#include <passport/infra/daemons/blackbox/src/output/list_result.h>
#include <passport/infra/daemons/blackbox/src/output/login_result.h>
#include <passport/infra/daemons/blackbox/src/output/loginoccupation_result.h>
#include <passport/infra/daemons/blackbox/src/output/oauth_result.h>
#include <passport/infra/daemons/blackbox/src/output/phone_bindings_result.h>
#include <passport/infra/daemons/blackbox/src/output/prove_key_diag_result.h>
#include <passport/infra/daemons/blackbox/src/output/pwdhistory_result.h>
#include <passport/infra/daemons/blackbox/src/output/session_result.h>
#include <passport/infra/daemons/blackbox/src/output/table_result.h>
#include <passport/infra/daemons/blackbox/src/output/test_pwd_hashes_result.h>
#include <passport/infra/daemons/blackbox/src/output/track_result.h>
#include <passport/infra/daemons/blackbox/src/output/typed_value_result.h>
#include <passport/infra/daemons/blackbox/src/output/user_info_result.h>
#include <passport/infra/daemons/blackbox/src/output/user_ticket_result.h>
#include <passport/infra/daemons/blackbox/src/output/webauthn_credentials_result.h>
#include <passport/infra/daemons/blackbox/src/output/xml_serializer.h>

#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NBb;

Y_UNIT_TEST_SUITE(PasspBbXml) {
    template <typename T>
    void T(T res, const TString& expected) {
        TString buf = TXmlSerializer::Serialize(*res);
        UNIT_ASSERT_VALUES_EQUAL(expected, buf);
    }

    void T(const TBlackboxError& res, const TString& expected) {
        TExceptionInfo info;
        info.Status = res.Status();
        info.Msg = res.what();
        info.ExtendedDescription = "Please request grants here: https://forms.yandex-team.ru/surveys/4901 . "
                                   "If you are sure you have grants, please mail to passport-admin@yandex-team.ru";
        info.Method = "userinfo";
        info.Host = "mega.blackbox";
        info.Hostname = "some-f1.blackbox";
        info.CurrentTime = "some correct time";

        TString buf = TXmlSerializer::SerializeException(info);
        UNIT_ASSERT_VALUES_EQUAL(expected, buf);
    }

    Y_UNIT_TEST(blackboxError) {
        T(*TResultGenerator::GenBlackboxError(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<exception id=\"21\">ACCESS_DENIED</exception>\n"
          "<error>Хочу интерфейс попроще. "
          "request_id=. "
          "ext=Please request grants here: https://forms.yandex-team.ru/surveys/4901 . If you are sure you have grants, please mail to passport-admin@yandex-team.ru. "
          "method=userinfo. "
          "host=mega.blackbox. "
          "hostname=some-f1.blackbox. "
          "current_time=some correct time"
          "</error>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(allTracksResult) {
        T(TResultGenerator::GetAllTracksResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<track>\n<uid>78953621</uid>\n<track_id>12312312312adsa&lt;&lt;</track_id>\n<created>465153138981</created>\n<expired>98794511</expired>\n<content>my json</content>\n</track>\n"
          "<track>\n<uid>78953621</uid>\n<track_id>12312312312adsa&lt;&lt;</track_id>\n<created>465153138981</created>\n<expired>98794511</expired>\n<content>my json</content>\n</track>\n"
          "<track>\n<uid>78953621</uid>\n<track_id>12312312312adsa&lt;&lt;</track_id>\n<created>465153138981</created>\n<expired>98794511</expired>\n<content>my json</content>\n</track>\n"
          "<track>\n<uid>78953621</uid>\n<track_id>12312312312adsa&lt;&lt;</track_id>\n<created>465153138981</created>\n<expired>98794511</expired>\n<content>my json</content>\n</track>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(bulkUserInfoResult) {
        T(TResultGenerator::GetEmptyBulkUserInfoResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<user id=\"5456498415686412345\"/>\n"
          "<user id=\"\"/>\n"
          "</doc>\n");

        T(TResultGenerator::GetBulkUserInfoResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<uid hosted=\"1\" domid=\"1796513\" domain=\"havroshik.ru\" mx=\"0\" domain_ena=\"1\" catch_all=\"1\">1130000000035661</uid>\n"
          "<login>Вася</login>\n"
          "<have_password>1</have_password>\n"
          "<have_hint>0</have_hint>\n"
          "<aliases>\n"
          "<alias type=\"\"></alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"19\">public</alias>\n"
          "<alias type=\"20\">old-public</alias>\n"
          "<alias type=\"7\">pdd7?</alias>\n"
          "<alias type=\"8\">pdd8?</alias>\n"
          "</aliases>\n"
          "<karma confirmed=\"0\" allow-until=\"789564321\">-18</karma>\n"
          "<karma_status>800000000</karma_status>\n"
          "<regname>`1234567890-=~!@#$%^&amp;*()_+/\\*-+.0\n</regname>\n"
          "<display_name>\n"
          "<name>\t?\r\n</name>\n"
          "<display_name_empty>0</display_name_empty>\n"
          "<public_name>Магистр Й.</public_name>\n"
          "<has_public_profile>0</has_public_profile>\n"
          "<third_party_can_use>1</third_party_can_use>\n"
          "<avatar>\n<default>\\\\\\\\\\\\.....////000</default>\n<empty>0</empty>\n</avatar>\n"
          "<verified>1</verified>\n"
          "<social>\n"
          "<profile_id>mine </profile_id>\n"
          "<redirect_target>1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba</redirect_target>\n"
          "<provider>Билайн телеком</provider>\n"
          "</social>\n"
          "</display_name>\n"
          "<dbfield id=\"name1\"></dbfield>\n"
          "<dbfield id=\"subscription.suid.669\"></dbfield>\n"
          "<attributes>\n"
          "<attribute type=\"\"></attribute>\n"
          "<attribute type=\"1\">?G</attribute>\n"
          "<attribute type=\"118\">\?\?</attribute>\n"
          "</attributes>\n"
          "<address-list>\n"
          "<address validated=\"1\" default=\"0\" rpop=\"0\" silent=\"0\" unsafe=\"0\" native=\"1\" born-date=\"789456\">___ @ &lt;&lt;&lt;&lt;&lt;</address>\n"
          "</address-list>\n"
          "<phones>\n"
          "<phone id=\"entity_id1\">\n"
          "<attribute type=\"key1\">val1</attribute>\n"
          "<attribute type=\"key2\">val2</attribute>\n"
          "</phone>\n"
          "<phone id=\"entity_id2\">\n"
          "<attribute type=\"key3\">val3</attribute>\n"
          "<attribute type=\"key4\">val4</attribute>\n"
          "</phone>\n"
          "</phones>\n"
          "<emails>\n"
          "<email id=\"entity_id3\">\n"
          "<attribute type=\"key5\">val5</attribute>\n"
          "<attribute type=\"key6\">val6</attribute>\n"
          "</email>\n"
          "<email id=\"entity_id4\">\n"
          "<attribute type=\"key7\">val7</attribute>\n"
          "<attribute type=\"key8\">val8</attribute>\n"
          "</email>\n"
          "</emails>\n"
          "<webauthn_credentials>\n"
          "<item id=\"entity_id5\">\n"
          "<attribute type=\"11\">val11</attribute>\n"
          "<attribute type=\"12\">val12</attribute>\n"
          "</item>\n"
          "<item id=\"entity_id6\">\n"
          "<attribute type=\"13\">val13</attribute>\n"
          "<attribute type=\"14\">val14</attribute>\n"
          "</item>\n"
          "</webauthn_credentials>\n"
          "<phone_operations>\n"
          "<operation id=\"key111\">val111</operation>\n"
          "<operation id=\"key18\">val18</operation>\n"
          "<operation id=\"key20\">val20</operation>\n"
          "</phone_operations>\n"
          "<phone_bindings>\n"
          "<item type=\"current\" number=\"79161112222\" phone_id=\"1796513\" uid=\"789564321\" bound=\"1522334258\" flags=\"1\"/>\n"
          "<item type=\"history\" number=\"84959998877\" phone_id=\"12321\" uid=\"1130000000035661\" bound=\"1522133764\" flags=\"0\"/>\n"
          "</phone_bindings>\n"
          "<billing_features>\n"
          "<feature name=\"100% cashback\" in_trial=\"1\" paid_trial=\"0\" region_id=\"0\" trial_duration=\"0\" brand=\"Apple_Music\"/>\n"
          "<feature name=\"Music_Premium\" region_id=\"9999\"/>\n"
          "</billing_features>\n"
          "<plus_subscriber_state>\n"
          "<available_features>\n"
          "<feature id=\"111\" end=\"1234567890\" value=\"foo\"/>\n"
          "<feature id=\"222\" end=\"1234567899\"/>\n"
          "</available_features>\n"
          "<frozen_features>\n"
          "<feature id=\"333\" value=\"bar\"/>\n"
          "<feature id=\"444\"/>\n"
          "</frozen_features>\n"
          "</plus_subscriber_state>\n"
          "<family_info>\n"
          "<family_id>f100500</family_id>\n"
          "<admin_uid>789546</admin_uid>\n"
          "</family_info>\n"
          "<user_ticket>2:3:4:fasdfd==</user_ticket>\n"
          "<public_id>Y:abc.def.asdfghjik123</public_id>\n"
          "<pin_status>0</pin_status>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(checkRfcTotpResult) {
        T(TResultGenerator::GetCheckRfcTotpResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<status>SECRET_NOT_FOUND</status>\n"
          "<time>123123123</time>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(checkSignResult) {
        T(TResultGenerator::GetCheckSignResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<status>OK</status>\n"
          "<value>Custom value: %&lt;&amp;&quot;+-.</value>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(createOAuthTokenResult) {
        T(TResultGenerator::GetCreateOAuthTokenResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<oauth_token>1.1130000000035661.1111.1515151515.1489673861057.136.7haq5WAB5FQRP-FH.AHG3GvbJBdK3R_mDC7xs290CPqkA3EIx135bG6W-bpPMgXnjccQrN9ghNSGAGGiI8YloyOsy.peNUloIa5tThhRoWhqou6Q</oauth_token>\n"
          "<token_id>14896738610571130000000035661</token_id>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(createSessionResult) {
        T(TResultGenerator::GetCreateSessionResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<default_uid>105000500</default_uid>\n"
          "<new-session domain=\"yandex.co.il\" expires=\"100009\" http-only=\"1\" secure=\"1\">3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0</new-session>\n"
          "<new-sslsession domain=\"yandex.co.il\" expires=\"100009\" http-only=\"1\" secure=\"1\">3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0</new-sslsession>\n"
          "<new-sessguards>\n"
          "<host id=\"www.dev.passport.yandex.ru\">\n"
          "<sessguard domain=\".passport.yandex.ru\" expires=\"12345\">sess.guard.value</sessguard>\n"
          "</host>\n"
          "<host id=\"oauth.yandex.com\">\n"
          "<sessguard domain=\".oauth.yandex.com\" expires=\"54321\">1.another.value</sessguard>\n"
          "</host>\n"
          "</new-sessguards>\n"
          "<authid time=\"1524483488711\" ip=\"2a02:6b8:0:1405:fe4b:10ff:fe60:e601\" host=\"12c\">1524483488711:AeZg_v8QS_4FFAAAuAYCKg:12c</authid>\n"
          "<login_id>t:custom_login_id</login_id>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(editTotpResult) {
        T(TResultGenerator::GetEditTotpResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<error>lmxkvlmvkd;lmkdfsm sdf 23lk e23 2323</error>\n"
          "<secret_value>3:1:1:ysYHxLwafIr4T7i7HTbQVQ==:KeTT2u0oRjwkA5en40xNUeklE4LKy8hS1kPTDbzYRGHvozLvnhCBEEPPrgHRfZit:CGuBJy5J2/+jHuie+iy4b/n4M2nKtaX3lsKsxXVmMgY=</secret_value>\n"
          "<check_time>123123123</check_time>\n"
          "<junk_secret_value>ibhj23j3k 3i2h341io 190;l,./&lt;&gt;Msad</junk_secret_value>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(lCookieResult) {
        T(TResultGenerator::GetLCookieResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<uid>646151263511236512</uid>\n"
          "<timestamp>12313915</timestamp>\n"
          "<login>&gt;&gt;&gt;&gt;&gt;qadadads</login>\n"
          "<display_login> 😂 </display_login>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(listResult) {
        T(TResultGenerator::GetListResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<elem_count>3</elem_count>\n"
          "<total_count>17</total_count>\n"
          "<oijdsanoisasad >\n"
          "<item KUYAGOADBAS8a8dasdsadsa=\"123123&lt;&lt;&gt;&gt;\"/>\n"
          "<item KUYAGOADBAS8a8dasdsadsa=\"1231tegsgdf \"/>\n"
          "<item KUYAGOADBAS8a8dasdsadsa=\"904rjwrogi\"/>\n"
          "</oijdsanoisasad >\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(loginOccupationResult) {
        T(TResultGenerator::GetLoginOccupationResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<login name=\"\">malformed</login>\n"
          "<login name=\"M@lformed@\">malformed</login>\n"
          "<login name=\"OccupiedLogin\" uid=\"12345\">occupied</login>\n"
          "<login name=\"Public_id.login\" uid=\"100500\">public_id</login>\n"
          "<login name=\"Stop-word.Login\">stoplist</login>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(loginResult) {
        T(TResultGenerator::GetLoginResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<login_status id=\"0\">What&apos;s up!</login_status>\n"
          "<password_status id=\"2\">2What&apos;123s zcx```up!</password_status>\n"
          "<bruteforce_policy>\n"
          "<password_expired/>\n"
          "<level>0</level>\n"
          "</bruteforce_policy>\n"
          "<comment>frkjfen ew ewfoiv 9`jwef</comment>\n"
          "<uid hosted=\"1\" domid=\"1796513\" domain=\"havroshik.ru\" mx=\"0\" domain_ena=\"1\" catch_all=\"1\">1130000000035661</uid>\n"
          "<login>Вася</login>\n"
          "<have_password>1</have_password>\n"
          "<have_hint>0</have_hint>\n"
          "<aliases>\n"
          "<alias type=\"\"></alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"19\">public</alias>\n"
          "<alias type=\"20\">old-public</alias>\n"
          "<alias type=\"7\">pdd7?</alias>\n"
          "<alias type=\"8\">pdd8?</alias>\n"
          "</aliases>\n"
          "<karma confirmed=\"0\" allow-until=\"789564321\">-18</karma>\n"
          "<karma_status>800000000</karma_status>\n"
          "<regname>`1234567890-=~!@#$%^&amp;*()_+/\\*-+.0\n</regname>\n"
          "<display_name>\n"
          "<name>\t?\r\n</name>\n"
          "<display_name_empty>0</display_name_empty>\n"
          "<public_name>Магистр Й.</public_name>\n"
          "<has_public_profile>0</has_public_profile>\n"
          "<third_party_can_use>1</third_party_can_use>\n"
          "<avatar>\n<default>\\\\\\\\\\\\.....////000</default>\n<empty>0</empty>\n</avatar>\n"
          "<verified>1</verified>\n"
          "<social>\n"
          "<profile_id>mine </profile_id>\n"
          "<redirect_target>1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba</redirect_target>\n"
          "<provider>Билайн телеком</provider>\n"
          "</social>\n"
          "</display_name>\n"
          "<dbfield id=\"name1\"></dbfield>\n"
          "<dbfield id=\"subscription.suid.669\"></dbfield>\n"
          "<attributes>\n"
          "<attribute type=\"\"></attribute>\n"
          "<attribute type=\"1\">?G</attribute>\n"
          "<attribute type=\"118\">\?\?</attribute>\n"
          "</attributes>\n"
          "<address-list>\n"
          "<address validated=\"1\" default=\"0\" rpop=\"0\" silent=\"0\" unsafe=\"0\" native=\"1\" born-date=\"789456\">___ @ &lt;&lt;&lt;&lt;&lt;</address>\n"
          "</address-list>\n"
          "<phones>\n"
          "<phone id=\"entity_id1\">\n"
          "<attribute type=\"key1\">val1</attribute>\n"
          "<attribute type=\"key2\">val2</attribute>\n"
          "</phone>\n"
          "<phone id=\"entity_id2\">\n"
          "<attribute type=\"key3\">val3</attribute>\n"
          "<attribute type=\"key4\">val4</attribute>\n"
          "</phone>\n"
          "</phones>\n"
          "<emails>\n"
          "<email id=\"entity_id3\">\n"
          "<attribute type=\"key5\">val5</attribute>\n"
          "<attribute type=\"key6\">val6</attribute>\n"
          "</email>\n"
          "<email id=\"entity_id4\">\n"
          "<attribute type=\"key7\">val7</attribute>\n"
          "<attribute type=\"key8\">val8</attribute>\n"
          "</email>\n"
          "</emails>\n"
          "<webauthn_credentials>\n"
          "<item id=\"entity_id5\">\n"
          "<attribute type=\"11\">val11</attribute>\n"
          "<attribute type=\"12\">val12</attribute>\n"
          "</item>\n"
          "<item id=\"entity_id6\">\n"
          "<attribute type=\"13\">val13</attribute>\n"
          "<attribute type=\"14\">val14</attribute>\n"
          "</item>\n"
          "</webauthn_credentials>\n"
          "<phone_operations>\n"
          "<operation id=\"key111\">val111</operation>\n"
          "<operation id=\"key18\">val18</operation>\n"
          "<operation id=\"key20\">val20</operation>\n"
          "</phone_operations>\n"
          "<phone_bindings>\n"
          "<item type=\"current\" number=\"79161112222\" phone_id=\"1796513\" uid=\"789564321\" bound=\"1522334258\" flags=\"1\"/>\n"
          "<item type=\"history\" number=\"84959998877\" phone_id=\"12321\" uid=\"1130000000035661\" bound=\"1522133764\" flags=\"0\"/>\n"
          "</phone_bindings>\n"
          "<billing_features>\n"
          "<feature name=\"100% cashback\" in_trial=\"1\" paid_trial=\"0\" region_id=\"0\" trial_duration=\"0\" brand=\"Apple_Music\"/>\n"
          "<feature name=\"Music_Premium\" region_id=\"9999\"/>\n"
          "</billing_features>\n"
          "<plus_subscriber_state>\n"
          "<available_features>\n"
          "<feature id=\"111\" end=\"1234567890\" value=\"foo\"/>\n"
          "<feature id=\"222\" end=\"1234567899\"/>\n"
          "</available_features>\n"
          "<frozen_features>\n"
          "<feature id=\"333\" value=\"bar\"/>\n"
          "<feature id=\"444\"/>\n"
          "</frozen_features>\n"
          "</plus_subscriber_state>\n"
          "<family_info>\n"
          "<family_id>f100500</family_id>\n"
          "<admin_uid>789546</admin_uid>\n"
          "</family_info>\n"
          "<user_ticket>2:3:4:fasdfd==</user_ticket>\n"
          "<public_id>Y:abc.def.asdfghjik123</public_id>\n"
          "<restricted_session>1</restricted_session>\n"
          "<totp_check_time>1231231243554</totp_check_time>\n"
          "<connection_id>t:111111243</connection_id>\n"
          "<badauth_counts>\n"
          "<item name=\"login\" value=\"1\" limit=\"10\"/>\n"
          "<item name=\"password\" value=\"100\" limit=\"20\"/>\n"
          "</badauth_counts>\n"
          "</doc>\n");

        T(TResultGenerator::GetLoginResultDelay(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<login_status id=\"0\">What&apos;s up!</login_status>\n"
          "<password_status id=\"2\">2What&apos;123s zcx```up!</password_status>\n"
          "<bruteforce_policy>\n"
          "<delay>180</delay>\n"
          "<level>0</level>\n"
          "</bruteforce_policy>\n"
          "<comment>frkjfen ew ewfoiv 9`jwef</comment>\n"
          "<uid hosted=\"1\" domid=\"1796513\" domain=\"havroshik.ru\" mx=\"0\" domain_ena=\"1\" catch_all=\"1\">1130000000035661</uid>\n"
          "<login>Вася</login>\n"
          "<have_password>1</have_password>\n"
          "<have_hint>0</have_hint>\n"
          "<aliases>\n"
          "<alias type=\"\"></alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"19\">public</alias>\n"
          "<alias type=\"20\">old-public</alias>\n"
          "<alias type=\"7\">pdd7?</alias>\n"
          "<alias type=\"8\">pdd8?</alias>\n"
          "</aliases>\n"
          "<karma confirmed=\"0\" allow-until=\"789564321\">-18</karma>\n"
          "<karma_status>800000000</karma_status>\n"
          "<regname>`1234567890-=~!@#$%^&amp;*()_+/\\*-+.0\n</regname>\n"
          "<display_name>\n"
          "<name>\t?\r\n</name>\n"
          "<display_name_empty>0</display_name_empty>\n"
          "<public_name>Магистр Й.</public_name>\n"
          "<has_public_profile>0</has_public_profile>\n"
          "<third_party_can_use>1</third_party_can_use>\n"
          "<avatar>\n<default>\\\\\\\\\\\\.....////000</default>\n<empty>0</empty>\n</avatar>\n"
          "<verified>1</verified>\n"
          "<social>\n"
          "<profile_id>mine </profile_id>\n"
          "<redirect_target>1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba</redirect_target>\n"
          "<provider>Билайн телеком</provider>\n"
          "</social>\n"
          "</display_name>\n"
          "<dbfield id=\"name1\"></dbfield>\n"
          "<dbfield id=\"subscription.suid.669\"></dbfield>\n"
          "<attributes>\n"
          "<attribute type=\"\"></attribute>\n"
          "<attribute type=\"1\">?G</attribute>\n"
          "<attribute type=\"118\">\?\?</attribute>\n"
          "</attributes>\n"
          "<address-list>\n"
          "<address validated=\"1\" default=\"0\" rpop=\"0\" silent=\"0\" unsafe=\"0\" native=\"1\" born-date=\"789456\">___ @ &lt;&lt;&lt;&lt;&lt;</address>\n"
          "</address-list>\n"
          "<phones>\n"
          "<phone id=\"entity_id1\">\n"
          "<attribute type=\"key1\">val1</attribute>\n"
          "<attribute type=\"key2\">val2</attribute>\n"
          "</phone>\n"
          "<phone id=\"entity_id2\">\n"
          "<attribute type=\"key3\">val3</attribute>\n"
          "<attribute type=\"key4\">val4</attribute>\n"
          "</phone>\n"
          "</phones>\n"
          "<emails>\n"
          "<email id=\"entity_id3\">\n"
          "<attribute type=\"key5\">val5</attribute>\n"
          "<attribute type=\"key6\">val6</attribute>\n"
          "</email>\n"
          "<email id=\"entity_id4\">\n"
          "<attribute type=\"key7\">val7</attribute>\n"
          "<attribute type=\"key8\">val8</attribute>\n"
          "</email>\n"
          "</emails>\n"
          "<webauthn_credentials>\n"
          "<item id=\"entity_id5\">\n"
          "<attribute type=\"11\">val11</attribute>\n"
          "<attribute type=\"12\">val12</attribute>\n"
          "</item>\n"
          "<item id=\"entity_id6\">\n"
          "<attribute type=\"13\">val13</attribute>\n"
          "<attribute type=\"14\">val14</attribute>\n"
          "</item>\n"
          "</webauthn_credentials>\n"
          "<phone_operations>\n"
          "<operation id=\"key111\">val111</operation>\n"
          "<operation id=\"key18\">val18</operation>\n"
          "<operation id=\"key20\">val20</operation>\n"
          "</phone_operations>\n"
          "<phone_bindings>\n"
          "<item type=\"current\" number=\"79161112222\" phone_id=\"1796513\" uid=\"789564321\" bound=\"1522334258\" flags=\"1\"/>\n"
          "<item type=\"history\" number=\"84959998877\" phone_id=\"12321\" uid=\"1130000000035661\" bound=\"1522133764\" flags=\"0\"/>\n"
          "</phone_bindings>\n"
          "<billing_features>\n"
          "<feature name=\"100% cashback\" in_trial=\"1\" paid_trial=\"0\" region_id=\"0\" trial_duration=\"0\" brand=\"Apple_Music\"/>\n"
          "<feature name=\"Music_Premium\" region_id=\"9999\"/>\n"
          "</billing_features>\n"
          "<plus_subscriber_state>\n"
          "<available_features>\n"
          "<feature id=\"111\" end=\"1234567890\" value=\"foo\"/>\n"
          "<feature id=\"222\" end=\"1234567899\"/>\n"
          "</available_features>\n"
          "<frozen_features>\n"
          "<feature id=\"333\" value=\"bar\"/>\n"
          "<feature id=\"444\"/>\n"
          "</frozen_features>\n"
          "</plus_subscriber_state>\n"
          "<family_info>\n"
          "<family_id>f100500</family_id>\n"
          "<admin_uid>789546</admin_uid>\n"
          "</family_info>\n"
          "<user_ticket>2:3:4:fasdfd==</user_ticket>\n"
          "<public_id>Y:abc.def.asdfghjik123</public_id>\n"
          "<connection_id>t:111111243</connection_id>\n"
          "<allowed_second_steps>sms,totp</allowed_second_steps>\n"
          "<is_scholar_session>1</is_scholar_session>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(oauthResult) {
        T(TResultGenerator::GetOAuthResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<OAuth>\n"
          "<uid></uid>\n"
          "<token_id>&lt; &gt;?</token_id>\n"
          "<device_id>&lt;&gt;?</device_id>\n"
          "<device_name>Ай😂фонь</device_name>\n"
          "<scope>mail:imap_full mobile:all mobmail:all</scope>\n"
          "<ctime>fgb</ctime>\n"
          "<issue_time>sfsfdsgdfgdfga12312312</issue_time>\n"
          "<expire_time>something</expire_time>\n"
          "<is_ttl_refreshable>1</is_ttl_refreshable>\n"
          "<client_id>   \\ s</client_id>\n"
          "<client_name>IKM</client_name>\n"
          "<client_icon>OL&lt;</client_icon>\n"
          "<client_homepage>https://mail.ru</client_homepage>\n"
          "<client_ctime>{|</client_ctime>\n"
          "<client_is_yandex>0</client_is_yandex>\n"
          "<xtoken_id>15016677547314001096104</xtoken_id>\n"
          "<is_xtoken_trusted>1</is_xtoken_trusted>\n"
          "<meta>\\ []]</meta>\n"
          "<token_attributes>\n"
          "<attribute type=\"1\">12345</attribute>\n"
          "<attribute type=\"11\">value</attribute>\n"
          "<attribute type=\"3\">True</attribute>\n"
          "</token_attributes>\n"
          "<client_attributes>\n"
          "<attribute type=\"2\">-1</attribute>\n"
          "<attribute type=\"6\">0</attribute>\n"
          "<attribute type=\"8\"></attribute>\n"
          "</client_attributes>\n"
          "</OAuth>\n"
          "<status id=\"4\">DISABLED</status>\n"
          "<error>ничего интересного</error>\n"
          "<login_id>s:1524483488777:AeZg_v8QS_4FFAAAuAYCKg:1</login_id>\n"
          "<uid hosted=\"1\" domid=\"1796513\" domain=\"havroshik.ru\" mx=\"0\" domain_ena=\"1\" catch_all=\"1\">1130000000035661</uid>\n"
          "<login>Вася</login>\n"
          "<have_password>1</have_password>\n"
          "<have_hint>0</have_hint>\n"
          "<aliases>\n"
          "<alias type=\"\"></alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"19\">public</alias>\n"
          "<alias type=\"20\">old-public</alias>\n"
          "<alias type=\"7\">pdd7?</alias>\n"
          "<alias type=\"8\">pdd8?</alias>\n"
          "</aliases>\n"
          "<karma confirmed=\"0\" allow-until=\"789564321\">-18</karma>\n"
          "<karma_status>800000000</karma_status>\n"
          "<regname>`1234567890-=~!@#$%^&amp;*()_+/\\*-+.0\n</regname>\n"
          "<display_name>\n"
          "<name>\t?\r\n</name>\n"
          "<display_name_empty>0</display_name_empty>\n"
          "<public_name>Магистр Й.</public_name>\n"
          "<has_public_profile>0</has_public_profile>\n"
          "<third_party_can_use>1</third_party_can_use>\n"
          "<avatar>\n<default>\\\\\\\\\\\\.....////000</default>\n<empty>0</empty>\n</avatar>\n"
          "<verified>1</verified>\n"
          "<social>\n"
          "<profile_id>mine </profile_id>\n"
          "<redirect_target>1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba</redirect_target>\n"
          "<provider>Билайн телеком</provider>\n"
          "</social>\n"
          "</display_name>\n"
          "<dbfield id=\"name1\"></dbfield>\n"
          "<dbfield id=\"subscription.suid.669\"></dbfield>\n"
          "<attributes>\n"
          "<attribute type=\"\"></attribute>\n"
          "<attribute type=\"1\">?G</attribute>\n"
          "<attribute type=\"118\">\?\?</attribute>\n"
          "</attributes>\n"
          "<address-list>\n"
          "<address validated=\"1\" default=\"0\" rpop=\"0\" silent=\"0\" unsafe=\"0\" native=\"1\" born-date=\"789456\">___ @ &lt;&lt;&lt;&lt;&lt;</address>\n"
          "</address-list>\n"
          "<phones>\n"
          "<phone id=\"entity_id1\">\n"
          "<attribute type=\"key1\">val1</attribute>\n"
          "<attribute type=\"key2\">val2</attribute>\n"
          "</phone>\n"
          "<phone id=\"entity_id2\">\n"
          "<attribute type=\"key3\">val3</attribute>\n"
          "<attribute type=\"key4\">val4</attribute>\n"
          "</phone>\n"
          "</phones>\n"
          "<emails>\n"
          "<email id=\"entity_id3\">\n"
          "<attribute type=\"key5\">val5</attribute>\n"
          "<attribute type=\"key6\">val6</attribute>\n"
          "</email>\n"
          "<email id=\"entity_id4\">\n"
          "<attribute type=\"key7\">val7</attribute>\n"
          "<attribute type=\"key8\">val8</attribute>\n"
          "</email>\n"
          "</emails>\n"
          "<webauthn_credentials>\n"
          "<item id=\"entity_id5\">\n"
          "<attribute type=\"11\">val11</attribute>\n"
          "<attribute type=\"12\">val12</attribute>\n"
          "</item>\n"
          "<item id=\"entity_id6\">\n"
          "<attribute type=\"13\">val13</attribute>\n"
          "<attribute type=\"14\">val14</attribute>\n"
          "</item>\n"
          "</webauthn_credentials>\n"
          "<phone_operations>\n"
          "<operation id=\"key111\">val111</operation>\n"
          "<operation id=\"key18\">val18</operation>\n"
          "<operation id=\"key20\">val20</operation>\n"
          "</phone_operations>\n"
          "<phone_bindings>\n"
          "<item type=\"current\" number=\"79161112222\" phone_id=\"1796513\" uid=\"789564321\" bound=\"1522334258\" flags=\"1\"/>\n"
          "<item type=\"history\" number=\"84959998877\" phone_id=\"12321\" uid=\"1130000000035661\" bound=\"1522133764\" flags=\"0\"/>\n"
          "</phone_bindings>\n"
          "<billing_features>\n"
          "<feature name=\"100% cashback\" in_trial=\"1\" paid_trial=\"0\" region_id=\"0\" trial_duration=\"0\" brand=\"Apple_Music\"/>\n"
          "<feature name=\"Music_Premium\" region_id=\"9999\"/>\n"
          "</billing_features>\n"
          "<plus_subscriber_state>\n"
          "<available_features>\n"
          "<feature id=\"111\" end=\"1234567890\" value=\"foo\"/>\n"
          "<feature id=\"222\" end=\"1234567899\"/>\n"
          "</available_features>\n"
          "<frozen_features>\n"
          "<feature id=\"333\" value=\"bar\"/>\n"
          "<feature id=\"444\"/>\n"
          "</frozen_features>\n"
          "</plus_subscriber_state>\n"
          "<family_info>\n"
          "<family_id>f100500</family_id>\n"
          "<admin_uid>789546</admin_uid>\n"
          "</family_info>\n"
          "<user_ticket>2:3:4:fasdfd==</user_ticket>\n"
          "<public_id>Y:abc.def.asdfghjik123</public_id>\n"
          "<connection_id>t:15016677547314001096104</connection_id>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(phoneBindingsResult) {
        T(TResultGenerator::GetPhoneBindingsResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<phone_bindings>\n"
          "<item type=\"current\" number=\"79161112222\" phone_id=\"1796513\" uid=\"789564321\" bound=\"1522334258\" flags=\"1\"/>\n"
          "<item type=\"history\" number=\"84959998877\" phone_id=\"12321\" uid=\"1130000000035661\" bound=\"1522133764\" flags=\"0\"/>\n"
          "</phone_bindings>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(proveKeyDiagResult) {
        T(TResultGenerator::GetProveKeyDiagResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<totp_id>\n"
          "<is_correct>0</is_correct>\n"
          "<correct_timestamp>13123</correct_timestamp>\n"
          "<id>12321</id>\n"
          "</totp_id>\n"
          "<pin_secret_id>\n"
          "<is_correct>1</is_correct>\n"
          "<id>1231</id>\n"
          "</pin_secret_id>\n"
          "<secret_id>\n"
          "<is_correct>0</is_correct>\n"
          "<id>5498181</id>\n"
          "</secret_id>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(pwdHistoryResult) {
        T(TResultGenerator::GetPwdHistoryResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<password_history_result>found</password_history_result>\n"
          "<reason>&gt;&lt;&gt;&lt;&gt;&lt;&gt;|??L</reason>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(sessionResult_multi) {
        T(TResultGenerator::GetSessionResult(true),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<status id=\"3\">NOAUTH</status>\n"
          "<error>horay!!&lt;&lt;&lt;&gt;&gt;</error>\n"
          "<age>127</age>\n"
          "<expires_in>1</expires_in>\n"
          "<ttl>5</ttl>\n"
          "<default_uid>18</default_uid>\n"
          "<user id=\"18\">\n"
          "<status id=\"4\">DISABLED</status>\n"
          "<is_reg_completion_recommended>1</is_reg_completion_recommended>\n"
          "<uid hosted=\"1\" domid=\"1796513\" domain=\"havroshik.ru\" mx=\"0\" domain_ena=\"1\" catch_all=\"1\">1130000000035661</uid>\n"
          "<login>Вася</login>\n"
          "<have_password>1</have_password>\n"
          "<have_hint>0</have_hint>\n"
          "<aliases>\n"
          "<alias type=\"\"></alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"19\">public</alias>\n"
          "<alias type=\"20\">old-public</alias>\n"
          "<alias type=\"7\">pdd7?</alias>\n"
          "<alias type=\"8\">pdd8?</alias>\n"
          "</aliases>\n"
          "<karma confirmed=\"0\" allow-until=\"789564321\">-18</karma>\n"
          "<karma_status>800000000</karma_status>\n"
          "<regname>`1234567890-=~!@#$%^&amp;*()_+/\\*-+.0\n</regname>\n"
          "<display_name>\n"
          "<name>\t?\r\n</name>\n"
          "<display_name_empty>0</display_name_empty>\n"
          "<public_name>Магистр Й.</public_name>\n"
          "<has_public_profile>0</has_public_profile>\n"
          "<third_party_can_use>1</third_party_can_use>\n"
          "<avatar>\n<default>\\\\\\\\\\\\.....////000</default>\n<empty>0</empty>\n</avatar>\n"
          "<verified>1</verified>\n"
          "<social>\n"
          "<profile_id>mine </profile_id>\n"
          "<redirect_target>1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba</redirect_target>\n"
          "<provider>Билайн телеком</provider>\n"
          "</social>\n"
          "</display_name>\n"
          "<dbfield id=\"name1\"></dbfield>\n"
          "<dbfield id=\"subscription.suid.669\"></dbfield>\n"
          "<attributes>\n"
          "<attribute type=\"\"></attribute>\n"
          "<attribute type=\"1\">?G</attribute>\n"
          "<attribute type=\"118\">\?\?</attribute>\n"
          "</attributes>\n"
          "<address-list>\n"
          "<address validated=\"1\" default=\"0\" rpop=\"0\" silent=\"0\" unsafe=\"0\" native=\"1\" born-date=\"789456\">___ @ &lt;&lt;&lt;&lt;&lt;</address>\n"
          "</address-list>\n"
          "<phones>\n"
          "<phone id=\"entity_id1\">\n"
          "<attribute type=\"key1\">val1</attribute>\n"
          "<attribute type=\"key2\">val2</attribute>\n"
          "</phone>\n"
          "<phone id=\"entity_id2\">\n"
          "<attribute type=\"key3\">val3</attribute>\n"
          "<attribute type=\"key4\">val4</attribute>\n"
          "</phone>\n"
          "</phones>\n"
          "<emails>\n"
          "<email id=\"entity_id3\">\n"
          "<attribute type=\"key5\">val5</attribute>\n"
          "<attribute type=\"key6\">val6</attribute>\n"
          "</email>\n"
          "<email id=\"entity_id4\">\n"
          "<attribute type=\"key7\">val7</attribute>\n"
          "<attribute type=\"key8\">val8</attribute>\n"
          "</email>\n"
          "</emails>\n"
          "<webauthn_credentials>\n"
          "<item id=\"entity_id5\">\n"
          "<attribute type=\"11\">val11</attribute>\n"
          "<attribute type=\"12\">val12</attribute>\n"
          "</item>\n"
          "<item id=\"entity_id6\">\n"
          "<attribute type=\"13\">val13</attribute>\n"
          "<attribute type=\"14\">val14</attribute>\n"
          "</item>\n"
          "</webauthn_credentials>\n"
          "<phone_operations>\n"
          "<operation id=\"key111\">val111</operation>\n"
          "<operation id=\"key18\">val18</operation>\n"
          "<operation id=\"key20\">val20</operation>\n"
          "</phone_operations>\n"
          "<phone_bindings>\n"
          "<item type=\"current\" number=\"79161112222\" phone_id=\"1796513\" uid=\"789564321\" bound=\"1522334258\" flags=\"1\"/>\n"
          "<item type=\"history\" number=\"84959998877\" phone_id=\"12321\" uid=\"1130000000035661\" bound=\"1522133764\" flags=\"0\"/>\n"
          "</phone_bindings>\n"
          "<billing_features>\n"
          "<feature name=\"100% cashback\" in_trial=\"1\" paid_trial=\"0\" region_id=\"0\" trial_duration=\"0\" brand=\"Apple_Music\"/>\n"
          "<feature name=\"Music_Premium\" region_id=\"9999\"/>\n"
          "</billing_features>\n"
          "<plus_subscriber_state>\n"
          "<available_features>\n"
          "<feature id=\"111\" end=\"1234567890\" value=\"foo\"/>\n"
          "<feature id=\"222\" end=\"1234567899\"/>\n"
          "</available_features>\n"
          "<frozen_features>\n"
          "<feature id=\"333\" value=\"bar\"/>\n"
          "<feature id=\"444\"/>\n"
          "</frozen_features>\n"
          "</plus_subscriber_state>\n"
          "<family_info>\n"
          "<family_id>f100500</family_id>\n"
          "<admin_uid>789546</admin_uid>\n"
          "</family_info>\n"
          "<user_ticket>2:3:4:fasdfd==</user_ticket>\n"
          "<public_id>Y:abc.def.asdfghjik123</public_id>\n"
          "<auth>\n"
          "<password_verification_age>15</password_verification_age>\n"
          "<secure>1</secure>\n"
          "<partner_pdd_token>0</partner_pdd_token>\n"
          "<social>\n"
          "<profile_id>s:google:123</profile_id>\n"
          "</social>\n"
          "<is_scholar_session>1</is_scholar_session>\n"
          "</auth>\n"
          "</user>\n"
          "<user id=\"12\">\n"
          "<status id=\"4\">DISABLED</status>\n"
          "<uid hosted=\"1\" domid=\"1796513\" domain=\"havroshik.ru\" mx=\"0\" domain_ena=\"1\" catch_all=\"1\">1130000000035661</uid>\n"
          "<login>Вася</login>\n"
          "<have_password>1</have_password>\n"
          "<have_hint>0</have_hint>\n"
          "<aliases>\n"
          "<alias type=\"\"></alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"19\">public</alias>\n"
          "<alias type=\"20\">old-public</alias>\n"
          "<alias type=\"7\">pdd7?</alias>\n"
          "<alias type=\"8\">pdd8?</alias>\n"
          "</aliases>\n"
          "<karma confirmed=\"0\" allow-until=\"789564321\">-18</karma>\n"
          "<karma_status>800000000</karma_status>\n"
          "<regname>`1234567890-=~!@#$%^&amp;*()_+/\\*-+.0\n</regname>\n"
          "<display_name>\n"
          "<name>\t?\r\n</name>\n"
          "<display_name_empty>0</display_name_empty>\n"
          "<public_name>Магистр Й.</public_name>\n"
          "<has_public_profile>0</has_public_profile>\n"
          "<third_party_can_use>1</third_party_can_use>\n"
          "<avatar>\n<default>\\\\\\\\\\\\.....////000</default>\n<empty>0</empty>\n</avatar>\n"
          "<verified>1</verified>\n"
          "<social>\n"
          "<profile_id>mine </profile_id>\n"
          "<redirect_target>1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba</redirect_target>\n"
          "<provider>Билайн телеком</provider>\n"
          "</social>\n"
          "</display_name>\n"
          "<dbfield id=\"name1\"></dbfield>\n"
          "<dbfield id=\"subscription.suid.669\"></dbfield>\n"
          "<attributes>\n"
          "<attribute type=\"\"></attribute>\n"
          "<attribute type=\"1\">?G</attribute>\n"
          "<attribute type=\"118\">\?\?</attribute>\n"
          "</attributes>\n"
          "<address-list>\n"
          "<address validated=\"1\" default=\"0\" rpop=\"0\" silent=\"0\" unsafe=\"0\" native=\"1\" born-date=\"789456\">___ @ &lt;&lt;&lt;&lt;&lt;</address>\n"
          "</address-list>\n"
          "<phones>\n"
          "<phone id=\"entity_id1\">\n"
          "<attribute type=\"key1\">val1</attribute>\n"
          "<attribute type=\"key2\">val2</attribute>\n"
          "</phone>\n"
          "<phone id=\"entity_id2\">\n"
          "<attribute type=\"key3\">val3</attribute>\n"
          "<attribute type=\"key4\">val4</attribute>\n"
          "</phone>\n"
          "</phones>\n"
          "<emails>\n"
          "<email id=\"entity_id3\">\n"
          "<attribute type=\"key5\">val5</attribute>\n"
          "<attribute type=\"key6\">val6</attribute>\n"
          "</email>\n"
          "<email id=\"entity_id4\">\n"
          "<attribute type=\"key7\">val7</attribute>\n"
          "<attribute type=\"key8\">val8</attribute>\n"
          "</email>\n"
          "</emails>\n"
          "<webauthn_credentials>\n"
          "<item id=\"entity_id5\">\n"
          "<attribute type=\"11\">val11</attribute>\n"
          "<attribute type=\"12\">val12</attribute>\n"
          "</item>\n"
          "<item id=\"entity_id6\">\n"
          "<attribute type=\"13\">val13</attribute>\n"
          "<attribute type=\"14\">val14</attribute>\n"
          "</item>\n"
          "</webauthn_credentials>\n"
          "<phone_operations>\n"
          "<operation id=\"key111\">val111</operation>\n"
          "<operation id=\"key18\">val18</operation>\n"
          "<operation id=\"key20\">val20</operation>\n"
          "</phone_operations>\n"
          "<phone_bindings>\n"
          "<item type=\"current\" number=\"79161112222\" phone_id=\"1796513\" uid=\"789564321\" bound=\"1522334258\" flags=\"1\"/>\n"
          "<item type=\"history\" number=\"84959998877\" phone_id=\"12321\" uid=\"1130000000035661\" bound=\"1522133764\" flags=\"0\"/>\n"
          "</phone_bindings>\n"
          "<billing_features>\n"
          "<feature name=\"100% cashback\" in_trial=\"1\" paid_trial=\"0\" region_id=\"0\" trial_duration=\"0\" brand=\"Apple_Music\"/>\n"
          "<feature name=\"Music_Premium\" region_id=\"9999\"/>\n"
          "</billing_features>\n"
          "<plus_subscriber_state>\n"
          "<available_features>\n"
          "<feature id=\"111\" end=\"1234567890\" value=\"foo\"/>\n"
          "<feature id=\"222\" end=\"1234567899\"/>\n"
          "</available_features>\n"
          "<frozen_features>\n"
          "<feature id=\"333\" value=\"bar\"/>\n"
          "<feature id=\"444\"/>\n"
          "</frozen_features>\n"
          "</plus_subscriber_state>\n"
          "<family_info>\n"
          "<family_id>f100500</family_id>\n"
          "<admin_uid>789546</admin_uid>\n"
          "</family_info>\n"
          "<user_ticket>2:3:4:fasdfd==</user_ticket>\n"
          "<public_id>Y:abc.def.asdfghjik123</public_id>\n"
          "<auth>\n"
          "<password_verification_age>15</password_verification_age>\n"
          "<secure>1</secure>\n"
          "<partner_pdd_token>0</partner_pdd_token>\n"
          "<social>\n"
          "<profile_id>s:google:123</profile_id>\n"
          "</social>\n"
          "<is_scholar_session>1</is_scholar_session>\n"
          "</auth>\n"
          "</user>\n"
          "<allow_more_users>1</allow_more_users>\n"
          "<authid time=\"1524483488711\" ip=\"2a02:6b8:0:1405:fe4b:10ff:fe60:e601\" host=\"12c\">1524483488711:AeZg_v8QS_4FFAAAuAYCKg:12c</authid>\n"
          "<new-session domain=\"yandex.co.il\" expires=\"100009\" http-only=\"1\" secure=\"1\">3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0</new-session>\n"
          "<new-sslsession domain=\"yandex.co.il\" expires=\"100009\" http-only=\"1\" secure=\"1\">3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0</new-sslsession>\n"
          "<resigned_cookies>\n"
          "<domain id=\"beta.beru.ru\">\n"
          R"(<new-session domain="yandex.co.il" expires="100009" http-only="1" secure="1">3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0</new-session>)"
          "\n"
          R"(<new-sslsession domain="yandex.co.il" expires="100009" http-only="1" secure="1">3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0</new-sslsession>)"
          "\n"
          "</domain>\n"
          "</resigned_cookies>\n"
          "<new-sessguards>\n"
          "<host id=\"www.dev.passport.yandex.ru\">\n"
          "<sessguard domain=\".passport.yandex.ru\" expires=\"12345\">sess.guard.value</sessguard>\n"
          "</host>\n"
          "<host id=\"oauth.yandex.com\">\n"
          "<sessguard domain=\".oauth.yandex.com\" expires=\"54321\">1.another.value</sessguard>\n"
          "</host>\n"
          "</new-sessguards>\n"
          "<special id=\"2\">STRESS</special>\n"
          "<connection_id>s:1524483488711:AeZg_v8QS_4FFAAAuAYCKg:12c</connection_id>\n"
          "<login_id>t:15456677547314001096104</login_id>\n"
          "<user_ticket>3:user:CA0Q__________9_GiMKAgh7CgMIyAMQyAMaB2JiOnNlc3MaCGJiOnNlc3MyIBIoAQ:GQy3cNgiJW</user_ticket>\n"
          "</doc>\n");

        T(TResultGenerator::GetSessionResultSimple(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<status id=\"1\">NEED_RESET</status>\n"
          "<error>horay!!&lt;&lt;&lt;&gt;&gt;</error>\n"
          "<default_uid>-1</default_uid>\n"
          "<user id=\"-1\"/>\n"
          "<user id=\"0\"/>\n"
          "<allow_more_users>1</allow_more_users>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(sessionResult_solo) {
        T(TResultGenerator::GetSessionResult(false),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<age>127</age>\n"
          "<expires_in>1</expires_in>\n"
          "<ttl>5</ttl>\n"
          "<error>User has globally logged out</error>\n"
          "<status id=\"4\">DISABLED</status>\n"
          "<is_reg_completion_recommended>1</is_reg_completion_recommended>\n"
          "<uid hosted=\"1\" domid=\"1796513\" domain=\"havroshik.ru\" mx=\"0\" domain_ena=\"1\" catch_all=\"1\">1130000000035661</uid>\n"
          "<login>Вася</login>\n"
          "<have_password>1</have_password>\n"
          "<have_hint>0</have_hint>\n"
          "<aliases>\n"
          "<alias type=\"\"></alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"19\">public</alias>\n"
          "<alias type=\"20\">old-public</alias>\n"
          "<alias type=\"7\">pdd7?</alias>\n"
          "<alias type=\"8\">pdd8?</alias>\n"
          "</aliases>\n"
          "<karma confirmed=\"0\" allow-until=\"789564321\">-18</karma>\n"
          "<karma_status>800000000</karma_status>\n"
          "<regname>`1234567890-=~!@#$%^&amp;*()_+/\\*-+.0\n</regname>\n"
          "<display_name>\n"
          "<name>\t?\r\n</name>\n"
          "<display_name_empty>0</display_name_empty>\n"
          "<public_name>Магистр Й.</public_name>\n"
          "<has_public_profile>0</has_public_profile>\n"
          "<third_party_can_use>1</third_party_can_use>\n"
          "<avatar>\n<default>\\\\\\\\\\\\.....////000</default>\n<empty>0</empty>\n</avatar>\n"
          "<verified>1</verified>\n"
          "<social>\n"
          "<profile_id>mine </profile_id>\n"
          "<redirect_target>1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba</redirect_target>\n"
          "<provider>Билайн телеком</provider>\n"
          "</social>\n"
          "</display_name>\n"
          "<dbfield id=\"name1\"></dbfield>\n"
          "<dbfield id=\"subscription.suid.669\"></dbfield>\n"
          "<attributes>\n"
          "<attribute type=\"\"></attribute>\n"
          "<attribute type=\"1\">?G</attribute>\n"
          "<attribute type=\"118\">\?\?</attribute>\n"
          "</attributes>\n"
          "<address-list>\n"
          "<address validated=\"1\" default=\"0\" rpop=\"0\" silent=\"0\" unsafe=\"0\" native=\"1\" born-date=\"789456\">___ @ &lt;&lt;&lt;&lt;&lt;</address>\n"
          "</address-list>\n"
          "<phones>\n"
          "<phone id=\"entity_id1\">\n"
          "<attribute type=\"key1\">val1</attribute>\n"
          "<attribute type=\"key2\">val2</attribute>\n"
          "</phone>\n"
          "<phone id=\"entity_id2\">\n"
          "<attribute type=\"key3\">val3</attribute>\n"
          "<attribute type=\"key4\">val4</attribute>\n"
          "</phone>\n"
          "</phones>\n"
          "<emails>\n"
          "<email id=\"entity_id3\">\n"
          "<attribute type=\"key5\">val5</attribute>\n"
          "<attribute type=\"key6\">val6</attribute>\n"
          "</email>\n"
          "<email id=\"entity_id4\">\n"
          "<attribute type=\"key7\">val7</attribute>\n"
          "<attribute type=\"key8\">val8</attribute>\n"
          "</email>\n"
          "</emails>\n"
          "<webauthn_credentials>\n"
          "<item id=\"entity_id5\">\n"
          "<attribute type=\"11\">val11</attribute>\n"
          "<attribute type=\"12\">val12</attribute>\n"
          "</item>\n"
          "<item id=\"entity_id6\">\n"
          "<attribute type=\"13\">val13</attribute>\n"
          "<attribute type=\"14\">val14</attribute>\n"
          "</item>\n"
          "</webauthn_credentials>\n"
          "<phone_operations>\n"
          "<operation id=\"key111\">val111</operation>\n"
          "<operation id=\"key18\">val18</operation>\n"
          "<operation id=\"key20\">val20</operation>\n"
          "</phone_operations>\n"
          "<phone_bindings>\n"
          "<item type=\"current\" number=\"79161112222\" phone_id=\"1796513\" uid=\"789564321\" bound=\"1522334258\" flags=\"1\"/>\n"
          "<item type=\"history\" number=\"84959998877\" phone_id=\"12321\" uid=\"1130000000035661\" bound=\"1522133764\" flags=\"0\"/>\n"
          "</phone_bindings>\n"
          "<billing_features>\n"
          "<feature name=\"100% cashback\" in_trial=\"1\" paid_trial=\"0\" region_id=\"0\" trial_duration=\"0\" brand=\"Apple_Music\"/>\n"
          "<feature name=\"Music_Premium\" region_id=\"9999\"/>\n"
          "</billing_features>\n"
          "<plus_subscriber_state>\n"
          "<available_features>\n"
          "<feature id=\"111\" end=\"1234567890\" value=\"foo\"/>\n"
          "<feature id=\"222\" end=\"1234567899\"/>\n"
          "</available_features>\n"
          "<frozen_features>\n"
          "<feature id=\"333\" value=\"bar\"/>\n"
          "<feature id=\"444\"/>\n"
          "</frozen_features>\n"
          "</plus_subscriber_state>\n"
          "<family_info>\n"
          "<family_id>f100500</family_id>\n"
          "<admin_uid>789546</admin_uid>\n"
          "</family_info>\n"
          "<user_ticket>2:3:4:fasdfd==</user_ticket>\n"
          "<public_id>Y:abc.def.asdfghjik123</public_id>\n"
          "<auth>\n"
          "<password_verification_age>15</password_verification_age>\n"
          "<secure>1</secure>\n"
          "<partner_pdd_token>0</partner_pdd_token>\n"
          "<social>\n"
          "<profile_id>s:google:123</profile_id>\n"
          "</social>\n"
          "<is_scholar_session>1</is_scholar_session>\n"
          "</auth>\n"
          "<authid time=\"1524483488711\" ip=\"2a02:6b8:0:1405:fe4b:10ff:fe60:e601\" host=\"12c\">1524483488711:AeZg_v8QS_4FFAAAuAYCKg:12c</authid>\n"
          "<new-session domain=\"yandex.co.il\" expires=\"100009\" http-only=\"1\" secure=\"1\">3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0</new-session>\n"
          "<new-sslsession domain=\"yandex.co.il\" expires=\"100009\" http-only=\"1\" secure=\"1\">3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0</new-sslsession>\n"
          "<resigned_cookies>\n"
          "<domain id=\"beta.beru.ru\">\n"
          R"(<new-session domain="yandex.co.il" expires="100009" http-only="1" secure="1">3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0</new-session>)"
          "\n"
          R"(<new-sslsession domain="yandex.co.il" expires="100009" http-only="1" secure="1">3:1522334258.5.0.1522240391566:CAgICA:7f.1.100:BZRsXw.101:1522333044.102:1522334258|70500.-1.6000.2:93867|70499.-1.0.2:14|70496.-1.2000.2:197|70502.-1.2000.2:237|70508.-1.4000.2:92653|293154.28067.Of2ChvV9hqUIuDkXQ-jlb_Q0wC0</new-sslsession>)"
          "\n"
          "</domain>\n"
          "</resigned_cookies>\n"
          "<new-sessguards>\n"
          "<host id=\"www.dev.passport.yandex.ru\">\n"
          "<sessguard domain=\".passport.yandex.ru\" expires=\"12345\">sess.guard.value</sessguard>\n"
          "</host>\n"
          "<host id=\"oauth.yandex.com\">\n"
          "<sessguard domain=\".oauth.yandex.com\" expires=\"54321\">1.another.value</sessguard>\n"
          "</host>\n"
          "</new-sessguards>\n"
          "<special id=\"2\">STRESS</special>\n"
          "<connection_id>s:1524483488711:AeZg_v8QS_4FFAAAuAYCKg:12c</connection_id>\n"
          "<login_id>t:15456677547314001096104</login_id>\n"
          "<user_ticket>3:user:CA0Q__________9_GiMKAgh7CgMIyAMQyAMaB2JiOnNlc3MaCGJiOnNlc3MyIBIoAQ:GQy3cNgiJW</user_ticket>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(tableResult) {
        T(TResultGenerator::GetTableResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<Мой любимый результат>\n"
          "<item 123=\"номер1\" еще одна=\"ключ1\" и еще=\"значение1\"/>\n"
          "<item 123=\"номер2\" еще одна=\"ключ2\" и еще=\"значение2\"/>\n"
          "<item 123=\"номер3\" еще одна=\"ключ3\"/>\n"
          "</Мой любимый результат>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(testPwdHashesResult) {
        T(TResultGenerator::GetTestPwdHashesResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<hash value=\"агу\">1</hash>\n"
          "<hash value=\"ога\">0</hash>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(trackResult) {
        T(TResultGenerator::GetTrackResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<uid>78953621</uid>\n"
          "<track_id>12312312312adsa&lt;&lt;</track_id>\n"
          "<created>465153138981</created>\n"
          "<expired>98794511</expired>\n"
          "<content>my json</content>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(typedValueResult) {
        T(TResultGenerator::GetTypedValueResult(TString("Stalin aşan")),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<123456789.>Stalin aşan</123456789.>\n"
          "</doc>\n");

        T(TResultGenerator::GetTypedValueResult(i32(296546512)),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<123456789.>296546512</123456789.>\n"
          "</doc>\n");

        T(TResultGenerator::GetTypedValueResult(false),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<123456789.>0</123456789.>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(checkDeviceSignatureResult) {
        T(TResultGenerator::GenCheckDeviceSignatureResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<status>SOME.STATUS</status>\n"
          "<error>some MEGA 10005000 error</error>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(getDevicePublicKeyResult) {
        T(TResultGenerator::GenGetDevicePublicKeyResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<status>OK.STATUS</status>\n"
          "<value>some value</value>\n"
          "<version>mega version</version>\n"
          "<owner_id>mega_master</owner_id>\n"
          "<error>fatal кошмар</error>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(checkHasPlusResult) {
        T(TResultGenerator::GenCheckHasPlusResult(false),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<has_plus>0</has_plus>\n"
          "</doc>\n");

        T(TResultGenerator::GenCheckHasPlusResult(true),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<has_plus>1</has_plus>\n"
          "<uid>100500</uid>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(familyInfoResult) {
        T(TResultGenerator::GenFamilyInfoResult(true),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<status>\n"
          "<value>__some_status_value__</value>\n"
          "</status>\n"
          "<family id=\"__some_family_id__\">\n"
          "<admin_uid>__some_admin_uid__</admin_uid>\n"
          "<allow_more_kids>1</allow_more_kids>\n"
          "<user uid=\"42\" is_kid=\"1\"/>\n"
          "<user uid=\"43\" place=\"17\"/>\n"
          "<user uid=\"44\" is_child=\"1\"/>\n"
          "<user uid=\"45\"/>\n"
          "<user uid=\"46\">\n"
          "<uid hosted=\"1\" domid=\"1796513\" domain=\"havroshik.ru\" mx=\"0\" domain_ena=\"1\" catch_all=\"1\">1130000000035661</uid>\n"
          "<login>Вася</login>\n"
          "<have_password>1</have_password>\n"
          "<have_hint>0</have_hint>\n"
          "<aliases>\n"
          "<alias type=\"\"></alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"19\">public</alias>\n"
          "<alias type=\"20\">old-public</alias>\n"
          "<alias type=\"7\">pdd7?</alias>\n"
          "<alias type=\"8\">pdd8?</alias>\n"
          "</aliases>\n"
          "<karma confirmed=\"0\" allow-until=\"789564321\">-18</karma>\n"
          "<karma_status>800000000</karma_status>\n"
          "<regname>`1234567890-=~!@#$%^&amp;*()_+/\\*-+.0\n</regname>\n"
          "<display_name>\n"
          "<name>\t?\r\n</name>\n"
          "<display_name_empty>0</display_name_empty>\n"
          "<public_name>Магистр Й.</public_name>\n"
          "<has_public_profile>0</has_public_profile>\n"
          "<third_party_can_use>1</third_party_can_use>\n"
          "<avatar>\n<default>\\\\\\\\\\\\.....////000</default>\n<empty>0</empty>\n</avatar>\n"
          "<verified>1</verified>\n"
          "<social>\n"
          "<profile_id>mine </profile_id>\n"
          "<redirect_target>1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba</redirect_target>\n"
          "<provider>Билайн телеком</provider>\n"
          "</social>\n"
          "</display_name>\n"
          "<dbfield id=\"name1\"></dbfield>\n"
          "<dbfield id=\"subscription.suid.669\"></dbfield>\n"
          "<attributes>\n"
          "<attribute type=\"\"></attribute>\n"
          "<attribute type=\"1\">?G</attribute>\n"
          "<attribute type=\"118\">\?\?</attribute>\n"
          "</attributes>\n"
          "<address-list>\n"
          "<address validated=\"1\" default=\"0\" rpop=\"0\" silent=\"0\" unsafe=\"0\" native=\"1\" born-date=\"789456\">___ @ &lt;&lt;&lt;&lt;&lt;</address>\n"
          "</address-list>\n"
          "<phones>\n"
          "<phone id=\"entity_id1\">\n"
          "<attribute type=\"key1\">val1</attribute>\n"
          "<attribute type=\"key2\">val2</attribute>\n"
          "</phone>\n"
          "<phone id=\"entity_id2\">\n"
          "<attribute type=\"key3\">val3</attribute>\n"
          "<attribute type=\"key4\">val4</attribute>\n"
          "</phone>\n"
          "</phones>\n"
          "<emails>\n"
          "<email id=\"entity_id3\">\n"
          "<attribute type=\"key5\">val5</attribute>\n"
          "<attribute type=\"key6\">val6</attribute>\n"
          "</email>\n"
          "<email id=\"entity_id4\">\n"
          "<attribute type=\"key7\">val7</attribute>\n"
          "<attribute type=\"key8\">val8</attribute>\n"
          "</email>\n"
          "</emails>\n"
          "<webauthn_credentials>\n"
          "<item id=\"entity_id5\">\n"
          "<attribute type=\"11\">val11</attribute>\n"
          "<attribute type=\"12\">val12</attribute>\n"
          "</item>\n"
          "<item id=\"entity_id6\">\n"
          "<attribute type=\"13\">val13</attribute>\n"
          "<attribute type=\"14\">val14</attribute>\n"
          "</item>\n"
          "</webauthn_credentials>\n"
          "<phone_operations>\n"
          "<operation id=\"key111\">val111</operation>\n"
          "<operation id=\"key18\">val18</operation>\n"
          "<operation id=\"key20\">val20</operation>\n"
          "</phone_operations>\n"
          "<phone_bindings>\n"
          "<item type=\"current\" number=\"79161112222\" phone_id=\"1796513\" uid=\"789564321\" bound=\"1522334258\" flags=\"1\"/>\n"
          "<item type=\"history\" number=\"84959998877\" phone_id=\"12321\" uid=\"1130000000035661\" bound=\"1522133764\" flags=\"0\"/>\n"
          "</phone_bindings>\n"
          "<billing_features>\n"
          "<feature name=\"100% cashback\" in_trial=\"1\" paid_trial=\"0\" region_id=\"0\" trial_duration=\"0\" brand=\"Apple_Music\"/>\n"
          "<feature name=\"Music_Premium\" region_id=\"9999\"/>\n"
          "</billing_features>\n"
          "<plus_subscriber_state>\n"
          "<available_features>\n"
          "<feature id=\"111\" end=\"1234567890\" value=\"foo\"/>\n"
          "<feature id=\"222\" end=\"1234567899\"/>\n"
          "</available_features>\n"
          "<frozen_features>\n"
          "<feature id=\"333\" value=\"bar\"/>\n"
          "<feature id=\"444\"/>\n"
          "</frozen_features>\n"
          "</plus_subscriber_state>\n"
          "<family_info>\n"
          "<family_id>f100500</family_id>\n"
          "<admin_uid>789546</admin_uid>\n"
          "</family_info>\n"
          "<user_ticket>2:3:4:fasdfd==</user_ticket>\n"
          "<public_id>Y:abc.def.asdfghjik123</public_id>\n"
          "</user>\n"
          "</family>\n"
          "</doc>\n");

        T(TResultGenerator::GenFamilyInfoResult(false),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<status>\n"
          "<value>__some_status_value__</value>\n"
          "<description>__some_status_description__</description>\n"
          "</status>\n"
          "<family id=\"__some_family_id__\"/>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(findByPhoneNumbersResult) {
        T(TResultGenerator::GenFindByPhoneNumbersResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<number id=\"79161112233\">\n"
          "<uids/>\n"
          "</number>\n"
          "<number id=\"79992223344\">\n"
          "<uids>\n"
          "<item id=\"12345\"/>\n"
          "<item id=\"56789\"/>\n"
          "<item id=\"1130000000035661\"/>\n"
          "</uids>\n"
          "</number>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(userTicketResult) {
        T(TResultGenerator::GenUserTicketResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<uid hosted=\"1\" domid=\"1796513\" domain=\"havroshik.ru\" mx=\"0\" domain_ena=\"1\" catch_all=\"1\">1130000000035661</uid>\n"
          "<login>Вася</login>\n"
          "<have_password>1</have_password>\n"
          "<have_hint>0</have_hint>\n"
          "<aliases>\n"
          "<alias type=\"\"></alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"18\">?</alias>\n"
          "<alias type=\"19\">public</alias>\n"
          "<alias type=\"20\">old-public</alias>\n"
          "<alias type=\"7\">pdd7?</alias>\n"
          "<alias type=\"8\">pdd8?</alias>\n"
          "</aliases>\n"
          "<karma confirmed=\"0\" allow-until=\"789564321\">-18</karma>\n"
          "<karma_status>800000000</karma_status>\n"
          "<regname>`1234567890-=~!@#$%^&amp;*()_+/\\*-+.0\n"
          "</regname>\n"
          "<display_name>\n"
          "<name>\t?\r\n"
          "</name>\n"
          "<display_name_empty>0</display_name_empty>\n"
          "<public_name>Магистр Й.</public_name>\n"
          "<has_public_profile>0</has_public_profile>\n"
          "<third_party_can_use>1</third_party_can_use>\n"
          "<avatar>\n"
          "<default>\\\\\\\\\\\\.....////000</default>\n"
          "<empty>0</empty>\n"
          "</avatar>\n"
          "<verified>1</verified>\n"
          "<social>\n"
          "<profile_id>mine </profile_id>\n"
          "<redirect_target>1524492363.51434.de.0f16db4ef6ebe33728ddbc9f318f5fba</redirect_target>\n"
          "<provider>Билайн телеком</provider>\n"
          "</social>\n"
          "</display_name>\n"
          "<dbfield id=\"name1\"></dbfield>\n"
          "<dbfield id=\"subscription.suid.669\"></dbfield>\n"
          "<attributes>\n"
          "<attribute type=\"\"></attribute>\n"
          "<attribute type=\"1\">?G</attribute>\n"
          "<attribute type=\"118\">\x3F?</attribute>\n"
          "</attributes>\n"
          "<address-list>\n"
          "<address validated=\"1\" default=\"0\" rpop=\"0\" silent=\"0\" unsafe=\"0\" native=\"1\" born-date=\"789456\">___ @ &lt;&lt;&lt;&lt;&lt;</address>\n"
          "</address-list>\n"
          "<phones>\n"
          "<phone id=\"entity_id1\">\n"
          "<attribute type=\"key1\">val1</attribute>\n"
          "<attribute type=\"key2\">val2</attribute>\n"
          "</phone>\n"
          "<phone id=\"entity_id2\">\n"
          "<attribute type=\"key3\">val3</attribute>\n"
          "<attribute type=\"key4\">val4</attribute>\n"
          "</phone>\n"
          "</phones>\n"
          "<emails>\n"
          "<email id=\"entity_id3\">\n"
          "<attribute type=\"key5\">val5</attribute>\n"
          "<attribute type=\"key6\">val6</attribute>\n"
          "</email>\n"
          "<email id=\"entity_id4\">\n"
          "<attribute type=\"key7\">val7</attribute>\n"
          "<attribute type=\"key8\">val8</attribute>\n"
          "</email>\n"
          "</emails>\n"
          "<webauthn_credentials>\n"
          "<item id=\"entity_id5\">\n"
          "<attribute type=\"11\">val11</attribute>\n"
          "<attribute type=\"12\">val12</attribute>\n"
          "</item>\n"
          "<item id=\"entity_id6\">\n"
          "<attribute type=\"13\">val13</attribute>\n"
          "<attribute type=\"14\">val14</attribute>\n"
          "</item>\n"
          "</webauthn_credentials>\n"
          "<phone_operations>\n"
          "<operation id=\"key111\">val111</operation>\n"
          "<operation id=\"key18\">val18</operation>\n"
          "<operation id=\"key20\">val20</operation>\n"
          "</phone_operations>\n"
          "<phone_bindings>\n"
          "<item type=\"current\" number=\"79161112222\" phone_id=\"1796513\" uid=\"789564321\" bound=\"1522334258\" flags=\"1\"/>\n"
          "<item type=\"history\" number=\"84959998877\" phone_id=\"12321\" uid=\"1130000000035661\" bound=\"1522133764\" flags=\"0\"/>\n"
          "</phone_bindings>\n"
          "<billing_features>\n"
          "<feature name=\"100% cashback\" in_trial=\"1\" paid_trial=\"0\" region_id=\"0\" trial_duration=\"0\" brand=\"Apple_Music\"/>\n"
          "<feature name=\"Music_Premium\" region_id=\"9999\"/>\n"
          "</billing_features>\n"
          "<plus_subscriber_state>\n"
          "<available_features>\n"
          "<feature id=\"111\" end=\"1234567890\" value=\"foo\"/>\n"
          "<feature id=\"222\" end=\"1234567899\"/>\n"
          "</available_features>\n"
          "<frozen_features>\n"
          "<feature id=\"333\" value=\"bar\"/>\n"
          "<feature id=\"444\"/>\n"
          "</frozen_features>\n"
          "</plus_subscriber_state>\n"
          "<family_info>\n"
          "<family_id>f100500</family_id>\n"
          "<admin_uid>789546</admin_uid>\n"
          "</family_info>\n"
          "<user_ticket>2:3:4:fasdfd==</user_ticket>\n"
          "<public_id>Y:abc.def.asdfghjik123</public_id>\n"
          "<for_kid>\n"
          "<error>some big error</error>\n"
          "</for_kid>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(webauthnCredentialsResult) {
        T(TResultGenerator::GenWebauthnCredentialsResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<item id=\"credential_id_string\" uid=\"100500\"/>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(checkGrants) {
        TString buf = TXmlSerializer::SerializeCheckGrants(*TResultGenerator::GenCheckGrantsResult());
        UNIT_ASSERT_VALUES_EQUAL(
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
            "<doc>\n"
            "<grants_status>OK</grants_status>\n"
            "</doc>\n",
            buf);

        TExceptionInfo info;
        info.Status = TBlackboxError::EType::AccessDenied;
        info.Msg = "some error message";
        info.ExtendedDescription = "Please request grants here: https://forms.yandex-team.ru/surveys/4901 . "
                                   "If you are sure you have grants, please mail to passport-admin@yandex-team.ru";
        info.Method = "userinfo";
        info.Host = "mega.blackbox";
        info.Hostname = "some-f1.blackbox";
        info.CurrentTime = "some correct time";

        UNIT_ASSERT_VALUES_EQUAL(
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
            "<doc>\n"
            "<grants_status>ACCESS_DENIED</grants_status>\n"
            "<description>some error message. request_id=. ext=Please request grants here: https://forms.yandex-team.ru/surveys/4901 . If you are sure you have grants, please mail to passport-admin@yandex-team.ru. method=userinfo. host=mega.blackbox. hostname=some-f1.blackbox. current_time=some correct time</description>\n"
            "<check_grants_errors>\n"
            "<error>all errors of this world</error>\n"
            "<error>some error 1</error>\n"
            "</check_grants_errors>\n"
            "</doc>\n",
            TXmlSerializer::SerializeCheckGrants(*TResultGenerator::GenCheckGrantsResult(), &info));
    }

    Y_UNIT_TEST(getMaxUid) {
        T(TResultGenerator::GenGetMaxUidResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<max_uid>100500</max_uid>\n"
          "<max_pdd_uid>42</max_pdd_uid>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(getDebugUserTicket) {
        T(TResultGenerator::GenGetDebugUserTicketResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<status>SOMESTATUS</status>\n"
          "<comment>some comment</comment>\n"
          "<user_ticket>some userticket</user_ticket>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(getOAuthTokens) {
        T(TResultGenerator::GenGetOAuthTokensResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<tokens>\n"
          "<item>\n"
          "<OAuth>\n"
          "<uid></uid>\n"
          "<token_id>&lt; &gt;?</token_id>\n"
          "<device_id>&lt;&gt;?</device_id>\n"
          "<device_name>Ай😂фонь</device_name>\n"
          "<scope>mail:imap_full mobile:all mobmail:all</scope>\n"
          "<ctime>fgb</ctime>\n"
          "<issue_time>sfsfdsgdfgdfga12312312</issue_time>\n"
          "<expire_time>something</expire_time>\n"
          "<is_ttl_refreshable>1</is_ttl_refreshable>\n"
          "<client_id>   \\ s</client_id>\n"
          "<client_name>IKM</client_name>\n"
          "<client_icon>OL&lt;</client_icon>\n"
          "<client_homepage>https://mail.ru</client_homepage>\n"
          "<client_ctime>{|</client_ctime>\n"
          "<client_is_yandex>0</client_is_yandex>\n"
          "<xtoken_id>15016677547314001096104</xtoken_id>\n"
          "<is_xtoken_trusted>1</is_xtoken_trusted>\n"
          "<meta>\\ []]</meta>\n"
          "<token_attributes>\n"
          "<attribute type=\"1\">12345</attribute>\n"
          "<attribute type=\"11\">value</attribute>\n"
          "<attribute type=\"3\">True</attribute>\n"
          "</token_attributes>\n"
          "<client_attributes>\n"
          "<attribute type=\"2\">-1</attribute>\n"
          "<attribute type=\"6\">0</attribute>\n"
          "<attribute type=\"8\"></attribute>\n"
          "</client_attributes>\n"
          "</OAuth>\n"
          "<status id=\"4\">DISABLED</status>\n"
          "<error>ничего интересного</error>\n"
          "<login_id>s:1524483488777:AeZg_v8QS_4FFAAAuAYCKg:1</login_id>\n"
          "</item>\n"
          "<item>\n"
          "<OAuth>\n"
          "<uid></uid>\n"
          "<token_id>789654123</token_id>\n"
          "<device_id>&lt;&gt;?</device_id>\n"
          "<device_name>Ай😂фонь</device_name>\n"
          "<scope>mail:imap_full mobile:all mobmail:all</scope>\n"
          "<ctime>fgb</ctime>\n"
          "<issue_time>sfsfdsgdfgdfga12312312</issue_time>\n"
          "<expire_time>something</expire_time>\n"
          "<is_ttl_refreshable>1</is_ttl_refreshable>\n"
          "<client_id>   \\ s</client_id>\n"
          "<client_name>IKM</client_name>\n"
          "<client_icon>OL&lt;</client_icon>\n"
          "<client_homepage>https://mail.ru</client_homepage>\n"
          "<client_ctime>{|</client_ctime>\n"
          "<client_is_yandex>0</client_is_yandex>\n"
          "<xtoken_id>15016677547314001096104</xtoken_id>\n"
          "<is_xtoken_trusted>1</is_xtoken_trusted>\n"
          "<meta>\\ []]</meta>\n"
          "<token_attributes>\n"
          "<attribute type=\"1\">12345</attribute>\n"
          "<attribute type=\"11\">value</attribute>\n"
          "<attribute type=\"3\">True</attribute>\n"
          "</token_attributes>\n"
          "<client_attributes>\n"
          "<attribute type=\"2\">-1</attribute>\n"
          "<attribute type=\"6\">0</attribute>\n"
          "<attribute type=\"8\"></attribute>\n"
          "</client_attributes>\n"
          "</OAuth>\n"
          "<status id=\"4\">DISABLED</status>\n"
          "<error>ничего интересного</error>\n"
          "<login_id>s:1524483488777:AeZg_v8QS_4FFAAAuAYCKg:1</login_id>\n"
          "</item>\n"
          "</tokens>\n"
          "</doc>\n");
    }

    Y_UNIT_TEST(decreaseSessionidLifetime) {
        T(TResultGenerator::GenDecreaseSessionidLifetimeResult(),
          "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
          "<doc>\n"
          "<status>SOMESTATUS</status>\n"
          "<comment>some comment</comment>\n"
          "<new-session>some session</new-session>\n"
          "</doc>\n");
    }
}
