#include <passport/infra/daemons/blackbox/src/protobuf/totp_profile.pb.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(PasspBbProto) {
    Y_UNIT_TEST(totp) {
        totp_proto::TotpProfile value;
        TString s = NPassport::NUtils::Base64url2bin("CAEQ2aoEGgQ0NDU1IhsImQkSEDAxMjM0NTY3ODlhYmNkZWYY2s2q4Qo=");
        UNIT_ASSERT(value.ParseFromArray(s.data(), s.size()));
        UNIT_ASSERT_VALUES_EQUAL(1, value.version());
        UNIT_ASSERT_VALUES_EQUAL(71001, value.uid());
        UNIT_ASSERT_VALUES_EQUAL("4455", value.pin());
        UNIT_ASSERT_VALUES_EQUAL(1, value.secrets_size());
        UNIT_ASSERT_VALUES_EQUAL(1177, value.secrets(0).id());
        UNIT_ASSERT_VALUES_EQUAL("0123456789abcdef", value.secrets(0).secret());
        UNIT_ASSERT_VALUES_EQUAL(1444238189, value.secrets(0).created());
    }
}
