#include <passport/infra/daemons/blackbox/src/totp/hotp.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NBb;
using namespace NPassport::NBb::NRfc4226;

Y_UNIT_TEST_SUITE(PasspBbTotpHotp) {
    Y_UNIT_TEST(staticHotpLength) {
        UNIT_ASSERT(!THotpFactory::ValidHotpLength(0, THotpFactory::Digits));
        UNIT_ASSERT(!THotpFactory::ValidHotpLength(5, THotpFactory::Digits));
        UNIT_ASSERT(THotpFactory::ValidHotpLength(6, THotpFactory::Digits));
        UNIT_ASSERT(THotpFactory::ValidHotpLength(12, THotpFactory::Digits));
        UNIT_ASSERT(!THotpFactory::ValidHotpLength(13, THotpFactory::Digits));

        UNIT_ASSERT(!THotpFactory::ValidHotpLength(0, THotpFactory::Letters));
        UNIT_ASSERT(!THotpFactory::ValidHotpLength(7, THotpFactory::Letters));
        UNIT_ASSERT(THotpFactory::ValidHotpLength(8, THotpFactory::Letters));
        UNIT_ASSERT(!THotpFactory::ValidHotpLength(9, THotpFactory::Letters));
    }

    Y_UNIT_TEST(hotpConstruction) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(THotpFactory(1, THotpFactory::Digits), std::invalid_argument, "unsupported length");
        UNIT_ASSERT_EXCEPTION_CONTAINS(THotpFactory(5, THotpFactory::Digits), std::invalid_argument, "unsupported length");
        UNIT_ASSERT_NO_EXCEPTION(THotpFactory(6, THotpFactory::Digits));
        UNIT_ASSERT_NO_EXCEPTION(THotpFactory(9, THotpFactory::Digits));
        UNIT_ASSERT_NO_EXCEPTION(THotpFactory(12, THotpFactory::Digits));
        UNIT_ASSERT_EXCEPTION_CONTAINS(THotpFactory(13, THotpFactory::Digits), std::invalid_argument, "unsupported length");

        UNIT_ASSERT_EXCEPTION_CONTAINS(THotpFactory(2, THotpFactory::Letters), std::invalid_argument, "unsupported length");
        UNIT_ASSERT_EXCEPTION_CONTAINS(THotpFactory(7, THotpFactory::Letters), std::invalid_argument, "unsupported length");
        UNIT_ASSERT_NO_EXCEPTION(THotpFactory(8, THotpFactory::Letters));
        UNIT_ASSERT_EXCEPTION_CONTAINS(THotpFactory(9, THotpFactory::Letters), std::invalid_argument, "unsupported length");
        UNIT_ASSERT_EXCEPTION_CONTAINS(THotpFactory(10, THotpFactory::Letters), std::invalid_argument, "unsupported length");
    }

    Y_UNIT_TEST(hotpLengthDigits) {
        THotpFactory hotp;
        UNIT_ASSERT_VALUES_EQUAL(6, hotp.GetHotpLength());

        UNIT_ASSERT_EXCEPTION_CONTAINS(hotp.SetHotpLength(0), std::invalid_argument, "unsupported length");
        UNIT_ASSERT_VALUES_EQUAL(6, hotp.GetHotpLength());
        UNIT_ASSERT_EXCEPTION_CONTAINS(hotp.SetHotpLength(5), std::invalid_argument, "unsupported length");
        UNIT_ASSERT_VALUES_EQUAL(6, hotp.GetHotpLength());

        UNIT_ASSERT_NO_EXCEPTION(hotp.SetHotpLength(6));
        UNIT_ASSERT_VALUES_EQUAL(6, hotp.GetHotpLength());
        UNIT_ASSERT_NO_EXCEPTION(hotp.SetHotpLength(10));
        UNIT_ASSERT_VALUES_EQUAL(10, hotp.GetHotpLength());
        UNIT_ASSERT_NO_EXCEPTION(hotp.SetHotpLength(12));
        UNIT_ASSERT_VALUES_EQUAL(12, hotp.GetHotpLength());

        UNIT_ASSERT_EXCEPTION_CONTAINS(hotp.SetHotpLength(13), std::invalid_argument, "unsupported length");
        UNIT_ASSERT_VALUES_EQUAL(12, hotp.GetHotpLength());
        UNIT_ASSERT_EXCEPTION_CONTAINS(hotp.SetHotpLength(100), std::invalid_argument, "unsupported length");
        UNIT_ASSERT_VALUES_EQUAL(12, hotp.GetHotpLength());
    }

    Y_UNIT_TEST(hotpLengthLetters) {
        THotpFactory hotp(THotpFactory::defaultHotpLettersLength, THotpFactory::Letters);
        UNIT_ASSERT_VALUES_EQUAL(8, hotp.GetHotpLength());

        UNIT_ASSERT_EXCEPTION_CONTAINS(hotp.SetHotpLength(0), std::invalid_argument, "unsupported length");
        UNIT_ASSERT_VALUES_EQUAL(8, hotp.GetHotpLength());
        UNIT_ASSERT_EXCEPTION_CONTAINS(hotp.SetHotpLength(7), std::invalid_argument, "unsupported length");
        UNIT_ASSERT_VALUES_EQUAL(8, hotp.GetHotpLength());

        UNIT_ASSERT_NO_EXCEPTION(hotp.SetHotpLength(8));
        UNIT_ASSERT_VALUES_EQUAL(8, hotp.GetHotpLength());

        UNIT_ASSERT_EXCEPTION_CONTAINS(hotp.SetHotpLength(9), std::invalid_argument, "unsupported length");
        UNIT_ASSERT_VALUES_EQUAL(8, hotp.GetHotpLength());
        UNIT_ASSERT_EXCEPTION_CONTAINS(hotp.SetHotpLength(100), std::invalid_argument, "unsupported length");
        UNIT_ASSERT_VALUES_EQUAL(8, hotp.GetHotpLength());
    }

    Y_UNIT_TEST(produceDigits) {
        THotpFactory hotp;
        UNIT_ASSERT_VALUES_EQUAL("459110", hotp.Produce("superKey", 0));
        UNIT_ASSERT_VALUES_EQUAL("118981", hotp.Produce("superKey", 1));

        THotpFactory hotp2(8, THotpFactory::Digits);
        UNIT_ASSERT_VALUES_EQUAL("03356306", hotp2.Produce("", 0));

        THotpFactory hotp3(12, THotpFactory::Digits);
        UNIT_ASSERT_VALUES_EQUAL("145195721201", hotp3.Produce("", 0));
    }

    Y_UNIT_TEST(produceLetters) {
        THotpFactory hotp(8, THotpFactory::Letters);
        UNIT_ASSERT_VALUES_EQUAL("vqrnfjth", hotp.Produce("", 0));
        UNIT_ASSERT_VALUES_EQUAL("wpzotibu", hotp.Produce("s3cret", 0));
        UNIT_ASSERT_VALUES_EQUAL("unshwiqy", hotp.Produce("s3cret", 1));
        UNIT_ASSERT_VALUES_EQUAL("yivmhfww", hotp.Produce("s3cret", 2));
    }

    Y_UNIT_TEST(produceTruncationError) {
        THotpFactory hotpL(8, THotpFactory::Letters, THotpFactory::Sha1);
        UNIT_ASSERT_EXCEPTION_CONTAINS(hotpL.Produce("", 0), std::logic_error, "HotpFactory::dynamicTruncationT(): hash string length is too small!");

        THotpFactory hotpD6(6, THotpFactory::Digits, THotpFactory::Sha1);
        UNIT_ASSERT_NO_EXCEPTION(hotpD6.Produce("", 0));

        THotpFactory hotpD8(8, THotpFactory::Digits, THotpFactory::Sha1);
        UNIT_ASSERT_NO_EXCEPTION(hotpD8.Produce("", 0));

        THotpFactory hotpD9(9, THotpFactory::Digits, THotpFactory::Sha1);
        UNIT_ASSERT_EXCEPTION_CONTAINS(hotpD9.Produce("", 0), std::logic_error, "HotpFactory::dynamicTruncationT(): hash string length is too small!");

        THotpFactory hotpD12(12, THotpFactory::Digits, THotpFactory::Sha1);
        UNIT_ASSERT_EXCEPTION_CONTAINS(hotpD12.Produce("", 0), std::logic_error, "HotpFactory::dynamicTruncationT(): hash string length is too small!");
    }
}
