#!/usr/bin/env python
import sys
import subprocess
import test_check_rfc_totp
import test_edit_totp
import test_login
import utils
from socket import getfqdn


def main():
    blackbox_host = getfqdn()
    subprocess.check_call(['sudo', '/etc/init.d/kolmogor', 'restart'])

    utils.clean_attrs_in_db()

    print('Starting totp test, current timestamp: ' + str(utils.get_timestamp()))

    test_check_rfc_totp.check(blackbox_host)
    test_login.check(blackbox_host)
    test_edit_totp.check(blackbox_host)

    print
    print('Everything is OK, all tests PASSED!')


if __name__ == '__main__':
    sys.exit(main())
