#!/bin/sh

ALGORITHM_VERSION="1"
AES_KEY_ID="1"
HMAC_KEY_ID="1"

SECRET_B64="hzXdsQfL4JOunx5XMv+nyg=="
UID_DEC="2864434397"
#UID_DEC="1130000000055929"
NOPAD=""
#DATA_B64="LsJTnVkkOd1R36cCY8HVHd3Mu6oAAAAAAAAAAAAAAAA="
#NOPAD="-nopad"

AES_IV_B64="c9LkGKy5bKjffhwxVfjCDQ=="
AES_KEY_B64="k3Eya4oBBz2GOvNYzvE84U8266c+KPTKmkxnUDHezPw="
HMAC_KEY_B64="4yLbPPqDpEJd9ODOLlOQ2Ye3zZlKTF9bcDKi/4wKNqc="

b64_to_hex () {
echo $1 | openssl enc -base64 -d | xxd -p -c 128
}

hex_to_b64 () {
echo $1 | xxd -r -p | openssl enc -base64
}

longdec_to_hex () {
printf '%016x' $1
}

behex_to_lehex () {
v=$1
echo ${v:14:2}${v:12:2}${v:10:2}${v:8:2}${v:6:2}${v:4:2}${v:2:2}${v:0:2}
}

hex_to_len () {
echo $1 | xxd -r -p | wc -c
}

SECRET_HEX=`b64_to_hex $SECRET_B64`
SECRET_LEN=`hex_to_len $SECRET_HEX`
UID_BE_HEX=`longdec_to_hex $UID_DEC`
UID_LE_HEX=`behex_to_lehex $UID_BE_HEX`
UID_LEN=`hex_to_len $UID_LE_HEX`

DATA_HEX="$SECRET_HEX$UID_LE_HEX"
DATA_B64=`hex_to_b64 $DATA_HEX`
#DATA_HEX=`b64_to_hex $DATA_B64`

DATA_LEN=`hex_to_len $DATA_HEX`

AES_IV_HEX=`b64_to_hex $AES_IV_B64`
AES_IV_LEN=`hex_to_len $AES_IV_HEX`
AES_KEY_HEX=`b64_to_hex $AES_KEY_B64`
AES_KEY_LEN=`hex_to_len $AES_KEY_HEX`
HMAC_KEY_HEX=`b64_to_hex $HMAC_KEY_B64`
HMAC_KEY_LEN=`hex_to_len $HMAC_KEY_HEX`

ENCRYPTED_B64=`
echo $DATA_B64 |\
openssl enc -base64 -d |\
openssl enc -aes-256-cbc -iv $AES_IV_HEX -K $AES_KEY_HEX $NOPAD -base64
`
ENCRYPTED_HEX=`b64_to_hex $ENCRYPTED_B64`
ENCRYPTED_LEN=`hex_to_len $ENCRYPTED_HEX`

DECRYPTED_B64=`
echo $ENCRYPTED_B64 |\
openssl enc -base64 -d |\
openssl enc -aes-256-cbc -iv $AES_IV_HEX -K $AES_KEY_HEX $NOPAD -d |\
openssl enc -base64
`
DECRYPTED_HEX=`b64_to_hex $DECRYPTED_B64`
DECRYPTED_LEN=`hex_to_len $DECRYPTED_HEX`

MAC_B64=`
echo $ENCRYPTED_B64 |\
openssl enc -base64 -d |\
openssl dgst -binary -sha256 -mac HMAC -macopt hexkey:$HMAC_KEY_HEX |\
openssl enc -base64
`
MAC_HEX=`b64_to_hex $MAC_B64`
MAC_LEN=`hex_to_len $MAC_HEX`

ATTRIBUTE_VALUE="$ALGORITHM_VERSION:$AES_KEY_ID:$HMAC_KEY_ID:$AES_IV_B64:$ENCRYPTED_B64:$MAC_B64"
ATTRIBUTE_LEN=`echo -n $ATTRIBUTE_VALUE | wc -c`


echo
echo "secret b64: $SECRET_B64"
echo "secret hex: $SECRET_HEX"
echo "secret len: $SECRET_LEN"
echo

echo "uid dec: $UID_DEC"
echo "uid be hex: $UID_BE_HEX"
echo "uid le hex: $UID_LE_HEX"
echo "uid len: $UID_LEN"
echo

echo "data b64: $DATA_B64"
echo "data hex: $DATA_HEX"
echo "data len: $DATA_LEN"
echo

echo "aes iv b64: $AES_IV_B64"
echo "aes iv hex: $AES_IV_HEX"
echo "aes iv len: $AES_IV_LEN"
echo

echo "aes key b64: $AES_KEY_B64"
echo "aes key hex: $AES_KEY_HEX"
echo "aes key len: $AES_KEY_LEN"
echo

echo "hmac key b64: $HMAC_KEY_B64"
echo "hmac key hex: $HMAC_KEY_HEX"
echo "hmac key len: $HMAC_KEY_LEN"
echo

echo "encrypted b64: $ENCRYPTED_B64"
echo "encrypted hex: $ENCRYPTED_HEX"
echo "encrypted len: $ENCRYPTED_LEN"
echo

echo "decrypted b64: $DECRYPTED_B64"
echo "decrypted hex: $DECRYPTED_HEX"
echo "decrypted len: $DECRYPTED_LEN"
echo

echo "mac b64: $MAC_B64"
echo "mac hex: $MAC_HEX"
echo "mac len: $MAC_LEN"
echo

if [ $DATA_B64 == $DECRYPTED_B64 ]
then
echo "data == decrypted: yes"
else
echo "data == decrypted: no"
fi
echo

echo "attribute value: $ATTRIBUTE_VALUE"
echo "attribute len: $ATTRIBUTE_LEN"
echo
