#!/bin/bash

# This script is used to generate minimized copy of geobase to use in tests
#
# Before running this script you need some utils, please do:
# >  sudo apt-get install geobase6-utils geobase6-generator
# >  curl -s https://proxy.sandbox.yandex-team.ru/757955191 | tar zxv

# To update this file with new data you can do the following:
#
# > geobase6-util --as-by-ip $IP_ADDR
# this gives you ipreg net_range and as_list values
#
# > geobase6-util --ip-traits $IP_ADDR
# this gives you region_id
#
# then
# 1. add new AS_ID to get_as_list() function below
# 2. add new json line with REGION_ID and as_id LINE NUMBER to get_traits_list() function below
# 3. check than range is correct and range_start < range_end
# 4. find a correct position for range in get_ipreg_list() function below (ranges should be ordered)
# 5. add new net_range and region LINE NUMBER to get_ipreg_list() below
# 6. do > ya upload test-geodata.bin --ttl=inf and update resource id in cpp/recipes/blackbox/recipe.inc

set -e
trap cleanup EXIT

readonly OUT_FILE='test-geodata.bin'

readonly AS_FILE='as.list'
readonly ORG_FILE='org.list'
readonly TRAITS_FILE='traits.list'
readonly IPREG_FILE='ipreg.list'

cleanup() {
    rm -f $AS_FILE $ORG_FILE $TRAITS_FILE $IPREG_FILE
}

get_as_list() {
cat <<- EOF
13238
15169
47764
EOF
}

get_org_list() {
cat <<- EOF
1	n/a
EOF
}


get_traits_list() {
cat <<- EOF
{"region_id":99999, "is_placeholder":1}
{"region_id":225, "as":1}
{"region_id":9999, "as":1}
{"region_id":87, "as":2}
{"region_id":84, "as":2}
{"region_id":213, "as":3}
{"region_id":10063, "as":2}
EOF
}


get_ipreg_list() {
cat <<- EOF |
8.8.8.0-8.8.8.255	4
94.100.176.0-94.100.191.255	6
95.108.128.0-95.108.255.255	2
2001:4860::-2001:4860:ffff:ffff:ffff:ffff:ffff:ffff	5
2a00:1148::-2a00:114f:ffff:ffff:ffff:ffff:ffff:ffff	6
2a00:1450::-2a00:1450:ffff:ffff:ffff:ffff:ffff:ffff	7
2a02:06b8::-2a02:06bf:ffff:ffff:ffff:ffff:ffff:ffff	3
EOF
./ipreg-add-stub |sed 's/\t{.*}$/\t1/' | ./ipreg-check-addr-space --completeness
}


create_data_files() {
    get_as_list     > $AS_FILE
    get_org_list    > $ORG_FILE
    get_traits_list > $TRAITS_FILE
    get_ipreg_list  > $IPREG_FILE
}


build_geodata() {
    create_data_files

    echo "'$1' generation..."
    geobase6-generator \
        --format=600 \
        --output="$1" \
        --as-section $AS_FILE \
        --isp-names-section $ORG_FILE \
        --ip-traits-section $TRAITS_FILE \
        --ipreg-section $IPREG_FILE
}

build_geodata $OUT_FILE

