#!/bin/bash

# This script dumps some data from test db to use it as standalone test database
set -o errexit

# config files (databases) to dump:
readonly central_file='central.sql'
readonly shard1_file='shard1.sql'
readonly shard2_file='shard2.sql'
readonly oauthcentral_file='oauth_central.sql'
readonly oauthshard_file='oauth_shard.sql'
readonly oauthshard2_file='oauth_shard2.sql'

# dump options
readonly mysql_creds=("-h" "cnt-dbm-test.passport.yandex.net" "-P" "3306" "-u" "$BB_PASSPORTDB_USER_RW" "-p$BB_PASSPORTDB_PASSWD_RW")
readonly dump_params=("--skip-set-charset" "--add-locks" "--set-gtid-purged=OFF" "--skip-comments" "--single-transaction" "--disable-keys" "--no-tablespaces") # "--skip-extended-insert")


# selected data to dump
readonly shard_tables=("extended_attributes" \
 "email_bindings" "phone_bindings" "phone_bindings_history" "phone_operations"\
 "account_deletion_operations" "password_history" "tracks")
readonly oauth_central_tables=("client_attributes" "client_by_owner" "client_by_params" "client_by_uid")
readonly oauth_shard_tables=("token_attributes" "token_by_access_token" "token_by_alias")

readonly test_uids="((uid >= 70470 and uid <71050) or (uid >= 1130000000000000 and uid <= 1130000000015000) \
or uid in (42,425,426,427,428,429,589,1865,67507,67580,10015,10016,2000034344,2000034625,3000358237, \
3000297554,4000959354,4000836306,4000849384,4001025071,4001096104,4001096761,4001096841,4001096987, \
4001097032,4001126940,4001166905,4001169151,4001356135,4001517393,4001595411, \
4001595721,4001597947,4001681477,4001734377,4001734381,4001784375,4003116159,4003260867,4004426553, \
4006854609,4009975154,4009975156,4009975168,4009975216,4023288754,4028670290,4034756320,4037751429, \
4053749013, 4054420843, 4054421055, \
4073439474, 4074701264, 4074701552, 4074702606, 4074702652, \
1110000000000000,1110000000000015,1110000000000016,1110000000123456,1110000000123459, \
1130000000000005,1130000000000006,1130000000020301,1130000000035661,1130000000035962,1130000000036031,1130000000036300,1130000000036796, \
1130000000052485,1130000000052943,1130000000060215,1130000000068921,1130000000111847,1130000000165441,1130000000638144))"
readonly test_domains="(domain_id < 44000) or domain_id in (56427,56431,56432,56469,56609,58772,71403,76249,94925,95119,1017677,1017679)"
readonly test_reserved_logins="login in ('bbtst_reserved')"
readonly test_phones="phone_number in ('79161111111','79162222222')"
readonly test_family_id="family_id in (1,2,3,1141,120936)"

readonly test_oauth_clients="id in (2104,2209,2210,2211,2212,2213,2249,2703,2267, 5089, 5090)"
readonly test_oauth_tokens="id in (5,256156,256160,256333,256334,256335,274675,306067,316609,316615,442587,1063887,1063889,1848885,1848887,1848889,7511052)"

readonly only_data_params=("--no-create-db" "--no-create-info" "--skip-triggers")
readonly binary_attributes="(100,101,102,180,220)"

readonly keyspaces_cond='domainsuff in (
  "yandex_by",
  "yandex_com_tr",
  "yandex_com",
  "yandex_kz",
  "yandex_ru",
  "yandex_ua",

  "beru_ru",
  "edadeal_ru",

  "cookiel",

  "signsmth",
  "signsmth_long",

  "guard_passport",
  "guard_oauth",
  "guard_test_1",
  "guard_test_2",
  "guard_test_dryrun",

  "oauth"
)'

dump_heading() {
    local db_name="$1"

    echo -e "\n-- CAUTION: This file is generated by make_dump.sh script."
    echo -e "-- Do not edit this file, or else all your changes will be discarded!\n\n"
    echo -e "CREATE DATABASE \`${db_name}\`;\nUSE \`${db_name}\`;\n\n"
}

dump_central() {
    local condition="$1"
    shift
    local tables=("$@")

    mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${condition:-true}" passportdbcentral "${tables[@]}" >> ${central_file}

    echo -e "\n\n" >> ${central_file}
}

dump_passportdbshard() {
  local db="$1"
  local filename="$2"
  dump_heading "${db}" > "${filename}"
  {
    mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_uids}" "${db}" "${shard_tables[@]}"
    mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_uids} and type not in ${binary_attributes}" "${db}" "attributes"
    mysqldump "${mysql_creds[@]}" "${dump_params[@]}" "${only_data_params[@]}" --hex-blob --where="${test_uids} and type in ${binary_attributes}" "${db}" "attributes"
    mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --hex-blob --where="${test_uids}" "${db}" "passman_recovery_keys"
  } >> "${filename}"
}

# dump central

dump_heading "passportdbcentral" > ${central_file}

# keyspaces + randoms

dump_central "$keyspaces_cond" "keyspaces"

tables=( $(mysql "${mysql_creds[@]}" -D passportdbcentral -N -e "select distinct tablename from keyspaces where $keyspaces_cond") )
dump_central "true limit 10" "${tables[@]}"

# domains, domains_events, hosts, stop_words, stop_subwords, reserved_logins, aliases, suid2
dump_central "${test_domains}" domains
dump_central "id < 2" domains_events
dump_central "true" hosts domains_hosts
dump_central "true" stop_words stop_subwords
dump_central "${test_reserved_logins}" reserved_logins
dump_central "${test_phones}" yakey_backups
dump_central "${test_uids}" aliases suid2 webauthn_credentials
dump_central "${test_family_id}" family_info family_members

# dump shards

dump_passportdbshard "passportdbshard1" ${shard1_file}

dump_passportdbshard "passportdbshard2" ${shard2_file}

#dump oauth central and shards

dump_heading "oauthdbcentral" > ${oauthcentral_file}
mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_oauth_clients}" oauthdbcentral "${oauth_central_tables[@]}" >> ${oauthcentral_file}

dump_heading "oauthdbshard1" > ${oauthshard_file}
mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_oauth_tokens}" oauthdbshard1 "${oauth_shard_tables[@]}" >> ${oauthshard_file}

dump_heading "oauthdbshard2" > ${oauthshard2_file}
mysqldump "${mysql_creds[@]}" "${dump_params[@]}" --where="${test_oauth_tokens}" oauthdbshard2 "${oauth_shard_tables[@]}" >> ${oauthshard2_file}

# add hardcoded tokens that are returned by OAuth mock
echo "
INSERT INTO \`token_attributes\` VALUES  (5730520,1,'AQAAAADue-GoAAAI22_eZKnwukAEhLSCzDr5FHk'), (5730520,2,'|50|'), (5730520,3,'4001096104'), (5730520,4,'2267'), (5730520,5,'-'), (5730520,9,'1545665885'), (5730520,10,'1545665885'), (5730520,11,'p:>\\\\u25D5\\\\u203F\\\\u25D5'), (5730522,1,'AQAAAAAAAAAAAAAI22cxq8gcZkJ1k3NNtBXhLPs'), (5730522,2,'|50|'), (5730522,3,'0'), (5730522,4,'2267'), (5730522,5,'-'), (5730522,9,'1545665885'), (5730522,10,'1545665885'), (5730522,11,'p:>\\\\u25D5\\\\u203F\\\\u25D5'), (5730524,1,'AQAAAADue-Q5AAAI2y-PfesoJ0lxsgZ0-Mgu5hY'), (5730524,2,'|50|'), (5730524,3,'4001096761'), (5730524,4,'2267'), (5730524,5,'-'), (5730524,9,'1545665885'), (5730524,10,'1545665885'), (5730526,1,'AQAAAADufFocAAAI28SCIYZQvUXmiZc9UCk8YnY'), (5730526,2,'|50|'), (5730526,3,'4001126940'), (5730526,4,'2267'), (5730526,5,'-'), (5730526,9,'1545665885'), (5730526,10,'1545665885'), (5731234,1,'AQAAAADue-GoAAAI26pbWQTsfUTwim3f9hRRARU'), (5731234,2,'|50|'), (5731234,3,'4001096104'), (5731234,4,'2267'), (5731234,5,'ca2c4cfc56ed4465861356647d76865b'), (5731234,7,'1545665925'), (5731234,9,'1545667975'), (5731234,10,'1545667975'), (5731234,11,'p: \\\\Testing\\\\\\\"/\\\\\\\\<tester>( )\\\\u25D5\\\\u203F\\\\u25D5'), (5731236,1,'AQAAAAAAAAAAAAAI2wOOz_pMVEW8p5yK_5M0CAA'), (5731236,2,'|50|'), (5731236,3,'0'), (5731236,4,'2267'), (5731236,5,'-'), (5731236,7,'1545665925'), (5731236,9,'1545667975'), (5731236,10,'1545667975'), (5731236,11,'p: \\\\One more Testing\\\\\\\"/\\\\\\\\<tester>( )\\\\u25D5\\\\u203F\\\\u25D5'), (5731238,1,'AQAAAADue-Q5AAAI20IYn6MKEk_mrX3M0uIbimc'), (5731238,2,'|50|'), (5731238,3,'4001096761'), (5731238,4,'2267'), (5731238,5,'-'), (5731238,9,'1545667975'), (5731238,10,'1545667975'), (5731238,11,'Invisible meta'), (5731240,1,'AQAAAADufFocAAAI2-FHr27jFksykagQJoP9kXQ'), (5731240,2,'|50|'), (5731240,3,'4001126940'), (5731240,4,'2267'), (5731240,5,'-'), (5731240,9,'1545667975'), (5731240,10,'1545667975'), (5731240,11,'another invisible meta'), (5731242,1,'y2_AQAAAADue-GoAAAI2wAAAAAAV3OqeHh4eHh4eHh4eHh4eHh4eIzqTNg'), (5731242,2,'|50|'), (5731242,3,'4001096104'), (5731242,4,'2267'), (5731242,5,'ca2c4cfc56ed4465861356647d76865b'), (5731242,7,'1545665925'), (5731242,9,'1545667975'), (5731242,10,'1545667975'), (5731242,11,'p: \\\\Testing\\\\\\\"/\\\\\\\\<tester>( )\\\\u25D5\\\\u203F\\\\u25D5');


INSERT INTO \`token_by_access_token\` VALUES  ('1:BmBkm1/JmbKJJ9zRwugXTlEFnsQYPxeOH5YCZ2UKskg',5730522), ('1:2GSaFWYaSKx5+0+XYMZQ2KWwr2DCKs9Z0J3a07Cg+qw',5730520), ('1:FLIJVhEafXC41fvCQ+j6zaIwhmI3gc02O3GgjUHjlUw',5730524), ('1:w4ilK20jEs3a+19yEhkPWnnnYvSERYLwjOHqQ8VJFIs',5730526), ('1:BCFmqRWir2x17o2ow19NmfvTnUkDynVfDuaajHvJC9E',5731234), ('1:0lHWfWx9+PZZtPKXaNfBL2EAt4V+5UZmObu/pJlcd8g',5731236), ('1:cDu7cu/74tuJTxkE3XOIr86tJDWQh/hbXLexMRBXngI',5731238), ('1:kNbKcfPuLbeluejCx0s0pOscD6m0yuhZ0W7CtMM+zLU',5731240), ('1:FbkBgCLSfwE3RDB5wn6bd7NfZ0fzI/dD1Z8yVIJvmG8',5731242);" >>${oauthshard_file}

echo "
INSERT INTO \`token_attributes\` VALUES  (58628812,1,'AgAAAADue-GoAAAI2zgCL5J2D0knvL5EuXxsIQk'), (58628812,2,'|50|'), (58628812,3,'4001096104'), (58628812,4,'2267'), (58628812,5,'-'), (58628812,7,'1577196958'), (58628812,9,'1577196918'), (58628812,10,'1577196918'), (58628812,11,'Important login_id meta'), (58628812,17,'some custom login_id'), (26148446,1,'AgAAAAAAARVjAAAI2wuY0WdQ7kextjurYHpVm9A'), (26148446,2,'|50|'), (26148446,3,'71011'), (26148446,4,'2267'), (26148446,5,'-'), (26148446,7,'1622037805'), (26148446,9,'1622037765'), (26148446,10,'1622037765'), (31762219,1,'AgAAAAAAARVlAAAI28e1puDYwUa4pl3hgv9dCXU'), (31762219,2,'|50|'), (31762219,3,'71013'), (31762219,4,'2267'), (31762219,5,'-'), (31762219,7,'1636557961'), (31762219,9,'1636557921'), (31762219,10,'1636557921');

INSERT INTO \`token_by_access_token\` VALUES  ('1:7rrzSUKjVrBVh/pucmKxLbbbEQi42fFFnuN1s50zvHM',58628812), ('1:dTkZ1KjjqqO8pGtsd5zJvlrxTEwu2e/5gViR3jJPWIM',26148446), ('1:WO3gljOLQ7n5VU+SD2VbcskJz5Bh6LA55k6l2ZF9jp8',31762219);" >>${oauthshard2_file}

# use sed to make dumps humah-readable
for dump in "${central_file}" "${shard1_file}" "${shard2_file}" "${oauthcentral_file}" "${oauthshard_file}" "${oauthshard2_file}"; do
    sed -i 's/\(VALUES \|),\)/\1\n  /g' "${dump}"
done
