#!/usr/bin/env python

from http.server import HTTPServer, BaseHTTPRequestHandler
import socket
from cgi import FieldStorage

# here are some tokens hardcoded in db

user_tokens = {
    ('oauth.master', 'p:>\\u25D5\\u203F\\u25D5'): 'AQAAAADue-GoAAAI22_eZKnwukAEhLSCzDr5FHk',
    ('oauth.slave', None): 'AQAAAADue-Q5AAAI2y-PfesoJ0lxsgZ0-Mgu5hY',
    ('oauth.greed', None): 'AQAAAADufFocAAAI28SCIYZQvUXmiZc9UCk8YnY',
    ('oauth.master', 'p: \\Testing\\"/\\\\<tester>( )\\u25D5\\u203F\\u25D5'): {
        'v2': 'AQAAAADue-GoAAAI26pbWQTsfUTwim3f9hRRARU',
        'v3': 'y2_AQAAAADue-GoAAAI2wAAAAAAV3OqeHh4eHh4eHh4eHh4eHh4eIzqTNg',
    },
    ('oauth.slave', 'Invisible meta'): 'AQAAAADue-Q5AAAI20IYn6MKEk_mrX3M0uIbimc',
    ('oauth.greed', 'another invisible meta'): 'AQAAAADufFocAAAI2-FHr27jFksykagQJoP9kXQ',
    ('oauth.master', 'Important login_id meta'): 'AgAAAADue-GoAAAI2zgCL5J2D0knvL5EuXxsIQk',
    ('child007', None): 'AgAAAAAAARVjAAAI2wuY0WdQ7kextjurYHpVm9A',
    ('fbi@xaker.ru', None): 'AgAAAAAAARVlAAAI28e1puDYwUa4pl3hgv9dCXU',
}

# client_credentials tokens by meta
client_cred = {
    'p:>\\u25D5\\u203F\\u25D5': 'AQAAAAAAAAAAAAAI22cxq8gcZkJ1k3NNtBXhLPs',
    'p: \\One more Testing\\"/\\\\<tester>( )\\u25D5\\u203F\\u25D5': 'AQAAAAAAAAAAAAAI2wOOz_pMVEW8p5yK_5M0CAA',
}


class ipv6HTTPServer(HTTPServer):
    address_family = socket.AF_INET6


class RequestHandler(BaseHTTPRequestHandler):
    def do_POST(self):
        form = FieldStorage(
            fp=self.rfile,
            headers=self.headers,
            environ={'REQUEST_METHOD': 'POST'},
        )
        print(form)
        token = None

        if form.getvalue('grant_type') == 'password':
            token = user_tokens.get((form.getvalue('username'), form.getvalue('x_meta')))
            if isinstance(token, dict):
                token = token[form.getvalue('__token_ver', 'v2')]

        elif form.getvalue('grant_type') == 'client_credentials':
            token = client_cred.get(form.getvalue('x_meta'))

        if token:
            print('Sent token', token)
            self.send_response(200)
            self.send_header('Content-type', 'application/json')
            self.end_headers()
            self.wfile.write(('{"access_token":"%s"}' % token).encode('utf-8'))
        else:
            self.send_error(418, 'Error: this parameters are not configured in oauth_mock server!')


def run_server(port):
    print('Starting "oauth" server at port %d' % port)
    server = ipv6HTTPServer(('', port), RequestHandler)
    server.serve_forever()


if __name__ == '__main__':
    from sys import argv, exit

    if len(argv) < 2:
        print('Usage: %s <port>' % argv[0])
        exit(1)

    run_server(int(argv[1]))
