#!/usr/bin/env python

from http.server import HTTPServer, BaseHTTPRequestHandler
import socket
import urllib.parse

# here are some data needed for test

sesskill_data = {}


def get_data():
    from time import time

    data = {}
    now = int(time())

    # see blackbox-sesskill.xml pre-test section
    authid = '1432300000000:CAgICA:7f'
    if authid not in data:
        data[authid] = {}

    for uid in ['10016', '1130000000000016']:
        data[authid][uid] = now + 60

    for uid in ['10015', '1130000000000015']:
        data[authid][uid] = now - 10

    return data


class ipv6HTTPServer(HTTPServer):
    address_family = socket.AF_INET6


class RequestHandler(BaseHTTPRequestHandler):
    def response(self, text):
        self.send_response(200)
        self.send_header('Content-type', 'text/plain')
        self.end_headers()
        self.wfile.write(text)

    def do_GET(self):
        print('GET:', self.path)

        if self.path.startswith('/ping'):
            self.response("pong".encode('utf-8'))
        elif self.path.startswith('/1/session/alive/'):
            query = urllib.parse.urlparse(self.path).query
            args = urllib.parse.parse_qs(query)

            authid = args['authid'][0]
            uids = args['uids'][0].split(',')

            if authid not in sesskill_data:
                self.response("".encode('utf-8'))
                return

            reply = ""

            for uid in uids:
                if uid in sesskill_data[authid]:
                    reply += "%s:%d\n" % (uid, sesskill_data[authid][uid])

            print('Sent reply:', reply)
            self.response(reply.encode('utf-8'))
        else:
            self.send_error(418, 'Error')


def run_server(port):
    print('Starting "sesskill" server at port %d' % port)
    server = ipv6HTTPServer(('', port), RequestHandler)
    server.serve_forever()


if __name__ == '__main__':
    from sys import argv, exit

    if len(argv) < 2:
        print('Usage: %s <port>' % argv[0])
        exit(1)

    sesskill_data = get_data()

    run_server(int(argv[1]))
