import json
import sys

SAS = "sas"
IVA = "iva"
MAN = "man"


SETTINGS = {
    "development": {
        "ENV": "development",
        "BLACKBOX_ENV": "test",
        "YT_CLUSTER": "seneca-sas",
        "YT_DIR": "//home/passport-hdb/development/historydb",
        "HISTORYDB_HOST": "kvs-loader-test-m1.passport.yandex.net",
        "HISTORYDB_PORT": 80,
        "HISTORYDB_CONSUMER": "passport",
        "SELF_TVM_ID": 2000016,
        "TABLE_TTL_USER_HISTORY": 5356800,
        "TABLE_TTL_CORP_USER_HISTORY": 2678400,
        "TABLE_TTL_PUSH": 2678400,
        "TABLE_TTL_AUTHS": 2678400,
        "AUTHS_YT_THRESHOLD": 0,
        "YASMS_SMS_HISTORY_FROM_YT": True,
    },
    "testing": {
        "ENV": "testing",
        "BLACKBOX_ENV": "test",
        "YT_CLUSTER": "seneca-vla",
        "YT_DIR": "//home/passport-hdb/testing/historydb",
        "HISTORYDB_HOST": "[::1]",
        "HISTORYDB_PORT": 9000,
        "HISTORYDB_CONSUMER": "localhost",
        "SELF_TVM_ID": 2000016,
        "TABLE_TTL_USER_HISTORY": 5356800,
        "TABLE_TTL_CORP_USER_HISTORY": 2678400,
        "TABLE_TTL_PUSH": 2678400,
        "TABLE_TTL_AUTHS": 5356800,
        "AUTHS_YT_THRESHOLD": 0,
        "YASMS_SMS_HISTORY_FROM_YT": True,
    },
    "production": {
        "ENV": "production",
        "BLACKBOX_ENV": "prod",
        "YT_CLUSTER": {
            SAS: "seneca-sas",
            IVA: "seneca-vla",
            MAN: "seneca-man",
        },
        "YT_DIR": "//home/passport-hdb/production/historydb",
        "HISTORYDB_HOST": "[::1]",
        "HISTORYDB_PORT": 9000,
        "HISTORYDB_CONSUMER": "localhost",
        "SELF_TVM_ID": 2027650,
        "TABLE_TTL_USER_HISTORY": 41708800,
        "TABLE_TTL_CORP_USER_HISTORY": 18408200,
        "TABLE_TTL_PUSH": 16070400,
        "TABLE_TTL_AUTHS": 64281600,
        "AUTHS_YT_THRESHOLD": 1657746000,
        "YASMS_SMS_HISTORY_FROM_YT": False,
    },
}


def do(template, env, dc):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    setts["GRANTS_PATH"] = "/usr/lib/yandex/historydb-grants/consumer_grants.{env}.json".format(env=env)
    for key, value in setts.items():
        if isinstance(value, dict):
            value = value[dc]
        template = template.replace('<<%s>>' % key, json.dumps(value))

    template = template.replace('<<__DC__>>', str(dc))

    if '<<' in template or '>>' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


def get_dc(hostname):
    if hostname.startswith('kvs-api-s'):
        return SAS
    if hostname.startswith('kvs-api-f'):
        return MAN
    if hostname.startswith('kvs-api-i'):
        return IVA

    if 'dev' in hostname or 'test' in hostname:
        return None

    raise Exception('Unconfigured DC for host: %s' % hostname)


if __name__ == '__main__':
    if len(sys.argv) != 4:
        print("Usage: %s <template_file> <env> <hostname>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2], get_dc(sys.argv[3]))
