package api

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/infra/daemons/historydb_api2/internal/grants"
)

func (s *API) LastAuthHandler() echo.HandlerFunc {
	return func(c echo.Context) error {
		consumer, err := s.grants.GetConsumer(c)
		if err != nil {
			return s.sendErrorResponse(c, err)
		}
		if err = consumer.CheckAllowed(grants.KeyLastAuth, false); err != nil {
			return s.sendErrorResponse(c, err)
		}

		uid, err := getRequiredUIntParam(c.Request().URL.Query(), "uid", []uintValidator{&uintPositiveValidator})
		if err != nil {
			return s.sendErrorResponse(c, err)
		}

		result, err := s.yt.GetLastAuth(c.Request().Context(), uid)
		if err != nil {
			return s.sendErrorResponse(c, err)
		}

		return c.JSON(http.StatusOK, result)
	}
}

func (s *API) LastAuthBulkHandler() echo.HandlerFunc {
	return func(c echo.Context) error {
		consumer, err := s.grants.GetConsumer(c)
		if err != nil {
			return s.sendErrorResponse(c, err)
		}
		if err = consumer.CheckAllowed(grants.KeyLastAuth, false); err != nil {
			return s.sendErrorResponse(c, err)
		}

		uids, err := getUIntListValue(c.Request().URL.Query(), "uids")
		if err != nil {
			return s.sendErrorResponse(c, err)
		}

		result, err := s.yt.GetLastAuthBulk(c.Request().Context(), uids)
		if err != nil {
			return s.sendErrorResponse(c, err)
		}

		return c.JSON(http.StatusOK, result)
	}
}
