package api

import (
	"fmt"
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/passport/infra/daemons/historydb_api2/internal/errs"
	"a.yandex-team.ru/passport/infra/daemons/historydb_api2/internal/grants"
	"a.yandex-team.ru/passport/infra/daemons/historydb_api2/internal/reqs"
)

func ParseLastLetterRequest(c echo.Context) (*reqs.SenderLastLetterRequest, error) {
	ut := tvm.ContextUserTicket(c.Request().Context())
	if ut == nil {
		return nil, &errs.InvalidParamError{
			ScalaKey:  xYaUserTicket,
			ScalaCode: errs.ScalaErrorRequired,
			Message:   fmt.Sprintf("missing header: '%s'", xYaUserTicket),
		}
	}

	maxAge, err := getRequiredUIntParam(c.Request().URL.Query(), "max_age", nil)
	if err != nil {
		return nil, err
	}

	return &reqs.SenderLastLetterRequest{
		UID:    uint64(ut.DefaultUID),
		MaxAge: maxAge,
	}, nil
}

func (s *API) LastLetterHandler() echo.HandlerFunc {
	return func(c echo.Context) error {
		consumer, err := s.grants.GetConsumer(c)
		if err != nil {
			return s.sendErrorResponse(c, err)
		}
		if err = consumer.CheckAllowed(grants.KeySenderLastLetter, false); err != nil {
			return s.sendErrorResponse(c, err)
		}

		req, err := ParseLastLetterRequest(c)
		if err != nil {
			return s.sendErrorResponse(c, err)
		}

		result, err := s.yt.GetSenderLastLetter(c.Request().Context(), req)
		if err != nil {
			return s.sendErrorResponse(c, err)
		}

		return c.JSON(http.StatusOK, result)
	}
}
