package errs

import "fmt"

type ScalaStatus string

const (
	ScalaStatusOk    ScalaStatus = "ok"
	ScalaStatusError ScalaStatus = "error"
)

type ScalaErrorCode string

const (
	ScalaErrorRequired ScalaErrorCode = "error.required"
	ScalaErrorNumber   ScalaErrorCode = "error.number"
	ScalaErrorBoolean  ScalaErrorCode = "error.boolean"
	ScalaErrorUnknown  ScalaErrorCode = "error.unknown"
	ScalaErrorMin      ScalaErrorCode = "error.min"
	ScalaErrorMax      ScalaErrorCode = "error.max"
)

type InvalidParamError struct {
	Message   string
	ScalaKey  string
	ScalaCode ScalaErrorCode
}

func (e *InvalidParamError) Error() string {
	return e.Message
}

type BadRequestError struct {
	Message string
}

func (e *BadRequestError) Error() string {
	return e.Message
}

type AccessDeniedError struct {
	Message      string
	Description  string
	TicketStatus string
	LoggablePart string
}

func (e *AccessDeniedError) Error() string {
	if e.TicketStatus != "" || e.Description != "" {
		return fmt.Sprintf("%s. status=%s. desc=%s", e.Message, e.TicketStatus, e.Description)
	} else {
		return e.Message
	}
}

type TemporaryErrorType string

const (
	DecryptError TemporaryErrorType = "decrypt"
)

type TemporaryError struct {
	Type    TemporaryErrorType
	Message string
}

func (e *TemporaryError) Error() string {
	return fmt.Sprintf("Temporary error: [%s] %s", e.Type, e.Message)
}
