package grants

import (
	"sync"
	"time"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/passport/infra/libs/go/grantnets"
)

type Config struct {
	Path   string `json:"path"`
	Period uint32 `json:"period_sec"`
}

type Grants struct {
	cfg Config

	lastMTime time.Time

	mutex *sync.RWMutex
	state *State
}

type State struct {
	consumers map[string]*Consumer
}

type Consumer struct {
	name        string
	tvmClientID *tvm.ClientID
	nets        *grantnets.Nets
	keys        map[string]interface{}
}
