package resps

import "a.yandex-team.ru/passport/infra/daemons/historydb_api2/internal/errs"

type EventsResult struct {
	Status errs.ScalaStatus         `json:"status"`
	UID    uint64                   `json:"uid"`
	Events []map[string]interface{} `json:"events"`
}

type EventsRestoreResult struct {
	Status errs.ScalaStatus `json:"status"`
	UID    uint64           `json:"uid"`
	Events []*RestoreEvent  `json:"restore_events"`
}

type RestoreEvent struct {
	Timestamp float64 `json:"timestamp"`
	Action    string  `json:"action"`
	RestoreID string  `json:"restore_id"`
	DataJSON  string  `json:"data_json"`
}

type EventsByIPRegistrationsResult struct {
	Status errs.ScalaStatus         `json:"status"`
	SubNet string                   `json:"subnet"`
	Events []map[string]interface{} `json:"registrations"`
}

type EventsPasswordsResult struct {
	Status errs.ScalaStatus `json:"status"`
	Found  bool             `json:"password_found"`
	Ranges [][2]*float64    `json:"active_ranges"`
}
