package ytc

import "time"

type MonthlyTables struct {
	from    time.Time
	to      time.Time
	current time.Time
}

func NewMonthlyTables(from, to uint64) MonthlyTables {
	return MonthlyTables{
		from: time.Unix(int64(from), 0),
		to:   time.Unix(int64(to), 0),
	}
}

func (m *MonthlyTables) Next() bool {
	if m.current.IsZero() {
		m.current = time.Date(m.to.Year(), m.to.Month(), 1, 0, 0, 0, 0, time.Local)
		return m.from.Before(m.to)
	}

	m.current = m.current.AddDate(0, -1, 0)
	if m.from.Before(m.current) {
		return true
	}

	curYear, curMonth, _ := m.current.Date()
	fromYear, fromMonth, _ := m.from.Date()

	return curYear == fromYear && curMonth == fromMonth
}

func (m *MonthlyTables) TableName() string {
	return m.current.Format("2006-01")
}
