package ytc

import (
	"context"
	"fmt"
	"sync"
	"time"

	"a.yandex-team.ru/passport/infra/libs/go/ytsimple"
	"a.yandex-team.ru/yt/go/yt"
)

const (
	pingQueryTemplate = `%s FROM [%s] LIMIT 1`
)

func pingQuery(pingColumn string, elem ...string) string {
	return fmt.Sprintf(pingQueryTemplate, pingColumn, buildNodePath(elem...))
}

func (c *Client) Ping(ctx context.Context) error {
	// TODO: make more useful

	tables := MonthlyTables{current: time.Now()}

	queries := []string{
		pingQuery("uid", c.dir, userHistoryDir, tables.TableName()),
		pingQuery("uid", c.dir, corpUserHistoryDir, tables.TableName()),
		pingQuery("uid", c.dir, senderLastLetterTable),
		pingQuery("uid", c.dir, authsDir, tables.TableName()),
		pingQuery("uid", c.dir, failedAuthsTable),
		pingQuery("uid", c.dir, lastAuthTable),
		pingQuery("uid", c.dir, restoreTable),
		pingQuery("uid", c.dir, pushSubscriptionTable),
		pingQuery("push_id", c.dir, pushDir, tables.TableName()),
		pingQuery("push_id", c.dir, pushByUIDDir, tables.TableName()),
		pingQuery("push_id", c.dir, pushByAppIDDir, tables.TableName()),
		pingQuery("push_id", c.dir, pushByDeviceIDDir, tables.TableName()),
		pingQuery("global_sms_id", c.dir, yasmsSmsHistoryTable),
		pingQuery("global_sms_id", c.dir, yasmsSmsHistoryByPhoneTable),
		pingQuery("global_sms_id", c.dir, yasmsSmsHistoryByUIDTable),
	}
	errs := make([]error, len(queries))

	var wg sync.WaitGroup
	for idx := range queries {
		wg.Add(1)

		go func(idx int) {
			errs[idx] = c.pingImpl(ctx, queries[idx])
			wg.Done()
		}(idx)
	}
	wg.Wait()

	for _, err := range errs {
		if err != nil {
			return err
		}
	}

	return nil
}

func (c *Client) pingImpl(ctx context.Context, query string) error {
	var err error

	start := time.Now()
	defer func() {
		c.unistat.responseTimings.Insert(time.Since(start))
		if err != nil {
			c.unistat.errs.Inc()
		}
	}()

	c.unistat.requests.Inc()
	return ytsimple.SelectAll(ctx, c.yc, query, c.timeout, func(reader yt.TableReader) error {
		var dummy map[string]interface{}
		return ytsimple.ScanRow(reader, &dummy)
	})
}
