package ytc

import (
	"context"
	"fmt"
	"time"

	"a.yandex-team.ru/passport/infra/daemons/historydb_api2/internal/errs"
	"a.yandex-team.ru/passport/infra/daemons/historydb_api2/internal/reqs"
	"a.yandex-team.ru/passport/infra/libs/go/ytsimple"
	"a.yandex-team.ru/yt/go/yt"
)

type PushSubscriptionRow struct {
	AppID     string `yson:"app_id"`
	DeviceID  string `yson:"device_id"`
	Timestamp int64  `yson:"timestamp"`
	Count     uint64 `yson:"count"`
}

const (
	pushSubscriptionTable = "push_subscription/push_subscription"
)

func (c *Client) GetPushSubscription(ctx context.Context, req *reqs.PushSubscriptionRequest) ([]PushSubscriptionRow, error) {
	var err error
	start := time.Now()
	defer func() {
		c.unistat.responseTimings.Insert(time.Since(start))
		if err != nil {
			c.unistat.errs.Inc()
		}
	}()

	c.unistat.requests.Inc()
	query := buildPushSubscriptionQuery(req, c.dir, time.Now())
	rows := make([]PushSubscriptionRow, 0, 100)

	err = ytsimple.SelectAll(ctx, c.yc, query, c.timeout, func(reader yt.TableReader) error {
		row := PushSubscriptionRow{}
		if err := ytsimple.ScanRow(reader, &row); err != nil {
			return err
		}

		rows = append(rows, row)
		return nil
	})
	if err != nil {
		return nil, &errs.TemporaryError{
			Message: fmt.Sprintf("Failed to fetch sender last letter from YT: %v", err),
		}
	}

	return rows, nil
}

func buildPushSubscriptionQuery(req *reqs.PushSubscriptionRequest, dir string, now time.Time) string {
	return fmt.Sprintf(`
app_id,device_id,timestamp,count
FROM [%s]
WHERE uid = %d AND timestamp > %d`,
		buildNodePath(dir, pushSubscriptionTable),
		req.UID,
		now.Unix()-int64(req.MaxAge),
	)
}
