package ytc

type TablesTTLConfig struct {
	UsersHistory     uint64 `json:"users_history_table_ttl__sec"`
	CorpUsersHistory uint64 `json:"corp_users_history_table_ttl__sec"`
	Push             uint64 `json:"push_table_ttl__sec"`
	Auths            uint64 `json:"auths_table_ttl__sec"`

	FutureFrontier uint64 `json:"future_frontier__sec"`
}

func (c *TablesTTLConfig) chooseUsersHistoryTTL(corp bool) uint64 {
	if corp {
		return c.CorpUsersHistory
	}
	return c.UsersHistory
}

func (c *TablesTTLConfig) getFromTS(fromTSRequested, ttl, now uint64) uint64 {
	fromTSMin := now - ttl
	if fromTSMin > fromTSRequested {
		return fromTSMin
	}
	return fromTSRequested
}

func (c *TablesTTLConfig) getToTS(toTSRequested, now uint64) uint64 {
	toTSMax := now + c.FutureFrontier
	if toTSMax < toTSRequested {
		return toTSMax
	}
	return toTSRequested
}

func (c *TablesTTLConfig) getMonthlyTables(fromTS, toTS, ttl, now uint64) MonthlyTables {
	return NewMonthlyTables(c.getFromTS(fromTS, ttl, now), c.getToTS(toTS, now))
}

func (c *TablesTTLConfig) getAllMonthlyTables(ttl, now uint64) MonthlyTables {
	return c.getMonthlyTables(0, now+c.FutureFrontier, ttl, now)
}
