package ytc

import (
	"strconv"
	"strings"
)

func reverseUnixtime(val uint64) uint64 {
	return uint64(0x7fffffffffffffff) - val
}

func reverseUnixtimeMicro(val uint64) uint64 {
	return reverseUnixtime(val * 1000000)
}

func serializeUIntListIN(arr []uint64) string {
	strArr := make([]string, 0, len(arr))
	for _, elem := range arr {
		strArr = append(strArr, strconv.FormatUint(elem, 10))
	}

	return strings.Join(strArr, ",")
}

func serializeConditionIN(arr []string) string {
	escaped := make([]string, 0, len(arr))
	for i := range arr {
		escaped = append(escaped, escapeString(arr[i]))
	}

	return strings.Join(escaped, ",")
}

func orderByString(ascending bool) string {
	if ascending {
		return "ASC"
	}
	return "DESC"
}

func escapeString(val string) string {
	return strconv.Quote(val)
}

func buildNodePath(elem ...string) string {
	return strings.Join(elem, "/")
}

func reverse[Slice ~[]Item, Item any](s Slice) {
	for i, j := 0, len(s)-1; i < j; i, j = i+1, j-1 {
		s[i], s[j] = s[j], s[i]
	}
}

func max(a, b uint64) uint64 {
	if a > b {
		return a
	}
	return b
}

func min(a, b uint64) uint64 {
	if a < b {
		return a
	}
	return b
}
