#pragma once

#include <library/cpp/tvmauth/type.h>

#include <util/datetime/base.h>
#include <util/generic/hash.h>

#include <map>
#include <memory>

namespace NTvmAuth {
    class TTvmClient;
}

namespace NPassport::NJuggler {
    class TStatus;
}

namespace NPassport::NKolmogor {
    struct TAuthSettings {
        NTvmAuth::TTvmId SelfTvmId = 0;
    };

    class TAuth {
    public:
        using TAllowedServices = TSmallVec<NTvmAuth::TTvmId>;

        static const TString SELF_ALIAS;

        TAuth(std::unique_ptr<NTvmAuth::TTvmClient> tvmClient,
              const TAuthSettings& cfg);
        ~TAuth();

        NJuggler::TStatus GetStatus() const;

        void AddAcl(TString space, const TAllowedServices& clients);

        std::optional<ui32> GetSrcFromServiceTicket(TStringBuf ticket) const;

        void CheckServiceTicketForReplication(TStringBuf ticket) const;
        TString GetServiceTicketForReplication() const;

        void CheckServiceTicket(std::optional<ui32> tvmid, const TSmallVec<TStringBuf>& spaces) const;
        void CheckRequiredServiceTicket(std::optional<ui32> tvmid, const TString& space) const;

    private:
        static void CheckServiceTicketImpl(std::optional<ui32> tvmid, const TAllowedServices& s, TStringBuf msg);

    protected:
        using TAcl = THashMap<TString, TAuth::TAllowedServices>;

        const TAllowedServices SelfClientId_;
        TAcl Acl_;

        std::unique_ptr<NTvmAuth::TTvmClient> TvmClient_;
    };
}
