#include "utils.h"

#include "exception.h"

#include <util/generic/string.h>
#include <util/string/split.h>
#include <util/system/fs.h>

namespace NPassport::NKolmogor {
    void TUtils::Split(TStringBuf str, char delim, TStrVec& vec) {
        vec.clear();
        while (str) {
            TStringBuf s = str.NextTok(delim);
            if (!s) {
                throw TBadRequestException() << "Empty key is not allowed";
            }
            vec.push_back(TString(s));
        }
    }

    bool TUtils::IsForceDown(const TString& filename) {
        return !filename.empty() && NFs::Exists(filename);
    }
}
