#include "eraseall_request.h"

#include <passport/infra/daemons/kolmogor/src/common/exception.h>

#include <passport/infra/libs/cpp/json/reader.h>
#include <passport/infra/libs/cpp/utils/log/global.h>
#include <passport/infra/libs/cpp/utils/string/coder.h>

namespace NPassport::NKolmogor::NV2 {
    TEraseAllRequest TEraseAllParser::Parse(const TString& body) {
        rapidjson::Document doc;
        if (!NJson::TReader::DocumentAsObject(body, doc)) {
            TLog::Debug() << "Bad json (base64): " << NUtils::BinToBase64(body);
            throw TBadRequestException() << "Invalid json";
        }

        TEraseAllRequest req;
        if (!NJson::TReader::MemberAsString(doc, "space", req.SpaceName)) {
            throw TBadRequestException() << "Failed to get 'space' from request";
        }

        return req;
    }

}
