#pragma once

#include <passport/infra/daemons/kolmogor/src/common/type.h>

namespace NPassport::NKolmogor::NV2 {
    struct TGetRequest { // NOLINT(bugprone-exception-escape)
        struct TSpace {
            TString Name;
            TStrVec Keys;

            bool operator==(const TSpace& o) const {
                return Name == o.Name && Keys == o.Keys;
            }
        };
        TStackVec<TSpace, 4> Req;

        bool operator==(const TGetRequest& o) const {
            return Req == o.Req;
        }
    };

    class TGetParser {
    public:
        static TGetRequest Parse(const TString& body);
    };
}
