#pragma once

#include <passport/infra/daemons/kolmogor/src/common/type.h>

#include <optional>

namespace NPassport::NKolmogor::NV2 {
    struct TIncRequest { // NOLINT(bugprone-exception-escape)
        struct TKeySet {
            TStrVec Keys;
            std::optional<ui64> IncIfLessThan;

            bool operator==(const TKeySet& o) const {
                return Keys == o.Keys && IncIfLessThan == o.IncIfLessThan;
            }
        };

        struct TSpace {
            TString Name;
            std::vector<TKeySet> Keysets;
            size_t KeysCount = 0;

            bool operator==(const TSpace& o) const {
                return Name == o.Name && Keysets == o.Keysets && KeysCount == o.KeysCount;
            }
        };
        TStackVec<TSpace, 4> Req;

        bool operator==(const TIncRequest& o) const {
            return Req == o.Req;
        }
    };

    class TIncParser {
    public:
        static TIncRequest Parse(const TString& body);
    };
}
